/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.gui;

import cerent.cms.ui.functional.FunctMenuBar;
import cerent.util.view.fv.helper.FunctException;
import com.cisco.fv.gui.FunctionalMenuToolbarCreator;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import com.cisco.fv.gui.FunctionalNetworkToolBar;
import com.cisco.fv.gui.NfvMenuToolListener;
import com.cisco.fv.gui.dockFrame.FrameMenuToolBar;
import java.awt.Component;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;

public class NfvMenuToolBar {
    private static final int BUTTON_POS = 0;
    private static final int MENU_POS = 1;
    private FunctionalNetworkToolBar toolBar;
    private FunctMenuBar menuBar;
    private NfvMenuToolListener listener;
    private SyncButton powerButtons;
    private SyncButton spanLossButtons;
    private SyncButton magnifyButtons;
    private SyncButton pvButton;
    private AbstractButton[] refreshButtons;

    public NfvMenuToolBar(FunctionalNetworkDialog functionalNetworkDialog, Container container, Component component) throws FunctException {
        this.listener = new NfvMenuToolListener(functionalNetworkDialog, this);
        this.menuBar = new FunctMenuBar(this.listener);
        this.listener.addMenu(this.menuBar);
        this.toolBar = new FunctionalNetworkToolBar(this.listener, component);
        this.menuBar.createMenuBar(true, true);
        functionalNetworkDialog.getFrame().setJMenuBar(this.menuBar);
        FunctionalMenuToolbarCreator functionalMenuToolbarCreator = new FunctionalMenuToolbarCreator(this.menuBar, (JToolBar)((Object)this.toolBar), this.listener);
        this.addExtraButton(functionalMenuToolbarCreator);
        functionalMenuToolbarCreator.addOtherMenuToolbar(new FrameMenuToolBar(this.menuBar));
        this.menuBar.creatHelpMenuBar();
        container.add((Component)((Object)this.toolBar), "North");
    }

    private void addExtraButton(FunctionalMenuToolbarCreator functionalMenuToolbarCreator) {
        this.menuBar.addMenu("Print", 80);
        this.menuBar.addMenu("View", 86);
        this.menuBar.addMenu("Tools", 84);
        functionalMenuToolbarCreator.addMenuAndToolBarToggle("View", "/images/icons/FVResetZoom.gif", "Reset Nodes Zoom", 90);
        functionalMenuToolbarCreator.addMenuAndToolBar("View", "/ilog/views/swing/showall.gif", "Fit to View", 86);
        functionalMenuToolbarCreator.addMenuAndToolBar("Print", "/ilog/views/util/print/resources/printer.gif", "Print...", 80);
        functionalMenuToolbarCreator.addMenuBar("File", "/images/icons/export16.gif", "Export...", 79);
        functionalMenuToolbarCreator.addMenuBar("Print", "/ilog/views/util/print/resources/printer.gif", "Print to Bitmap", 66);
        functionalMenuToolbarCreator.addMenuBar("Print", "/ilog/views/swing/select.gif", "Select area to print", 83);
        functionalMenuToolbarCreator.addMenuBar("Print", null, "Clear selected area", 67);
        this.magnifyButtons = new SyncButton(functionalMenuToolbarCreator.addMenuAndToolBarToggle("View", "/ilog/views/interactor/beans/images/IlvMagnifyInteractorColor16.gif", "Magnifier", 77));
        this.powerButtons = new SyncButton(functionalMenuToolbarCreator.addMenuAndToolBarToggle("Tools", "/images/icons/FVPower.gif", "Show Power", 80));
        this.spanLossButtons = new SyncButton(functionalMenuToolbarCreator.addMenuAndToolBarToggle("Tools", "/images/icons/FVSpanLoss.gif", "Show SpanLoss", 80));
        this.pvButton = new SyncButton(functionalMenuToolbarCreator.addMenuAndToolBarToggle("Tools", "/images/icons/FVPatchVerify.gif", "Verify Patchcords", 86));
        this.refreshButtons = functionalMenuToolbarCreator.addMenuAndToolBarToggle("Tools", "/images/icons/FVrefresh.gif", "Refresh Power Info", 82);
        functionalMenuToolbarCreator.addMenuAndToolBarToggle("Tools", "/images/icons/FVCloseAll.gif", "Close Expanded Nodes", 65);
    }

    public void enableButtons(boolean bl) {
        if (this.powerButtons != null) {
            this.powerButtons.setEnabled(bl);
        }
        if (this.spanLossButtons != null) {
            this.spanLossButtons.setEnabled(bl);
        }
        if (this.pvButton != null) {
            this.pvButton.setEnabled(bl);
        }
        if (this.refreshButtons != null) {
            for (int i = 0; i < this.refreshButtons.length; ++i) {
                if (this.refreshButtons[i] == null) continue;
                this.refreshButtons[i].setEnabled(bl);
            }
        }
    }

    public void destroy() {
        if (this.powerButtons != null) {
            this.powerButtons.removeActionListener(0, this.listener);
        }
        if (this.spanLossButtons != null) {
            this.spanLossButtons.removeActionListener(0, this.listener);
        }
        if (this.magnifyButtons != null) {
            this.magnifyButtons.removeActionListener(0, this.listener);
        }
        if (this.pvButton != null) {
            this.pvButton.removeActionListener(0, this.listener);
        }
        this.listener.destroy();
        this.listener = null;
    }

    public boolean synchronizeButtons(AbstractButton abstractButton) throws NfvMenuTollBarException {
        if (this.pvButton != null && this.pvButton.synch(abstractButton)) {
            return this.pvButton.isPressed();
        }
        if (this.spanLossButtons != null && this.spanLossButtons.synch(abstractButton)) {
            return this.spanLossButtons.isPressed();
        }
        if (this.powerButtons != null && this.powerButtons.synch(abstractButton)) {
            return this.powerButtons.isPressed();
        }
        if (this.magnifyButtons != null && this.magnifyButtons.synch(abstractButton)) {
            return this.magnifyButtons.isPressed();
        }
        throw new NfvMenuTollBarException(abstractButton.getName() + " is a non Valid Button ");
    }

    public class NfvMenuTollBarException
    extends Exception {
        public NfvMenuTollBarException(String string) {
            super(string);
        }
    }

    private class SyncButton {
        AbstractButton[] button;
        private boolean pressed;

        public boolean isPressed() {
            return this.pressed;
        }

        public void removeActionListener(int n, NfvMenuToolListener nfvMenuToolListener) {
            this.button[n].removeActionListener(nfvMenuToolListener);
        }

        public boolean synch(AbstractButton abstractButton) {
            for (int i = 0; i < this.button.length; ++i) {
                if (this.button[i] == null || this.button[i] != abstractButton) continue;
                if (i == 1) {
                    this.pressed = !this.pressed;
                    this.button[0].setSelected(this.pressed);
                } else {
                    this.pressed = abstractButton.isSelected();
                }
                return true;
            }
            return false;
        }

        public void setEnabled(boolean bl) {
            for (int i = 0; i < this.button.length; ++i) {
                if (this.button[i] == null) continue;
                this.button[i].setEnabled(bl);
            }
        }

        public SyncButton(AbstractButton[] abstractButtonArray) {
            this.button = abstractButtonArray;
            this.pressed = false;
        }
    }
}

