/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.util;

import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.LauncherInterfaceVersion;
import cerent.version.NetInterfaceVersion;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;

public class CtcRelauncher {
    private static SDebug db = new SDebug("CtcRelauncher");
    private static final String PROP_RELAUNCH = "ctc.relaunch";

    public static boolean checkLauncher() {
        boolean bl = false;
        try {
            bl = Checker.checkLauncher();
        }
        catch (Throwable throwable) {
            db.println("Bad Launcher -- relaunch imminent.");
            SDebug.printStackTrace((Throwable)throwable);
        }
        return bl;
    }

    private static Object[] getAppletArguments(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = "-Dctc.relaunch=true";
        return new Object[]{stringArray2};
    }

    public static void reLaunch(String[] stringArray) {
        if (Boolean.getBoolean(PROP_RELAUNCH)) {
            ErrorMsg.displayError((Component)CtcRelauncher.getFrame(), (EID)NEMC.EID_CTC_RELAUNCH_FAILURE_PARAM_1, (Object)"Cannot relaunch a relaunched CTC.");
        } else {
            String string = CtcRelauncher.getCachedLauncherName();
            db.println("reLaunch(): launcherName=" + string);
            ClassLoader classLoader = CtcRelauncher.getClassLoader(string);
            db.println("reLaunch(): lcl=" + classLoader);
            try {
                Class<?> clazz = classLoader.loadClass("cerent.launcher.CtcLauncherApplet");
                Method method = clazz.getMethod("main", stringArray.getClass());
                method.setAccessible(true);
                method.invoke(null, CtcRelauncher.getAppletArguments(stringArray));
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)CtcRelauncher.getFrame(), (EID)NEMC.EID_CTC_RELAUNCH_FAILURE_PARAM_1, (Object)("Unexpected error: " + exception.getMessage()));
            }
        }
        System.exit(0);
    }

    private static String getIniFileName() {
        String string = System.getProperty("user.home");
        String string2 = string + File.separator;
        string2 = File.separator.equals("/") ? string2 + ".ctclaunchrc" : string2 + "CTCLauncher.ini";
        return string2;
    }

    private static String getCachedLauncherName() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(CtcRelauncher.getIniFileName()));
            return properties.getProperty("ctc.launcher.ctc-jar-launcher");
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
            ErrorMsg.displayError((Component)CtcRelauncher.getFrame(), (EID)NEMC.EID_FILE_NOT_FOUND_OR_IO_EX_PARAM_1, (Object)"Cannot find cached launcher name.");
            return null;
        }
    }

    private static ClassLoader getClassLoader(String string) {
        try {
            return new URLClassLoader(new URL[]{new File(string).toURL()}, null);
        }
        catch (MalformedURLException malformedURLException) {
            SDebug.printStackTrace((Throwable)malformedURLException);
            ErrorMsg.displayError((Component)CtcRelauncher.getFrame(), (EID)NEMC.EID_CTC_RELAUNCH_FAILURE_PARAM_1, (Object)"Unable to find class loader.");
            return null;
        }
    }

    private static Frame getFrame() {
        return null;
    }

    private static class Checker {
        private Checker() {
        }

        public static boolean checkLauncher() {
            LauncherInterfaceVersion launcherInterfaceVersion = new LauncherInterfaceVersion();
            NetInterfaceVersion netInterfaceVersion = new NetInterfaceVersion();
            return netInterfaceVersion.isCompatibleWith((AbstractInterfaceVersion)launcherInterfaceVersion);
        }
    }
}

