/*
 * Decompiled with CFR 0.152.
 */
package cerent.launcher;

import cerent.launcher.CmsClassLoader;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.NoMainClassAttributeException;
import cerent.util.DebugManager;
import cerent.util.EncryptionException;
import cerent.util.IDecrypter;
import cerent.util.IPAddressTranslator;
import cerent.util.KDebug;
import cerent.util.PBEEncrypter;
import cerent.util.Preferences;
import cerent.util.RotatingLogOutputStream;
import cerent.util.proxy.CtcProxyFactory;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreClassLoadersSetupUtil;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.sot.Tl1Tunnel;
import com.cisco.sot.Tl1TunnelAddr;
import com.cisco.sot.Tl1TunnelDialog;
import com.cisco.sot.Tl1TunnelFactory;
import java.awt.GraphicsEnvironment;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.Permission;
import javax.swing.JOptionPane;

public class Bootstrap {
    private static final String CTC = "ctc";
    private static final String SOTL1 = "sotl1";
    private static final String SOTL1_ADDR = "sotl1.address";
    private static final String SOTL1_USER = "sotl1.user";
    private static final String SOTL1_PASSWD = "sotl1.password";
    private static final String SOTL1_PASSWD_PLAINTEXT = "sotl1.password.plaintext";
    private static final String LOGIN_NODEID = "login.nodeid";
    private static IDecrypter decrypter = null;
    private static final String CONSOLE_AVAILABLE = "ctc.console.available";
    private static final String LOG_DIR = "logFile.directory";
    private static final String LOG_PREFIX = "logFile.prefix";
    private static final String LOG_NUM_LOGS = "logFile.numLogs";
    private static final int DEFAULT_NUM_LOGS = 5;
    private static final String RMI_SECURITY_MGR = "rmisecuritymgr";
    private static KDebug db = null;
    private static String STARTUP_FATAL_STRING = "Fatal error: cannot create NET class loader";
    private static PrintStream output = null;
    private static WeakReference<ClassLoader> icl_ = null;
    private static ICoreVersionUtil cvu;
    private static CoreClassLoadersSetupUtil cs;

    public static void main(String[] stringArray) {
        try {
            Preferences.instance();
            DebugManager.init(Boolean.getBoolean(CONSOLE_AVAILABLE));
            db = new KDebug("Bootstrap", true);
            cvu = CoreVersionUtil.instance();
            cs = CoreClassLoadersSetupUtil.instance();
            Bootstrap.initLogging();
            Bootstrap.begin(stringArray);
        }
        catch (NoMainClassAttributeException noMainClassAttributeException) {
            Bootstrap.fatal("'Main-Class:' missing from JAR manifest", noMainClassAttributeException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Bootstrap.fatal("Load class failed to load a class", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            Bootstrap.fatal("cannot access the 'main(String[])' method", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException);
            Bootstrap.fatal("failed to instantiate a class loader", instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException + ": " + noSuchMethodException.getMessage());
            Bootstrap.fatal("'setParent(CmsClassLoader)' not in ElementFactory OR 'main(String[])' not in class tagged as Main-Class", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getTargetException().printStackTrace();
            Bootstrap.fatal("failed to invoke 'main(String[])'", invocationTargetException);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            Bootstrap.fatal("invalid URL parts on command line", malformedURLException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            Bootstrap.fatal("I/O error while caching JAR", iOException);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            Bootstrap.fatal("Error starting CTC", exception);
        }
    }

    private static void initLogging() throws IOException {
        if (!Boolean.getBoolean(CONSOLE_AVAILABLE)) {
            Preferences preferences = Preferences.instance();
            preferences.init();
            String string = preferences.getProperty(CTC, LOG_DIR, System.getProperty("user.home"));
            String string2 = preferences.getProperty(CTC, LOG_PREFIX, "ctc-log");
            int n = preferences.getInt(CTC, LOG_NUM_LOGS, 5);
            System.out.close();
            output = new PrintStream(new RotatingLogOutputStream(string, string2, n));
            System.setOut(output);
            System.setIn(null);
            System.setErr(output);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    Bootstrap.shutdownHook(output);
                }
            }));
            preferences.setProperty(CTC, LOG_DIR, string);
            preferences.setProperty(CTC, LOG_PREFIX, string2);
            preferences.setInt(CTC, LOG_NUM_LOGS, n);
        }
    }

    private static void shutdownHook(PrintStream printStream) {
        if (printStream != null) {
            printStream.close();
        }
    }

    private Bootstrap() {
    }

    private static void initParameters(String[] stringArray, ParametersHolder parametersHolder) throws IOException {
        String[] stringArray2;
        String string;
        String string2;
        String string3;
        Preferences.instance().init();
        if (stringArray.length > 0) {
            string3 = stringArray[0];
            string2 = Preferences.instance().getProperty(CTC, LOGIN_NODEID, "0");
            long l = 0L;
            int n = 0;
            if (string2 != null && string2.length() > 0) {
                int n2 = 0;
                try {
                    n2 = Integer.decode(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n2 == 0) {
                    l = Long.decode(string2) & 0xFFFFFFFFFFFFFFFFL;
                    n = (int)l;
                } else {
                    n = n2;
                }
            }
            InetAddress inetAddress = IPAddressTranslator.instance().getVirtualAddress(string3, n);
            string = inetAddress.getHostAddress();
            stringArray2 = stringArray;
            CtcProxyFactory.setPermGne(string3);
        } else {
            string = null;
            stringArray2 = new String[]{};
        }
        parametersHolder.host = string;
        parametersHolder.parameters = stringArray2;
        if (string != null) {
            string3 = CtcHttpRetriever.getNeType(string);
            string2 = CtcHttpRetriever.getApiVersion(string);
            Comparable comparable = cvu.createNeVersionOrdinal(string2);
            parametersHolder.neVersionOrdinal = cvu.createVersionOrdinal(ClassLoaderEnum.SYSTEM, comparable);
            parametersHolder.netype = NETypeEnum.getType(string3, cvu.isUnifiedCore(parametersHolder.neVersionOrdinal));
        } else {
            parametersHolder.netype = NETypeEnum.NE_DONT_CARE;
            parametersHolder.neVersionOrdinal = null;
        }
    }

    public static boolean isUnifiedEle(String string) {
        return string.compareTo("04.70") >= 0;
    }

    public static ClassLoader getIFClassLoader() {
        return icl_ == null ? null : (ClassLoader)icl_.get();
    }

    public static ClassLoader initClassLoaders(String[] stringArray) throws NoMainClassAttributeException, Exception, IOException {
        ParametersHolder parametersHolder = new ParametersHolder();
        Bootstrap.initParameters(stringArray, parametersHolder);
        return Bootstrap.initClassLoaders(parametersHolder);
    }

    private static final ClassLoader initClassLoaders(ParametersHolder parametersHolder) throws NoMainClassAttributeException, Exception, IOException {
        Object object;
        Preferences preferences = Preferences.instance();
        String string = parametersHolder.host;
        String string2 = CtcHttpRetriever.makeUrl(string).toString();
        if (db.on()) {
            db.println("Loading IF.jar from " + CtcHttpRetriever.getActualURLDisplay(string2));
        }
        ClassLoader classLoader = cs.setup(parametersHolder.host, parametersHolder.neVersionOrdinal);
        System.out.println("Core setup done");
        if (IPAddressTranslator.instance().isEnabled()) {
            System.out.println("Duplicate IP mode is enabled");
        }
        ClassLoader classLoader2 = classLoader.getParent();
        ClassLoader classLoader3 = classLoader2.getParent();
        db.println("SYSTEM CL=" + classLoader3);
        String string3 = CmsClassLoader.getDebugString((URLClassLoader)classLoader3);
        db.println("SYSTEM CL CPs=" + string3);
        icl_ = new WeakReference<ClassLoader>(classLoader2);
        db.println("IF CL=" + classLoader2);
        if (classLoader2 instanceof CmsClassLoader) {
            object = (CmsClassLoader)classLoader2;
            string3 = ((CmsClassLoader)object).getDebugString();
            db.println("IF CL CPs=" + string3);
        }
        if (db.on()) {
            db.println("Loading NET.jar from " + CtcHttpRetriever.getActualURLDisplay(string2));
        }
        db.println("NET CL=" + classLoader);
        if (classLoader instanceof CmsClassLoader) {
            object = (CmsClassLoader)classLoader;
            string3 = ((CmsClassLoader)object).getDebugString();
            db.println("NET CL CPs=" + string3);
        }
        cs.finishCoreSetup();
        object = classLoader.loadClass("cerent.cms.loader.ElementFactory");
        Class[] classArray = new Class[]{classLoader2.getClass()};
        Method method = ((Class)object).getMethod("setParent", classArray);
        method.setAccessible(true);
        boolean bl = preferences.getBoolean(CTC, RMI_SECURITY_MGR, false);
        if (bl) {
            if (db.on()) {
                db.println("enabling RMI Security manager...");
            }
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkConnect(String string, int n) {
                }

                @Override
                public void checkConnect(String string, int n, Object object) {
                }

                @Override
                public void checkRead(FileDescriptor fileDescriptor) {
                }

                @Override
                public void checkRead(String string) {
                }

                @Override
                public void checkRead(String string, Object object) {
                }

                @Override
                public void checkPropertiesAccess() {
                }

                @Override
                public void checkPropertyAccess(String string) {
                }

                @Override
                public void checkPermission(Permission permission) {
                }

                @Override
                public void checkPermission(Permission permission, Object object) {
                }
            });
        }
        Object[] objectArray = new Object[]{classLoader2};
        method.invoke(null, objectArray);
        return classLoader;
    }

    private static void initCore() throws IOException {
        cs.defaultSetupCache();
    }

    /*
     * WARNING - void declaration
     */
    private static void begin(String[] stringArray) throws NoMainClassAttributeException, Exception {
        void var1_4;
        Object object;
        if (db.isFinestEnabled()) {
            db.finest("Bootstrap.begin() called with " + (stringArray == null ? 0 : stringArray.length) + " args:");
            for (String string : stringArray) {
                db.finest("  " + string);
            }
        }
        Object var1_2 = null;
        String string = null;
        CtcHttpRetriever.useProxy(CoreConstants.prefs.getBoolean("ctc.firewall", "enable", true));
        int n = CoreConstants.prefs.getBoolean(CTC, SOTL1, false);
        if (n != 0) {
            try {
                void var4_12;
                Serializable serializable;
                db.println("Bootstrap: Launching using TL1 Tunnel...");
                Object var4_9 = null;
                CtcHttpRetriever.useProxy(true);
                object = null;
                String string2 = CoreConstants.prefs.getProperty(CTC, SOTL1_ADDR, null);
                if (string2 != null) {
                    db.println("Bootstrap: Found a Tl1TunnelAddr from preferences");
                    try {
                        object = new Tl1TunnelAddr(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new Exception("Bootstrap: Tl1TunnelAddr has bad GNE host");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new Exception("Bootstrap: Tl1TunnelAddr has bad arguments");
                    }
                } else {
                    throw new Exception("Bootstrap: Using TL1 Tunnel option, but -Dctcsotl1.address not set");
                }
                String string3 = CoreConstants.prefs.getProperty(CTC, SOTL1_USER, null);
                String string4 = CoreConstants.prefs.getProperty(CTC, SOTL1_PASSWD, null);
                boolean bl = CoreConstants.prefs.getBoolean(CTC, SOTL1_PASSWD_PLAINTEXT, false);
                String string5 = bl ? string4 : Bootstrap.getPlaintext(string4);
                ((Tl1TunnelAddr)object).gneUsername = string3;
                ((Tl1TunnelAddr)object).gnePassword = string5;
                Tl1Tunnel tl1Tunnel = Bootstrap.createTl1Tunnel((Tl1TunnelAddr)object);
                if (tl1Tunnel == null) {
                    db.println("Bootstrap: Tunnel creation from preferences failed, fall back to bringing up the Tl1TunnelDialog");
                    serializable = new Tl1TunnelDialog();
                    Tl1Tunnel tl1Tunnel2 = ((Tl1TunnelDialog)serializable).getTl1Tunnel();
                }
                if (var4_12 != null) {
                    serializable = var4_12.getPneIp();
                    db.println("TL1 Tunnel connected:" + var4_12 + " pneIP=" + serializable);
                    db.println("Using host=" + ((InetAddress)serializable).getHostAddress());
                    String string6 = ((InetAddress)serializable).getHostAddress();
                    String string7 = string = stringArray == null || stringArray.length == 0 ? null : stringArray[0];
                    if (string == null) {
                        if (stringArray.length > 0) {
                            stringArray[0] = string6;
                        } else {
                            stringArray = new String[]{string6};
                        }
                    }
                    String string8 = string6;
                }
            }
            catch (Exception exception) {
                db.println("Bootstrap: TL1 Tunnel creation failed. Could not launch CTC using a TL1 Tunnel.");
                CoreConstants.prefs.removeAllProperties(CTC, SOTL1);
                CoreConstants.prefs.store();
                System.exit(0);
            }
        } else {
            string = stringArray == null || stringArray.length == 0 ? null : stringArray[0];
            db.println("Bootstrap: Launching using IP...");
        }
        CtcProxyFactory.initInitialServer((String)var1_4, string);
        ParametersHolder parametersHolder = new ParametersHolder();
        Bootstrap.initParameters(stringArray, parametersHolder);
        Bootstrap.initCore();
        object = null;
        try {
            object = Bootstrap.initClassLoaders(parametersHolder);
        }
        catch (IOException iOException) {
            db.println("failed in initClassLoaders()");
            db.println("ncl = " + object);
            KDebug.printStackTrace(iOException);
            try {
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(null, iOException.getMessage(), "CTC initialization error", 0);
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
            }
        }
        if (object != null) {
            ((CmsClassLoader)object).invokeMain(parametersHolder.parameters);
        } else {
            Bootstrap.fatal(STARTUP_FATAL_STRING, null);
        }
    }

    private static String getPlaintext(String string) {
        String string2 = string;
        try {
            if (decrypter == null) {
                decrypter = new PBEEncrypter(CoreConstants.CoreString1, CoreConstants.CoreString2);
            }
            string2 = decrypter.decrypt(string);
        }
        catch (EncryptionException encryptionException) {
            KDebug.printStackTrace(encryptionException);
        }
        return string2;
    }

    private static Tl1Tunnel createTl1Tunnel(Tl1TunnelAddr tl1TunnelAddr) {
        Tl1Tunnel tl1Tunnel;
        block4: {
            tl1Tunnel = null;
            try {
                if (tl1TunnelAddr.gneUsername != null && tl1TunnelAddr.gnePassword != null) {
                    tl1Tunnel = Tl1TunnelFactory.instance().createTl1Tunnel(tl1TunnelAddr, 20000);
                    if (db.on()) {
                        db.println("Bootstrap: TL1 tunnel connection succeeded");
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Connection failed:" + exception.getMessage());
            }
        }
        return tl1Tunnel;
    }

    private static void fatal(String string, Throwable throwable) {
        if (db != null) {
            db.severe("***Panic: " + string);
        }
        if (throwable != null) {
            KDebug.printStackTrace(throwable);
            throwable.printStackTrace(System.err);
        }
        System.err.println(string);
        System.err.flush();
        System.exit(1);
    }

    protected static class ParametersHolder {
        public String host;
        public String[] parameters;
        public NETypeEnum netype;
        public Comparable neVersionOrdinal;
        public Comparable coreVersionOrdinal;

        protected ParametersHolder() {
        }
    }
}

