/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;

public class DetailedLog {
    private String desc;
    private Throwable exc;
    private long time;
    private List list;
    private int type;
    private Action action;
    public static final int DL_NONE = 0;
    public static final int DL_INFO = 1;
    public static final int DL_WARNING = 2;
    public static final int DL_ERROR = 3;
    private static final String INDENT = "   ";

    public DetailedLog(int n) {
        this(n, null, null);
    }

    public DetailedLog(String string) {
        this(0, string, null);
    }

    public DetailedLog(int n, String string) {
        this(n, string, null);
    }

    public DetailedLog(int n, String string, Exception exception) {
        this(n, string, (Throwable)exception);
    }

    public DetailedLog(int n, String string, Throwable throwable) {
        this.desc = string;
        this.exc = throwable;
        this.time = System.currentTimeMillis();
        if (n < 0 || n > 3) {
            n = 0;
        }
        this.type = n;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String string) {
        this.desc = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n < 0 || n > 3) {
            n = 0;
        }
        this.type = n;
    }

    public Exception getException() {
        return this.exc instanceof Exception ? (Exception)this.exc : null;
    }

    public Throwable getThrowable() {
        return this.exc;
    }

    public void setException(Exception exception) {
        this.exc = exception;
    }

    public long getTime() {
        return this.time;
    }

    public void updateTime() {
        this.time = System.currentTimeMillis();
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void addChild(DetailedLog detailedLog) {
        if (detailedLog != null) {
            if (this.list == null) {
                this.list = new LinkedList();
            }
            this.list.add(detailedLog);
        }
    }

    public void addChild(Collection collection) {
        if (collection != null) {
            if (this.list == null) {
                this.list = new LinkedList(collection);
            } else {
                this.list.addAll(collection);
            }
        }
    }

    public List getChildren() {
        if (this.list == null) {
            this.list = new LinkedList();
        }
        return this.list;
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
    }

    public int getChildCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    public String toString() {
        return this.getDesc();
    }

    public void prettyPrint(PrintWriter printWriter) {
        this.printDl(printWriter, "");
    }

    private void printDl(PrintWriter printWriter, String string) {
        Object object;
        String string2 = this.desc;
        if (this.action != null) {
            string2 = string2 + "[action: " + this.action.getValue("Name") + "]";
        }
        this.printShift(printWriter, string2, string);
        String string3 = null;
        if (this.exc != null) {
            printWriter.println();
            object = new StringWriter();
            this.exc.printStackTrace(new PrintWriter((Writer)object));
            string3 = string + INDENT;
            this.printShift2(printWriter, ((StringWriter)object).toString(), string3);
        }
        if ((object = this.getChildren()).size() > 0) {
            if (string3 == null) {
                string3 = string + INDENT;
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                printWriter.println();
                DetailedLog detailedLog = (DetailedLog)iterator.next();
                detailedLog.printDl(printWriter, string3);
            }
        }
    }

    private void printShift(PrintWriter printWriter, String string, String string2) {
        int n = 0;
        while (true) {
            printWriter.print(string2);
            int n2 = string.indexOf(10, n);
            if (n2 < 0) break;
            printWriter.println(string.substring(n, n2));
            n = n2 + 1;
        }
        printWriter.println(string.substring(n));
    }

    private void printShift2(PrintWriter printWriter, String string, String string2) {
        int n = 0;
        while (true) {
            printWriter.print(string2);
            int n2 = string.indexOf(9, n);
            if (n2 == n) {
                printWriter.print(INDENT);
                ++n;
            }
            if ((n2 = string.indexOf(10, n)) < 0) break;
            printWriter.println(string.substring(n, n2));
            n = n2 + 1;
        }
        printWriter.println(string.substring(n));
    }
}

