/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IDebugDiag;
import cerent.util.IFvDebug;
import cerent.util.LogLevel;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class KDebug
extends Observable
implements Comparable,
IFvDebug {
    private static HashMap primitiveClasses;
    private static HashMap unprimitiveClasses;
    protected static final KDebug[] KDebugArrayTemplate;
    protected static LogLevel DefaultLogLevel;
    protected LogLevel myLogLevel = LogLevel.SEVERE;
    private static final int HELP_COL_OFFSET = 30;
    public static KDebug root;
    protected static boolean listDup;
    public boolean on;
    protected String nameHeader;
    private TreeMap methods;
    private boolean localScanned = false;
    private StringBuilder temp = new StringBuilder();
    private KDebug parent;
    public static final int ALL_BUT_SPACES = 0;
    public static final int ALPHANUMERIC_ONLY = 1;
    private TreeSet children;
    public static final String Hset = "Set (enable) trace";
    public static final String HsetLogLevel = "Set logging level (OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST) and enable tracing";
    public static final String HsetLogLevelChildren = "Set logging level for descendants";
    public static final String HshowLogLevel = "Display the current logging level";
    public static final String Hunset = "Unset (disable) trace";
    public static final String HunsetChildren = "Unset (disable) trace for all descendants";
    public static final String HsetChildren = "Set (enable) trace for all descendants";
    public static final String Hlist = "List all child debug keys";
    public static final String HlistSetKeys = "List all descendant debug keys that are set";
    public static final String Hhelp = "This help message";
    public static final String HtreeList = "Display descendants in a tree format";
    public static final String Hgrep = "Display all descendants containing a string";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$cerent$util$KDebug;

    public KDebug(KDebug kDebug, String[] stringArray, boolean bl) {
        if (stringArray.length == 1) {
            this.init(kDebug, stringArray[0], bl);
        } else {
            this.init(kDebug, KDebug.getCompoundName(stringArray), bl);
        }
    }

    private static String getCompoundName(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(":");
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public KDebug(KDebug kDebug, String[] stringArray) {
        this(kDebug, stringArray, false);
    }

    public KDebug(KDebug kDebug, String string, boolean bl) {
        this(kDebug, new String[]{string}, bl);
    }

    public KDebug(KDebug kDebug, String string) {
        this(kDebug, string, false);
    }

    public KDebug(String[] stringArray, boolean bl) {
        this(root, stringArray, bl);
    }

    public KDebug(String[] stringArray) {
        this(root, stringArray, false);
    }

    public KDebug(String string, boolean bl) {
        this(new String[]{string}, bl);
    }

    public KDebug(String string) {
        this(string, false);
    }

    private void init(KDebug kDebug, String string, boolean bl) {
        String string2 = KDebug.getDebugFriendlyName(0, string);
        this.on = bl;
        if (this.on) {
            this.setLogLevel(DefaultLogLevel);
        } else {
            this.setLogLevel(LogLevel.OFF);
        }
        this.nameHeader = string2;
        if (kDebug == null) {
            kDebug = root;
        }
        if (kDebug != null) {
            this.parent = kDebug;
            kDebug.addChild(this);
        }
    }

    public void setParentIfNeeded(KDebug kDebug) {
        if (this.parent == null && kDebug != null) {
            this.parent = kDebug;
            this.parent.addChild(this);
        }
    }

    public void setName(String[] stringArray) {
        this.setName(KDebug.getCompoundName(stringArray));
    }

    public void setName(String string) {
        String string2 = KDebug.getDebugFriendlyName(0, string);
        if (this.nameHeader.equals(string2)) {
            return;
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.nameHeader = string2;
        if (this.parent == null) {
            this.parent = root;
        }
        if (this.parent != null) {
            this.parent = this.parent;
            this.parent.addChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                this.children.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeClassLoader(ClassLoader classLoader) {
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    kDebug.disposeClassLoader(classLoader);
                    if (kDebug.getClass().getClassLoader() != classLoader) continue;
                    iterator.remove();
                }
            }
        }
    }

    public synchronized void disposeSameClassLoaderObjects() {
        root.disposeClassLoader(this.getClass().getClassLoader());
    }

    public boolean on() {
        return this.on;
    }

    public int compareTo(Object object) {
        if (object instanceof KDebug) {
            return this.getKeyValue().compareTo(((KDebug)object).getKeyValue());
        }
        return -1;
    }

    protected String getName() {
        return this.nameHeader;
    }

    protected String getFullName() {
        if (this.parent != null) {
            if (this.parent == root) {
                return this.nameHeader;
            }
            return this.parent.getFullName() + "." + this.nameHeader;
        }
        return "";
    }

    public static String getDebugFriendlyName(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                boolean bl;
                char c = string.charAt(i);
                boolean bl2 = n == 1 ? Character.isLetterOrDigit(c) : (bl = c != ' ');
                if (!bl) continue;
                stringBuilder.append(c);
            }
        } else {
            stringBuilder.append("NULL");
        }
        return stringBuilder.toString();
    }

    protected String getKeyValue() {
        return this.nameHeader + Integer.toHexString(this.hashCode());
    }

    public boolean matches(String string) {
        boolean bl = false;
        String string2 = null;
        int n = 0;
        if (string.endsWith("*")) {
            string2 = string.substring(0, string.length() - 1);
            int n2 = n = string2.length() > this.getName().length() ? this.getName().length() : string2.length();
        }
        if (this.getName().equals(string) || string2 != null && this.getName().substring(0, n).equals(string2)) {
            bl = true;
        }
        return bl;
    }

    protected void printLocalMethods() {
        this.scanMethods();
        Iterator iterator = this.methods.values().iterator();
        while (iterator.hasNext()) {
            DebugCmd debugCmd = (DebugCmd)iterator.next();
            debugCmd.printHelpString();
        }
    }

    protected void printHelp(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("  " + string);
        if (stringBuilder.length() > 30) {
            root.display(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (string2 != null && string2.length() > 0) {
            while (stringBuilder.length() < 30) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("(");
            stringBuilder.append(string2);
            stringBuilder.append(")");
        }
        root.display(stringBuilder.toString());
    }

    public void print(String string) {
        this.temp.append(string);
    }

    public void println(String string) {
        String string2 = null;
        if (this.temp.length() > 0) {
            this.temp.append(string);
            string2 = this.temp.toString();
        } else {
            string2 = string;
        }
        if (!this.on()) {
            String string3 = this.getFullName();
            if (root != null) {
                root.display(string3, string2);
            } else if (string3 != null && string3.length() > 0) {
                System.out.println(string3 + " - " + string2);
            } else {
                System.out.println(string2);
            }
        } else {
            this.logMessage(string2, LogLevel.FINE);
        }
        this.temp.setLength(0);
    }

    public static void printStackTrace(Throwable throwable) {
        if (root != null) {
            root.rootPrintStackTrace(throwable);
        } else {
            System.out.println(throwable);
        }
    }

    public void rootPrintStackTrace(Throwable throwable) {
    }

    public void display(String string) {
        root.display(string);
    }

    public void display(String string, String string2) {
        root.display(string, string2);
    }

    void printTable(Iterator iterator) {
        root.printTable(iterator);
    }

    protected void newInstanceAdded(KDebug kDebug) {
    }

    protected static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    boolean apply(String[] stringArray, int n) {
        if (stringArray.length != n && !stringArray[n].equals("?")) {
            Object object;
            String string = KDebug.toUpperCase(stringArray[n]);
            boolean bl = false;
            Collection collection = this.getChildrenExactMatch(string);
            if (collection.size() == 0) {
                collection = this.getChildren(string, true);
            }
            Iterator<Object> iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (KDebug)iterator.next();
                if (!((KDebug)object).apply(stringArray, n + 1)) continue;
                bl = true;
            }
            if (bl) {
                return true;
            }
            this.scanMethods();
            iterator = this.methods.values().iterator();
            while (iterator.hasNext()) {
                object = (DebugCmd)iterator.next();
                try {
                    if (!((DebugCmd)object).exec(stringArray, n)) continue;
                    return true;
                }
                catch (Exception exception) {
                    KDebug.printStackTrace(exception);
                }
            }
            iterator = this.methods.values().iterator();
            while (iterator.hasNext()) {
                object = (DebugCmd)iterator.next();
                try {
                    if (!((DebugCmd)object).execAsArray(stringArray, n)) continue;
                    return true;
                }
                catch (Exception exception) {
                    KDebug.printStackTrace(exception);
                }
            }
            return false;
        }
        this.help();
        return true;
    }

    private void scanMethods() {
        if (!this.localScanned) {
            this.addCommands(this);
            this.localScanned = true;
        }
    }

    public void addCommands(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!this.isEligible(methodArray[i])) continue;
            String string = "H" + methodArray[i].getName();
            String string2 = null;
            try {
                Field field = object.getClass().getField(string);
                if (field != null && field.getType() == (class$java$lang$String == null ? KDebug.class$("java.lang.String") : class$java$lang$String)) {
                    string2 = (String)field.get(this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addCommand(object, methodArray[i], string2);
        }
    }

    public void addCommand(Object object, String string, String string2) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            this.addCommand(object, methodArray[i], string2);
            return;
        }
        this.severe("addCommand cannot find method " + string + " in proxy " + object);
    }

    public synchronized void removeCommands(Object object) {
        if (this.methods == null) {
            return;
        }
        Iterator iterator = this.methods.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            DebugCmd debugCmd = (DebugCmd)this.methods.get(k);
            if (debugCmd.getProxy() != object) continue;
            iterator.remove();
        }
    }

    public synchronized void removeCommand(Object object, String string) {
        if (this.methods == null) {
            return;
        }
        Iterator iterator = this.methods.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            DebugCmd debugCmd = (DebugCmd)this.methods.get(k);
            if (debugCmd.getProxy() != object || debugCmd.getName() != string) continue;
            iterator.remove();
            return;
        }
    }

    public synchronized void addCommand(Object object, Method method, String string) {
        if (this.methods == null) {
            this.methods = new TreeMap();
        }
        String string2 = method.getName();
        int n = 0;
        while (this.methods.containsKey(string2)) {
            string2 = method.getName() + n;
            ++n;
        }
        this.methods.put(string2, new DebugCmd(object, method, string));
    }

    private boolean isEligible(Method method) {
        int n = method.getModifiers();
        return Modifier.isPublic(n) && Modifier.isFinal(n) && method.getDeclaringClass() != Object.class && method.getReturnType() == Void.TYPE;
    }

    private Object[] parseArgs(Method method, String[] stringArray, int n) {
        Object[] objectArray = null;
        Class<?>[] classArray = method.getParameterTypes();
        if (stringArray.length - n == classArray.length) {
            try {
                objectArray = new Object[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    String string = stringArray[i + n];
                    if (classArray[i] == Integer.TYPE) {
                        objectArray[i] = Integer.valueOf(string);
                        continue;
                    }
                    if (classArray[i] == Boolean.TYPE) {
                        if (this.isTrue(string)) {
                            objectArray[i] = new Boolean(true);
                            continue;
                        }
                        if (this.isFalse(string)) {
                            objectArray[i] = new Boolean(false);
                            continue;
                        }
                        objectArray = null;
                    } else {
                        if (classArray[i] == (class$java$lang$String == null ? KDebug.class$("java.lang.String") : class$java$lang$String)) {
                            objectArray[i] = string;
                            continue;
                        }
                        objectArray = null;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public void set(boolean bl) {
        this.on = bl;
        this.myLogLevel = bl ? DefaultLogLevel : LogLevel.OFF;
    }

    public String toString() {
        return this.status() + this.getName();
    }

    private boolean isTrue(String string) {
        return string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE");
    }

    private boolean isFalse(String string) {
        return string.equalsIgnoreCase("OFF") || string.equalsIgnoreCase("FALSE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(KDebug kDebug) {
        Object object = this;
        synchronized (object) {
            if (this.children == null) {
                this.children = new TreeSet();
            }
        }
        object = this.children;
        synchronized (object) {
            this.children.add(kDebug);
        }
        if (root != null) {
            root.newInstanceAdded(kDebug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(KDebug kDebug) {
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                this.children.remove(kDebug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KDebug getChild(String string) {
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    if (!kDebug.getName().equals(string)) continue;
                    return kDebug;
                }
            }
        }
        return null;
    }

    public Collection getChildren(boolean bl) {
        if (this.children != null) {
            if (bl) {
                return this.children;
            }
            return this.filterOutDup(this.children);
        }
        return new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getChildrenExactMatch(String string) {
        LinkedList<KDebug> linkedList = new LinkedList<KDebug>();
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    if (!kDebug.getName().equalsIgnoreCase(string)) continue;
                    linkedList.add(kDebug);
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getChildrenExactMatchRecursive(String string) {
        LinkedList<KDebug> linkedList = new LinkedList<KDebug>();
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    if (kDebug.getName().equalsIgnoreCase(string)) {
                        linkedList.add(kDebug);
                    }
                    linkedList.addAll(kDebug.getChildrenExactMatchRecursive(string));
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getChildren(String string, boolean bl) {
        LinkedList<KDebug> linkedList = new LinkedList<KDebug>();
        string = KDebug.toUpperCase(string);
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    if (!KDebug.toUpperCase(kDebug.getName()).startsWith(string)) continue;
                    linkedList.add(kDebug);
                }
            }
        }
        if (!bl) {
            return this.filterOutDup(linkedList);
        }
        return linkedList;
    }

    private Collection filterOutDup(Collection collection) {
        TreeMap<String, KDebug> treeMap = new TreeMap<String, KDebug>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            KDebug kDebug = (KDebug)iterator.next();
            treeMap.put(KDebug.toUpperCase(kDebug.getName()), kDebug);
        }
        return treeMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllDebugObjects(Set set, boolean bl) {
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    kDebug.addAllDebugObjects(set, bl);
                    if (bl) {
                        set.add(kDebug);
                        continue;
                    }
                    if (!kDebug.on()) continue;
                    set.add(kDebug);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execDebugDiag() {
        if (this instanceof IDebugDiag) {
            this.println("Diagnostic Dump==========================================");
            ((IDebugDiag)((Object)this)).dumpDiag();
        }
        if (this.children != null) {
            KDebug[] kDebugArray = this.children.toArray(KDebugArrayTemplate);
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                for (int i = 0; i < kDebugArray.length; ++i) {
                    KDebug kDebug = kDebugArray[i];
                    kDebug.execDebugDiag();
                }
            }
        }
    }

    public final void set() {
        this.set(true);
        this.println("trace=" + this.on);
    }

    public final void setLogLevel(String string) {
        try {
            LogLevel logLevel = LogLevel.parse(string);
            this.setLogLevel(logLevel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.display(illegalArgumentException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.display("No logging level specified");
        }
    }

    public final void setLogLevelChildren(String string) {
        try {
            LogLevel logLevel = LogLevel.parse(string);
            this.setLogLevelChildren(logLevel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.display(illegalArgumentException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.display("No logging level specified");
        }
    }

    public final void showLogLevel() {
        StringBuilder stringBuilder = new StringBuilder(this.getFullName());
        stringBuilder.append("-->");
        stringBuilder.append(this.getLogLevel().toString());
        this.display(stringBuilder.toString());
    }

    public final void unset() {
        this.set(false);
        this.println("trace=" + this.on);
    }

    public final void setChildren() {
        this.setAll(true);
    }

    public final void unsetChildren() {
        this.setAll(false);
    }

    public final void list() {
        this.list("");
    }

    public final void list(String string) {
        this.listInstances(string);
    }

    public final void listSetKeys() {
        this.display("  ----------------------- " + this.getFullName() + " Set Keys  -----------------------  ");
        if (this.children == null) {
            this.display("(empty)");
        } else {
            HashSet hashSet = new HashSet();
            this.addAllDebugObjects(hashSet, false);
            this.printTable(hashSet.iterator());
        }
    }

    public final void help() {
        root.display("-------------- Available commands for \"" + this.getFullName() + "\":");
        this.printLocalMethods();
    }

    public final void treeList() {
        this.treeList("");
    }

    public final void treeList(String string) {
        this.treeList(" ", string);
    }

    public final void grep(String string) {
        KDebug kDebug;
        string = KDebug.toUpperCase(string);
        HashSet hashSet = new HashSet();
        this.addAllDebugObjects(hashSet, true);
        TreeMap<String, KDebug> treeMap = new TreeMap<String, KDebug>();
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            kDebug = (KDebug)iterator.next();
            if (KDebug.toUpperCase(kDebug.getName()).indexOf(string) == -1) continue;
            treeMap.put(kDebug.getKeyValue(), kDebug);
        }
        iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            kDebug = (KDebug)iterator.next();
            root.display("   " + kDebug.status() + kDebug.getFullName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAll(boolean bl) {
        this.set(bl);
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    kDebug.setAll(bl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listInstances(String string) {
        string = KDebug.toUpperCase(string.trim());
        if (this.children == null) {
            this.display("  ----------------------- " + this.getFullName() + " " + string + " (empty) --------------------  ");
        } else {
            LinkedList<KDebug> linkedList = new LinkedList<KDebug>();
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.getChildren(string, listDup).iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    linkedList.add(kDebug);
                }
                this.display("  ----------------------- " + this.getFullName() + " " + string + " (" + linkedList.size() + ") --------------------  ");
            }
            this.printTable(linkedList.iterator());
        }
    }

    private void treeList(String string, String string2) {
        Iterator iterator = this.getChildren(string2, listDup).iterator();
        while (iterator.hasNext()) {
            KDebug kDebug = (KDebug)iterator.next();
            root.display(string + kDebug.toString());
            kDebug.treeList(string + "    ", "");
        }
    }

    private String status() {
        return this.on() ? "*" : "";
    }

    public void deleteObserver(Observer observer) {
    }

    public void addObserver(Observer observer) {
    }

    public void config(String string) {
        this.logMessage(string, LogLevel.CONFIG);
    }

    public void fine(String string) {
        this.logMessage(string, LogLevel.FINE);
    }

    public void finer(String string) {
        this.logMessage(string, LogLevel.FINER);
    }

    public void finest(String string) {
        this.logMessage(string, LogLevel.FINEST);
    }

    public void severe(String string) {
        this.logMessage(string, LogLevel.SEVERE);
    }

    public void warning(String string) {
        this.logMessage(string, LogLevel.WARNING);
    }

    public void info(String string) {
        this.logMessage(string, LogLevel.INFO);
    }

    public final boolean isConfigEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.CONFIG.intValue();
    }

    public final boolean isFineEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.FINE.intValue();
    }

    public final boolean isFinerEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.FINER.intValue();
    }

    public final boolean isFinestEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.FINEST.intValue();
    }

    public final boolean isInfoEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.INFO.intValue();
    }

    public final boolean isSevereEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.SEVERE.intValue();
    }

    public final boolean isWarningEnabled() {
        return this.getLogLevel().intValue() <= LogLevel.WARNING.intValue();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.set(logLevel != LogLevel.OFF);
        this.myLogLevel = logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogLevelChildren(LogLevel logLevel) {
        this.setLogLevel(logLevel);
        if (this.children != null) {
            TreeSet treeSet = this.children;
            synchronized (treeSet) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    KDebug kDebug = (KDebug)iterator.next();
                    kDebug.setLogLevelChildren(logLevel);
                }
            }
        }
    }

    public LogLevel getLogLevel() {
        return this.myLogLevel;
    }

    public void logMessage(String string, LogLevel logLevel) {
        if (root == null) {
            return;
        }
        root.preLogMessage(this, logLevel, string);
        if (this.getLogLevel().intValue() <= logLevel.intValue()) {
            root.display(this.getFullName(), string);
        }
    }

    protected void preLogMessage(KDebug kDebug, LogLevel logLevel, String string) {
    }

    public IFvDebug addChild(String string, String string2) {
        return new KDebug(string);
    }

    static {
        KDebugArrayTemplate = new KDebug[0];
        DefaultLogLevel = LogLevel.FINE;
        listDup = true;
        primitiveClasses = new HashMap();
        primitiveClasses.put("byte", "B");
        primitiveClasses.put("char", "C");
        primitiveClasses.put("double", "D");
        primitiveClasses.put("float", "F");
        primitiveClasses.put("int", "I");
        primitiveClasses.put("long", "J");
        primitiveClasses.put("short", "S");
        primitiveClasses.put("boolean", "Z");
        unprimitiveClasses = new HashMap();
        Set set = primitiveClasses.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)primitiveClasses.get(string);
            unprimitiveClasses.put(string2, string);
        }
    }

    public class DebugCmd {
        private String help;
        private WeakReference proxy;
        private Method method;
        private boolean isStringArray;

        public DebugCmd(Object object, Method method, String string) {
            this.proxy = new WeakReference<Object>(object);
            this.help = string;
            this.method = method;
            Class<?>[] classArray = this.method.getParameterTypes();
            this.isStringArray = classArray != null && classArray.length == 1 && classArray[0].equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = KDebug.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }

        public boolean isLocal() {
            if (KDebug.this.getClass() == (class$cerent$util$KDebug == null ? (class$cerent$util$KDebug = KDebug.class$("cerent.util.KDebug")) : class$cerent$util$KDebug)) {
                return this.method.getDeclaringClass() != (class$cerent$util$KDebug == null ? (class$cerent$util$KDebug = KDebug.class$("cerent.util.KDebug")) : class$cerent$util$KDebug);
            }
            return this.method.getDeclaringClass() == this.getProxy().getClass();
        }

        public void printHelpString() {
            if (this.getProxy() == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.setLength(0);
            if (this.isLocal()) {
                stringBuilder.append("+");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.getName());
            stringBuilder.append(" ");
            Class<?>[] classArray = this.method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz;
                if (i > 0) {
                    stringBuilder.append(" ");
                }
                if ((clazz = classArray[i]) == (class$java$lang$String == null ? KDebug.class$("java.lang.String") : class$java$lang$String)) {
                    stringBuilder.append("String");
                    continue;
                }
                String string = clazz.getName();
                if (clazz.isArray()) {
                    string = this.fromJvmClassname(string);
                }
                stringBuilder.append(string);
            }
            KDebug.this.printHelp(stringBuilder.toString(), this.help);
        }

        private String fromJvmClassname(String string) {
            String string2;
            if (string == null || string.length() == 0) {
                return string;
            }
            int n = 0;
            while (string.startsWith("[")) {
                string = string.substring(1);
                ++n;
            }
            if (string.startsWith("L") && string.endsWith(";")) {
                string = string.substring(1, string.length() - 1);
            }
            boolean bl = (string2 = (String)unprimitiveClasses.get(string)) != null;
            int n2 = n;
            if (bl) {
                string = string2;
            } else {
                bl = primitiveClasses.get(string) != null;
            }
            int n3 = string.lastIndexOf(".");
            if (n3 >= 0) {
                string = string.substring(n3 + 1);
            }
            if (n2 > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append("[]");
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public String getName() {
            return this.method.getName();
        }

        public Object getProxy() {
            return this.proxy.get();
        }

        public boolean exec(String[] stringArray, int n) throws Exception {
            Object[] objectArray;
            if (this.method.getName().toLowerCase(Locale.ENGLISH).startsWith(stringArray[n].toLowerCase(Locale.ENGLISH)) && (objectArray = KDebug.this.parseArgs(this.method, stringArray, n + 1)) != null) {
                this.method.invoke(this.getProxy(), objectArray);
                return true;
            }
            return false;
        }

        public boolean execAsArray(String[] stringArray, int n) throws Exception {
            if (stringArray != null && stringArray.length > n + 1 && this.isStringArray && this.method.getName().toLowerCase(Locale.ENGLISH).startsWith(stringArray[n].toLowerCase(Locale.ENGLISH))) {
                int n2 = stringArray.length - ++n;
                String[] stringArray2 = new String[n2];
                System.arraycopy(stringArray, n, stringArray2, 0, n2);
                Object[] objectArray = new Object[]{stringArray2};
                this.method.invoke(this.getProxy(), objectArray);
                return true;
            }
            return false;
        }
    }
}

