/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.util.ArrayList;
import java.util.Locale;

public class LogLevel {
    private static ArrayList allLevels = new ArrayList();
    public static final LogLevel OFF = new LogLevel("OFF", Integer.MAX_VALUE);
    public static final LogLevel SEVERE = new LogLevel("SEVERE", 1000);
    public static final LogLevel WARNING = new LogLevel("WARNING", 900);
    public static final LogLevel INFO = new LogLevel("INFO", 800);
    public static final LogLevel CONFIG = new LogLevel("CONFIG", 700);
    public static final LogLevel FINE = new LogLevel("FINE", 500);
    public static final LogLevel FINER = new LogLevel("FINER", 400);
    public static final LogLevel FINEST = new LogLevel("FINEST", 300);
    public static final LogLevel ALL = new LogLevel("ALL", Integer.MIN_VALUE);
    protected final int myLogLevel;
    protected final String myName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogLevel(String string, int n) {
        this.myName = string;
        this.myLogLevel = n;
        Class clazz = LogLevel.class;
        synchronized (clazz) {
            allLevels.add(this);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LogLevel) {
            LogLevel logLevel = (LogLevel)object;
            return this.myLogLevel == logLevel.intValue();
        }
        return false;
    }

    public final int intValue() {
        return this.myLogLevel;
    }

    public int hashCode() {
        return this.myLogLevel;
    }

    public String toString() {
        return this.myName;
    }

    public static LogLevel parse(String string) throws IllegalArgumentException {
        string.length();
        for (int i = 0; i < allLevels.size(); ++i) {
            LogLevel logLevel = (LogLevel)allLevels.get(i);
            if (!string.toLowerCase(Locale.ENGLISH).equals(logLevel.myName.toLowerCase())) continue;
            return logLevel;
        }
        throw new IllegalArgumentException("Bad log level \"" + string + "\"");
    }
}

