/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.DebugManager;
import cerent.util.DebugSys;
import cerent.util.DebugTelnetd;
import cerent.util.KDebug;
import cerent.util.LogLevel;
import cerent.util.Preferences;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class RootDebug
extends KDebug {
    private static final int NUM_COLS = 3;
    private static final int LINE_LENGTH = 79;
    private static final int EXC_LIST_SIZE = 100;
    private static final int VITAL_MESSAGE_CAPACITY = 100;
    private static final String VITAL_MESSAGE_THRESHOLD = "WARNING";
    private static final String DELIMITER = " ";
    private static final String PREFIX = " ";
    private boolean printTimeStamp = false;
    private boolean printThread = false;
    private boolean printStackTrace = true;
    private final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private final boolean skipHdr;
    private HashMap presetMap;
    private DebugManager dbm;
    private LinkedList excList = new LinkedList();
    private static final int DEBUG_TELNET_PORT = 9401;
    private static final String PREFS_PATH = "ctc.debug";
    private static final String PREFS_BUFSIZE = "excBufSize";
    private static final String PREFS_VITAL_MESSAGE_CAPACITY = "vitalMsgCapacity";
    private static final String PREFS_VITAL_MESSAGE_THRESHOLD = "vitalMsgThreshold";
    private static final String PREFS_LIST_LINE_LEN = "list.maxLineLength";
    private static final String PREFS_LIST_COLS = "list.cols";
    private static final String PREFS_LIST_DUPS = "list.dups";
    private static final String PREFS_SAVE_KEYS = "keys";
    private static final String PREFS_NO_HDR = "noheader";
    private int excBufSize;
    private LogLevel myDefaultLoggingLevel = LogLevel.FINE;
    private LogLevel myVitalMessageThreshold;
    private LinkedList myVitalMessageList = new LinkedList();
    protected int myVitalMessageCapacity;
    private int listCols;
    private int listLineLen;
    private Preferences prefs;
    private boolean disableOutput = false;
    private StringBuffer hdr = new StringBuffer();
    public static final String Hpreset = "Preset debug key: Key name, Log Level";
    public static final String Hunpreset = "Remove preset debug key";
    public static final String HsaveKeys = "Persist current debug keyset";
    public static final String HclearKeys = "Remove saved preset keys";
    public static final String HstorePreferences = "Save preferences to file now";
    public static final String Htime = "Print timestamp in header";
    public static final String HtimePattern = "Set pattern, \"?\" shows current";
    public static final String HgetProperties = "Dump the system properties";
    public static final String HgetProperty = "Get a system property";
    public static final String HsetProperty = "Set a system property";
    public static final String Hthread = "Print thread name in header";
    public static final String HstackTrace = "Enable print of the stack trace";
    public static final String HdumpClMap = "Dump class loader maps of debug objects";
    public static final String HdumpDups = "Dump duplicate debug objects";
    public static final String HshowPreset = "Show preset keys";
    public static final String Hread = "Read and execute commands from a file";
    private PrintWriter log;
    public static final String HenableOutput = "Enable/Disable debug output to all front-ends";
    public static final String Hlogon = "Capture all debug activity to a file";
    public static final String Hlogoff = "Stop capture and close log file";
    public static final String HdumpDiag = "Full diagnostic dump";
    public static final String HdumpExceptions = "Full exceptions dump";
    public static final String HdumpVitalMessages = "Show all captured vital messages";
    public static final String HresetVitalMessages = "Purge the vital messages list";
    public static final String Htelnetd = "Start a debug telnet session";
    public static final String HshowExceptions = "Show exceptions in stdout";
    public static final String HsetBufferSize = "Set exceptions buffer size";
    public static final String hshowBufferSize = "Show exception buffer size";
    public static final String Hdash = "Prints a dashed separation line";
    private static final String dashText = "--------------------------------";
    public static final String HformatList = "Format list output (dups,maxLineLen, cols)";
    public static final String HshowDefaultLogLevel = "Display the logging level assigned when using the preset/set/unset commands";
    public static final String HsetDefaultLogLevel = "Set default logging level (OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST) and enable tracing";
    private String cachedTimeStamp = null;
    private long cachedTime = 0L;

    RootDebug(DebugManager debugManager) {
        super("", false);
        this.presetMap = new HashMap();
        root = this;
        this.dbm = debugManager;
        this.prefs = Preferences.instance();
        this.skipHdr = this.prefs.getBoolean(PREFS_PATH, PREFS_NO_HDR, false);
        this.excBufSize = this.prefs.getInt(PREFS_PATH, PREFS_BUFSIZE, 100);
        this.initVitalMessageThreshold();
        this.myVitalMessageCapacity = this.prefs.getInt(PREFS_PATH, PREFS_VITAL_MESSAGE_CAPACITY, 100);
        this.listCols = this.prefs.getInt(PREFS_PATH, PREFS_LIST_COLS, 3);
        this.listLineLen = this.prefs.getInt(PREFS_PATH, PREFS_LIST_LINE_LEN, 79);
        listDup = this.prefs.getBoolean(PREFS_PATH, PREFS_LIST_DUPS, true);
        this.initPresetKeys();
        new DebugSys();
    }

    protected void initVitalMessageThreshold() {
        String string = this.prefs.getProperty(PREFS_PATH, PREFS_VITAL_MESSAGE_THRESHOLD, VITAL_MESSAGE_THRESHOLD);
        try {
            this.myVitalMessageThreshold = LogLevel.parse(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.myVitalMessageThreshold = LogLevel.WARNING;
        }
    }

    protected void initPresetKeys() {
        try {
            String[] stringArray = new String[]{};
            String[] stringArray2 = this.prefs.getPropertyArray(PREFS_PATH, PREFS_SAVE_KEYS, stringArray);
            for (int i = 0; i < stringArray2.length; ++i) {
                KDebug kDebug;
                int n = stringArray2[i].indexOf(" ");
                if (n < 0) continue;
                String string = stringArray2[i].substring(0, n);
                String string2 = stringArray2[i].substring(n + 1);
                this.preset(string, string2);
                if (!string.equalsIgnoreCase("Preferences") || null == (kDebug = this.getChild("Preferences"))) continue;
                kDebug.setLogLevel(string2);
            }
        }
        catch (Exception exception) {
            this.warning("Unable to load saved keys from preferences file");
            this.rootPrintStackTrace(exception);
        }
    }

    @Override
    public synchronized void rootPrintStackTrace(Throwable throwable) {
        if (!this.disableOutput && this.printStackTrace) {
            DebugManager.printStackTrace(throwable);
        }
        if (this.log != null) {
            try {
                throwable.printStackTrace(this.log);
            }
            catch (Exception exception) {
                this.finest("Exception in rootPrintStackTrace(), e=" + throwable + " " + exception);
            }
        }
        ExcHolder excHolder = new ExcHolder(throwable);
        this.excList.addFirst(excHolder);
        if (this.excList.size() > this.excBufSize) {
            this.excList.removeLast();
        }
    }

    @Override
    public synchronized void display(String string) {
        if (!this.disableOutput) {
            this.dbm.println(string);
        }
        if (this.log != null) {
            try {
                this.log.println(string);
            }
            catch (Exception exception) {
                this.finest("Exception in display, text=" + string + " " + exception);
            }
        }
    }

    @Override
    public synchronized void display(String string, String string2) {
        if (this.skipHdr) {
            this.display(string2);
            return;
        }
        this.hdr.setLength(0);
        if (this.printTimeStamp) {
            this.hdr.append(this.getTimeStamp());
        }
        this.hdr.append("[");
        this.hdr.append(string);
        if (this.printThread) {
            this.hdr.append("|");
            this.hdr.append(Thread.currentThread().getName());
        }
        this.hdr.append("] ");
        this.hdr.append(string2);
        this.display(this.hdr.toString());
    }

    @Override
    protected void printLocalMethods() {
        String[][] stringArray = this.dbm.getHelpMatrix();
        for (int i = 0; i < stringArray.length; ++i) {
            this.printHelp(stringArray[i][0], stringArray[i][1]);
        }
        super.printLocalMethods();
    }

    @Override
    protected void newInstanceAdded(KDebug kDebug) {
        String string = RootDebug.toUpperCase(kDebug.getFullName());
        LogLevel logLevel = (LogLevel)this.presetMap.get(string);
        if (logLevel == null) {
            string = RootDebug.toUpperCase(kDebug.getName());
            logLevel = (LogLevel)this.presetMap.get(string);
        }
        if (logLevel != null) {
            kDebug.setLogLevel(logLevel);
        }
    }

    @Override
    protected void preLogMessage(KDebug kDebug, LogLevel logLevel, String string) {
        if (logLevel != LogLevel.OFF && this.myVitalMessageThreshold.intValue() <= logLevel.intValue()) {
            LogMessageHolder logMessageHolder = new LogMessageHolder(kDebug, logLevel, string);
            this.addVitalMessage(logMessageHolder);
        }
    }

    protected synchronized void addVitalMessage(LogMessageHolder logMessageHolder) {
        this.myVitalMessageList.addFirst(logMessageHolder);
        if (this.myVitalMessageList.size() > this.myVitalMessageCapacity) {
            this.myVitalMessageList.removeLast();
        }
    }

    protected synchronized void purgeVitalMessages() {
        this.myVitalMessageList.clear();
    }

    public final void preset(String string) {
        this.preset(string, "FINE");
    }

    public final void preset(String string, String string2) {
        try {
            String string3 = RootDebug.toUpperCase(string);
            LogLevel logLevel = LogLevel.parse(string2);
            this.presetMap.put(string3, logLevel);
            Collection collection = this.getChildrenExactMatchRecursive(string3);
            for (KDebug kDebug : collection) {
                kDebug.setLogLevel(logLevel);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.display("Invalid log level");
        }
    }

    public final void unpreset(String string) {
        this.presetMap.remove(RootDebug.toUpperCase(string));
    }

    public final void saveKeys() {
        ArrayList arrayList = new ArrayList();
        this.saveKeysFor(this, arrayList);
        String[] stringArray = new String[]{};
        String[] stringArray2 = arrayList.toArray(stringArray);
        this.prefs.setPropertyArray(PREFS_PATH, PREFS_SAVE_KEYS, stringArray2);
        this.storePreferences();
    }

    public final void clearKeys() {
        this.prefs.removeProperty(PREFS_PATH, PREFS_SAVE_KEYS);
        this.storePreferences();
    }

    public final void storePreferences() {
        try {
            this.prefs.store();
        }
        catch (IOException iOException) {
            this.warning("Unable to locate preferences file");
            this.rootPrintStackTrace(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveKeysFor(KDebug kDebug, List list) {
        Collection collection = kDebug.getChildren(true);
        Object object = collection;
        synchronized (object) {
            for (KDebug kDebug2 : collection) {
                this.saveKeysFor(kDebug2, list);
            }
        }
        if (kDebug.on()) {
            object = new StringBuffer(kDebug.getName());
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append(kDebug.getLogLevel().toString());
            list.add(((StringBuffer)object).toString());
        }
    }

    public final void time(boolean bl) {
        this.printTimeStamp = bl;
        this.println("Print Timestamp in Header:" + this.printTimeStamp);
    }

    public boolean getTime() {
        return this.printTimeStamp;
    }

    public final void timePattern(String string) {
        if (string.equals("?")) {
            this.println("current pattern \"" + this.sdf.toPattern() + "\"");
            this.println("(y)ear (M)onth (d)ay (H)our (m)in (s)ec (S)millisec");
        } else {
            this.sdf.applyPattern(string);
            this.cachedTime = 0L;
            this.println("New Timestamp set");
        }
    }

    public final void thread(boolean bl) {
        this.printThread = bl;
        this.println("Print Thread Name in Header:" + this.printThread);
    }

    public boolean getThread() {
        return this.printThread;
    }

    public final void getProperties() {
        Properties properties = System.getProperties();
        TreeSet<Object> treeSet = new TreeSet<Object>(properties.keySet());
        for (Object object : treeSet) {
            this.println(object + "=" + properties.get(object));
        }
    }

    public final void getProperty(String string) {
        String string2 = System.getProperty(string);
        this.println(string + "=" + string2);
    }

    public final void setProperty(String string, String string2) {
        System.setProperty(string, string2);
    }

    public final void stackTrace(boolean bl) {
        this.printStackTrace = bl;
        this.println("Enable print of the stack trace:" + this.printStackTrace);
    }

    public final void echo(String string) {
        this.dbm.println(string);
    }

    private Map getClMap() {
        HashSet hashSet = new HashSet();
        this.addAllDebugObjects(hashSet, true);
        TreeMap treeMap = new TreeMap();
        for (KDebug kDebug : hashSet) {
            ClassLoader classLoader = kDebug.getClass().getClassLoader();
            TreeMap<String, KDebug> treeMap2 = (TreeMap<String, KDebug>)treeMap.get(classLoader.toString());
            if (treeMap2 == null) {
                treeMap2 = new TreeMap<String, KDebug>();
                treeMap.put(classLoader.toString(), treeMap2);
            }
            String string = kDebug.getKeyValue();
            treeMap2.put(string, kDebug);
        }
        return treeMap;
    }

    public final void dumpClMap() {
        Map map = this.getClMap();
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            this.display("=======> Map for cl=" + string + " count=" + map2.size());
            this.printTable(map2.values().iterator());
        }
        this.display("=======> Done");
    }

    public final void dumpDups() {
        Map map = this.getClMap();
        LinkedList<KDebug> linkedList = new LinkedList<KDebug>();
        for (String string : map.keySet()) {
            Map map2 = (Map)map.get(string);
            boolean bl = false;
            KDebug kDebug = null;
            for (KDebug kDebug2 : map2.values()) {
                if (kDebug == null) {
                    kDebug = kDebug2;
                    continue;
                }
                if (kDebug.getName().equals(kDebug2.getName())) {
                    bl = true;
                    linkedList.add(kDebug2);
                    continue;
                }
                if (bl) {
                    linkedList.add(kDebug);
                    bl = false;
                }
                kDebug = kDebug2;
            }
            if (linkedList.isEmpty()) continue;
            this.display("=======> Duplicate debug objects for cl=" + string + " count=" + linkedList.size());
            for (KDebug kDebug2 : linkedList) {
                this.display("    " + kDebug2.getFullName());
            }
            linkedList.clear();
        }
        this.display("=======> Done");
    }

    public final void showPreset() {
        if (this.presetMap.size() > 0) {
            this.dash("Presets");
            this.printTable(this.presetMap.entrySet().iterator());
        } else {
            this.display("no preset keys");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if ((string2 = string2.trim()).length() == 0) continue;
                this.display(string2);
                int n = string2.indexOf(35);
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                if ((stringTokenizer = new StringTokenizer(string2)).countTokens() <= 0) continue;
                String[] stringArray = new String[stringTokenizer.countTokens()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                }
                this.apply(stringArray, 0);
            }
        }
        catch (Exception exception) {
            this.display(exception.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.finest("IOException in read(), filename=" + string + " " + iOException);
                }
            }
        }
    }

    public final void enableOutput(boolean bl) {
        this.disableOutput = !bl;
    }

    public final void logon(String string) {
        if (this.log != null) {
            this.logoff();
        }
        try {
            this.log = new PrintWriter(new FileOutputStream(string));
            this.display("Start capture to file:" + string);
        }
        catch (Exception exception) {
            this.display(exception.toString());
        }
    }

    public final void logoff() {
        if (this.log != null) {
            try {
                this.log.close();
            }
            catch (Exception exception) {
                this.finest("Exception in logoff() " + exception);
            }
            this.log = null;
            this.display("Log file closed");
        }
    }

    public final void dumpDiag() {
        this.execDebugDiag();
    }

    public final void dumpExceptions() {
        this.dash("Exceptions Dump");
        if (this.excList.size() > 0) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            LinkedList linkedList = (LinkedList)this.excList.clone();
            for (ExcHolder excHolder : linkedList) {
                this.display(dateFormat.format(new Date(excHolder.time)) + "--------------------------");
                this.rootPrintStackTrace(excHolder.exc);
            }
        } else {
            this.display("No exception thrown");
        }
    }

    public final synchronized void resetExceptionBuffer() {
        this.excList.clear();
    }

    public final void dumpVitalMessages() {
        this.dash("Vital Messages");
        if (!this.myVitalMessageList.isEmpty()) {
            LinkedList linkedList = (LinkedList)this.myVitalMessageList.clone();
            for (LogMessageHolder logMessageHolder : linkedList) {
                this.display(logMessageHolder.getFormattedMessage());
            }
        } else {
            this.display("No vital messages captured");
        }
        this.dash("--------------");
        this.display("\n");
    }

    public final void resetVitalMessages() {
        this.purgeVitalMessages();
    }

    public final void telnetd(String string) {
        this.telnetd(string, 9401);
    }

    public final void telnetd(String string, int n) {
        DebugTelnetd debugTelnetd = new DebugTelnetd(this, n, string);
        debugTelnetd.start();
    }

    public final void showExceptions(boolean bl) {
        this.dbm.setExcToSysOut(bl);
    }

    public final void setBufferSize(int n) {
        this.excBufSize = n;
        this.prefs.setInt(PREFS_PATH, PREFS_BUFSIZE, this.excBufSize);
    }

    public final void showBufferSize() {
        this.display("Buffer size: " + this.excBufSize);
    }

    public final void dash(String string) {
        this.display(dashText + string + dashText);
    }

    public final void formatList(boolean bl, int n, int n2) {
        listDup = bl;
        this.listLineLen = n;
        this.listCols = n2;
        this.display("Display dups=" + listDup + " LineLen=" + this.listLineLen + " Cols=" + n2);
        this.prefs.setInt(PREFS_PATH, PREFS_LIST_COLS, this.listCols);
        this.prefs.setInt(PREFS_PATH, PREFS_LIST_LINE_LEN, this.listLineLen);
        this.prefs.setBoolean(PREFS_PATH, PREFS_LIST_DUPS, listDup);
    }

    public final void showDefaultLogLevel() {
        this.display(DefaultLogLevel.toString());
    }

    public final void setDefaultLogLevel(String string) {
        try {
            LogLevel logLevel;
            DefaultLogLevel = logLevel = LogLevel.parse(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.display(illegalArgumentException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            this.display("No logging level specified");
        }
    }

    private String getTimeStamp() {
        long l = System.currentTimeMillis();
        if (l != this.cachedTime) {
            this.cachedTimeStamp = this.sdf.format(new Date(l));
            this.cachedTime = l;
        }
        return this.cachedTimeStamp;
    }

    private void printTable(Iterator iterator, int n, int n2, String string, String string2) {
        int n3 = (n2 - string2.length() - string.length() * (n - 1)) / n;
        if (n3 < 2) {
            return;
        }
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string3;
            int n5;
            if (n4 == 0) {
                stringBuffer.append(string2);
            }
            if ((n5 = (string3 = iterator.next().toString()).length()) > n3) {
                stringBuffer.append(string3.substring(0, n3));
            } else {
                stringBuffer.append(string3);
                while (n5 < n3) {
                    stringBuffer.append(" ");
                    ++n5;
                }
            }
            if (++n4 == n) {
                this.display(stringBuffer.toString());
                stringBuffer.setLength(0);
                n4 = 0;
                continue;
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0) {
            this.display(stringBuffer.toString());
        }
    }

    @Override
    void printTable(Iterator iterator) {
        this.printTable(iterator, this.listCols, this.listLineLen, " ", " ");
    }

    public synchronized List getExceptionBuffer() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (this.excList.size() > 0) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            for (ExcHolder excHolder : this.excList) {
                linkedList.add(dateFormat.format(new Date(excHolder.time)));
                linkedList.add(excHolder.exc);
            }
        }
        return linkedList;
    }

    private class ExcHolder {
        Throwable exc;
        long time;

        ExcHolder(Throwable throwable) {
            this.exc = throwable;
            this.time = System.currentTimeMillis();
        }
    }

    private class LogMessageHolder {
        long myLogTime;
        LogLevel myLogSeverity;
        String myLogOriginator;
        String myLogMessage;
        String myOriginatorThreadname;

        LogMessageHolder(KDebug kDebug, LogLevel logLevel, String string) {
            this.myLogOriginator = kDebug.getFullName();
            this.myLogMessage = string;
            this.myLogSeverity = logLevel;
            this.myLogTime = System.currentTimeMillis();
            this.myOriginatorThreadname = Thread.currentThread().getName();
        }

        String getOriginator() {
            return this.myLogOriginator;
        }

        String getOriginatorThreadname() {
            return this.myOriginatorThreadname;
        }

        String getFormattedMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(RootDebug.this.sdf.format(new Date(this.myLogTime)));
            stringBuffer.append("[");
            stringBuffer.append(this.myLogOriginator);
            stringBuffer.append("|");
            stringBuffer.append(this.myOriginatorThreadname);
            stringBuffer.append("] ");
            stringBuffer.append(this.myLogMessage);
            return stringBuffer.toString();
        }
    }
}

