/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import java.net.InetAddress;

public class SckfwdClient
implements Comparable {
    private Sckfwd _server;
    private InetAddress _host;
    private InetAddress _targetHost;
    private InetAddress _maskedVirtual;
    private int _maskLength;
    private int _cost;
    private int _flags;
    private int _nodeId;

    public SckfwdClient(Sckfwd sckfwd, InetAddress inetAddress, int n) {
        this(sckfwd, inetAddress, null, n);
    }

    public SckfwdClient(Sckfwd sckfwd, InetAddress inetAddress, InetAddress inetAddress2, int n) {
        this(sckfwd, inetAddress, inetAddress2, CtcProxyFactory.getSizeInBits(inetAddress), n, 170, 0);
    }

    public SckfwdClient(SckfwdClient sckfwdClient) {
        this(sckfwdClient._server, sckfwdClient._host, sckfwdClient._targetHost, sckfwdClient._maskLength, sckfwdClient._cost, sckfwdClient._flags, sckfwdClient._nodeId);
    }

    public SckfwdClient(Sckfwd sckfwd, InetAddress inetAddress, InetAddress inetAddress2, int n, int n2, int n3, int n4) {
        this._server = sckfwd;
        this._host = inetAddress;
        this._targetHost = inetAddress2;
        this._maskLength = n;
        this._maskedVirtual = CtcProxyFactory.maskAddress(this._host, this._maskLength);
        this._cost = n2;
        this._flags = n3;
        this._nodeId = n4;
    }

    public Sckfwd getServer() {
        return this._server;
    }

    public InetAddress getHost() {
        return this._host;
    }

    public InetAddress getTargetHost() {
        return this._targetHost;
    }

    public String getMask() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = CtcProxyFactory.makeMask(CtcProxyFactory.getSizeInBits(this._host), this._maskLength);
        stringBuffer.append(byArray[0] & 0xFF);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append('.');
            stringBuffer.append(byArray[i] & 0xFF);
        }
        return stringBuffer.toString();
    }

    public int getMaskLength() {
        return this._maskLength;
    }

    public int getCost() {
        return this._cost;
    }

    public int getNodeId() {
        return this._nodeId;
    }

    public int getFlags() {
        return this._flags;
    }

    boolean isPotentialServer() {
        int n = this._flags & 0x30;
        return this._maskLength == CtcProxyFactory.getSizeInBits(this._host) && (n == 16 || n == 32) && CtcProxyFactory.isDesignatedGne(this._host);
    }

    public String toString() {
        return this._host.getHostAddress() + "/" + this._maskLength + "/0x" + Integer.toHexString(this._flags) + "/" + this._cost + "/ nodeID:" + Integer.toHexString(this._nodeId);
    }

    public boolean matches(InetAddress inetAddress) {
        if (CtcProxyFactory.getSizeInBits(inetAddress) == CtcProxyFactory.getSizeInBits(this._maskedVirtual)) {
            InetAddress inetAddress2 = CtcProxyFactory.maskAddress(inetAddress, this._maskLength);
            return inetAddress2.equals(this._maskedVirtual);
        }
        return false;
    }

    public int compareTo(Object object) {
        String string;
        SckfwdClient sckfwdClient = (SckfwdClient)object;
        String string2 = this._host.getHostAddress();
        int n = string2.compareTo(string = sckfwdClient._host.getHostAddress());
        if (n == 0) {
            n = this._maskLength < sckfwdClient._maskLength ? -1 : (this._maskLength > sckfwdClient._maskLength ? 1 : (this._cost < sckfwdClient._cost ? -1 : (this._cost > sckfwdClient._cost ? 1 : (this._flags < sckfwdClient._flags ? -1 : (this._flags > sckfwdClient._flags ? 1 : 0)))));
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._host.hashCode() + this._maskLength + this._cost + this._flags;
    }
}

