/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.proxy;

import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.Sckfwd;
import cerent.util.proxy.SckfwdClient;
import cerent.util.proxy.SckfwdIo;
import cerent.util.proxy.SckfwdReply;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class SckfwdClientsReply
extends SckfwdReply
implements Comparable {
    private InetAddress _server;
    private ArrayList<SckfwdClient> _clients;

    SckfwdClientsReply(Sckfwd sckfwd, SckfwdIo sckfwdIo) throws IOException {
        this.readVersion(sckfwdIo);
        int n = sckfwdIo.readByte();
        if (n != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.requestException(n);
        }
        int n2 = sckfwdIo.readByte();
        if (n2 != 0) {
            sckfwdIo.skip(sckfwdIo.available());
            throw sckfwdIo.protocolError("reserved byte (" + n2 + ") not zero");
        }
        int n3 = sckfwdIo.readByte();
        this._server = sckfwdIo.readAddress(n3);
        int n4 = sckfwdIo.readShort();
        this._clients = new ArrayList();
        int n5 = CtcProxyFactory.defaultCost();
        for (int i = 0; i < n4; ++i) {
            InetAddress inetAddress = sckfwdIo.readAddress(n3);
            int n6 = n5;
            if (inetAddress.equals(this._server)) {
                n6 = 0;
            }
            this._clients.add(new SckfwdClient(sckfwd, inetAddress, n6));
        }
        Collections.sort(this._clients);
    }

    InetAddress getServer() {
        return this._server;
    }

    ArrayList clients() {
        return (ArrayList)this._clients.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#<clients");
        for (SckfwdClient sckfwdClient : this._clients) {
            stringBuffer.append(" ");
            stringBuffer.append(sckfwdClient.toString());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        if (object instanceof SckfwdClientsReply) {
            int n = 0;
            SckfwdClientsReply sckfwdClientsReply = (SckfwdClientsReply)object;
            Iterator<SckfwdClient> iterator = this._clients.iterator();
            Iterator<SckfwdClient> iterator2 = sckfwdClientsReply._clients.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                n = iterator.next().compareTo(iterator2.next());
                if (n == 0) continue;
                return n;
            }
            if (iterator.hasNext()) {
                n = -1;
            } else if (iterator2.hasNext()) {
                n = 1;
            }
            return n;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n = this._clients.size();
        for (SckfwdClient sckfwdClient : this._clients) {
            n ^= sckfwdClient.hashCode();
        }
        return n;
    }
}

