/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.rmi;

import cerent.launcher.Bootstrap;
import cerent.util.KDebug;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.security.Permission;
import java.util.Map;

public class LoaderHandler
extends RMIClassLoaderSpi {
    protected static final String rmiInternalClass = "sun.rmi.server.LoaderHandler";
    protected static final String rmiInternalLoaderClass = "sun.rmi.server.LoaderHandler$Loader";
    protected static final Class internalLoaderClass = LoaderHandler._getClass("sun.rmi.server.LoaderHandler");
    protected static final Class internalCLClass = LoaderHandler._getClass("sun.rmi.server.LoaderHandler$Loader");
    protected static final Field cbField = LoaderHandler._getField("codebaseProperty", internalLoaderClass);
    protected static final Field cbLoadersField = LoaderHandler._getField("codebaseLoaders", internalLoaderClass);
    protected static final Method getClassAnnotationMethod = LoaderHandler._getMethod("getClassAnnotation", internalCLClass);
    private static KDebug db = new KDebug("LoaderHandler");
    protected static String codebaseProperty = null;

    public Class loadClass(String string, String string2, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        if (db.isFinestEnabled()) {
            db.finest("loadClass: '" + string + "', " + string2);
        }
        ClassLoader classLoader2 = this.getDefaultLoader(classLoader);
        ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != null) {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        Class<?> clazz = null;
        try {
            clazz = sun.rmi.server.LoaderHandler.loadClass(string, string2, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (db.isFinerEnabled()) {
                db.finest("loadClass failed for: '" + string + "', " + string2);
            }
            throw classNotFoundException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader3);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadProxyClass(String string, String[] stringArray, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        Object object;
        Object object2;
        if (db.isFinestEnabled()) {
            object2 = new StringBuffer();
            int n = stringArray == null ? 0 : stringArray.length;
            for (int i = 0; i < n; ++i) {
                ((StringBuffer)object2).append(" ");
                ((StringBuffer)object2).append(stringArray[i]);
            }
            object = ((StringBuffer)object2).toString();
            db.finest("loadProxyClass: '" + string + "', " + (String)object);
        }
        object2 = this.getDefaultLoader(classLoader);
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (object2 != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)object2);
        }
        object = null;
        try {
            object = sun.rmi.server.LoaderHandler.loadProxyClass(string, stringArray, (ClassLoader)object2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        return object;
    }

    @Override
    public ClassLoader getClassLoader(String string) throws MalformedURLException {
        return sun.rmi.server.LoaderHandler.getClassLoader(string);
    }

    @Override
    public String getClassAnnotation(Class<?> clazz) {
        ClassLoader classLoader;
        String string = clazz.getName();
        int n = string.length();
        if (n > 0 && string.charAt(0) == '[') {
            int n2;
            for (n2 = 1; n > n2 && string.charAt(n2) == '['; ++n2) {
            }
            if (n > n2 && string.charAt(n2) != 'L') {
                return null;
            }
        }
        if ((classLoader = clazz.getClassLoader()) == null || LoaderHandler.codebaseLoadersContainsKey(classLoader)) {
            return codebaseProperty;
        }
        String string2 = null;
        if (LoaderHandler.isRMIInternalClassLoader(classLoader)) {
            string2 = LoaderHandler.getLoaderClassAnnotation(classLoader);
        } else if (classLoader instanceof URLClassLoader) {
            try {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                if (uRLArray != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        for (int i = 0; i < uRLArray.length; ++i) {
                            Permission permission = uRLArray[i].openConnection().getPermission();
                            if (permission == null) continue;
                            securityManager.checkPermission(permission);
                        }
                    }
                    string2 = LoaderHandler.urlsToPath(uRLArray, codebaseProperty);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = codebaseProperty;
        }
        if (db.isFinestEnabled()) {
            db.finest("+++ CB annot for " + clazz.getName() + ": " + string2);
        }
        return string2;
    }

    protected static String urlsToPath(URL[] uRLArray, String string) {
        if (uRLArray.length == 0) {
            return null;
        }
        if (uRLArray.length == 1) {
            return LoaderHandler.url2String(uRLArray[0], string);
        }
        StringBuffer stringBuffer = new StringBuffer(LoaderHandler.url2String(uRLArray[0], string));
        for (int i = 1; i < uRLArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(LoaderHandler.url2String(uRLArray[i], string));
        }
        return stringBuffer.toString();
    }

    protected static String url2String(URL uRL, String string) {
        if (string == null || string.length() == 0) {
            return uRL.toExternalForm();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(uRL.getPath());
        return stringBuffer.toString();
    }

    protected static String getCodebaseProperty() {
        String string = "";
        try {
            cbField.setAccessible(true);
            string = (String)cbField.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoaderHandler.displayFatal("couldn't access field: " + cbField.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LoaderHandler.displayFatal("couldn't access field: " + cbField.getName(), illegalAccessException);
        }
        return string;
    }

    protected static boolean codebaseLoadersContainsKey(ClassLoader classLoader) {
        Map map = null;
        try {
            cbLoadersField.setAccessible(true);
            map = (Map)cbLoadersField.get(null);
            return map.containsKey(classLoader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoaderHandler.displayFatal("couldn't access field: " + cbLoadersField.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LoaderHandler.displayFatal("couldn't access field: " + cbLoadersField.getName(), illegalAccessException);
        }
        return false;
    }

    protected static boolean isRMIInternalClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        Class<?> clazz = classLoader.getClass();
        return clazz.getName().equals(rmiInternalLoaderClass);
    }

    protected static String getLoaderClassAnnotation(ClassLoader classLoader) {
        String string = "";
        try {
            getClassAnnotationMethod.setAccessible(true);
            string = (String)getClassAnnotationMethod.invoke((Object)classLoader, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoaderHandler.displayFatal("couldn't invoke method: " + getClassAnnotationMethod.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LoaderHandler.displayFatal("couldn't invoke method: " + getClassAnnotationMethod.getName(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LoaderHandler.displayFatal("couldn't invoke method: " + getClassAnnotationMethod.getName(), invocationTargetException);
        }
        return string;
    }

    protected ClassLoader getDefaultLoader(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Bootstrap.getIFClassLoader();
        }
        if (db.isFinerEnabled()) {
            db.finer("default CL is now: " + (classLoader2 == null ? "null" : classLoader2.toString()));
        }
        return classLoader2;
    }

    protected static Class _getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LoaderHandler.displayFatal("can't load class: " + string + " in class " + clazz.getName(), classNotFoundException);
        }
        return clazz;
    }

    protected static Field _getField(String string, Class clazz) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LoaderHandler.displayFatal("can't lookup field: " + string + " in class " + clazz.getName(), noSuchFieldException);
        }
        catch (NullPointerException nullPointerException) {
            LoaderHandler.displayFatal("can't lookup field: " + string + " in class " + clazz.getName(), nullPointerException);
        }
        catch (SecurityException securityException) {
            LoaderHandler.displayFatal("can't lookup field: " + string + " in class " + clazz.getName(), securityException);
        }
        return field;
    }

    protected static Method _getMethod(String string, Class clazz) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoaderHandler.displayFatal("can't lookup method: " + string + " in class " + clazz.getName(), noSuchMethodException);
        }
        catch (NullPointerException nullPointerException) {
            LoaderHandler.displayFatal("can't lookup method: " + string + " in class " + clazz.getName(), nullPointerException);
        }
        catch (SecurityException securityException) {
            LoaderHandler.displayFatal("can't lookup method: " + string + " in class " + clazz.getName(), securityException);
        }
        return method;
    }

    private static void displayFatal(String string, Throwable throwable) {
        db.setLogLevel("FINEST");
        db.println(string);
        KDebug.printStackTrace(throwable);
    }

    static {
        codebaseProperty = LoaderHandler.getCodebaseProperty();
    }
}

