/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.util.ComparisonUtil;
import cerent.util.KDebug;
import cerent.version.ComparableFactory;
import cerent.version.IBuildInformation;
import cerent.version.VersionFormatEnum;
import java.lang.reflect.Field;
import java.text.DecimalFormat;

public final class InternalLayerVersion
implements Comparable {
    private static final KDebug db = new KDebug("InternalLayerVersion");
    private static final String MY_NAME = InternalLayerVersion.class.getName();
    private static DecimalFormat sixDigitFormat = new DecimalFormat("000000");
    public static final int UNAVAILABLE = -1;
    public static final int MMX = 330;
    public static final int HAWK = 400;
    public static final InternalLayerVersion HAWK_OBJ = new InternalLayerVersion("hawk", 400);
    public static final int EURO = 410;
    public static final InternalLayerVersion EURO_OBJ = new InternalLayerVersion("euro", 410);
    public static final int BLUESTEEL = 430;
    public static final int CHIEF = 450;
    public static final int PATRIOT = 460;
    public static final int CHIEF2 = 470;
    public static final int MAVERICK = 500;
    public static final InternalLayerVersion MAVERICK_OBJ = new InternalLayerVersion("maverick", 500);
    public static final int SHILLING = 502;
    public static final int RUBLE = 505;
    public static final InternalLayerVersion OLDEST_UNIFIED_ELE_VERSION = new InternalLayerVersion("chief2", 470);
    public static final int MARINER = 700;
    public static final InternalLayerVersion MARINER_OBJ = new InternalLayerVersion("mariner", 700);
    public static final int CONQUEROR = 800;
    public static final InternalLayerVersion CONQUEROR_OBJ = new InternalLayerVersion("conqueror", 800);
    public static final int CUNCTATOR = 850;
    public static final InternalLayerVersion CUNCTATOR_OBJ = new InternalLayerVersion("cunctator", 850);
    public static final int BADGER = 900;
    public static final InternalLayerVersion BADGER_OBJ = new InternalLayerVersion("badger", 900);
    public static final int CPTCOOK = 910;
    public static final InternalLayerVersion CPTCOOK_OBJ = new InternalLayerVersion("cptcook", 910);
    public static final int MARCOPOLO = 920;
    public static final InternalLayerVersion MARCOPOLO_OBJ;
    public static final InternalLayerVersion LATEST_VER_OBJ;
    public static final String IF = "if";
    public static final String NET = "net";
    public static final String ELE = "ele";
    public static final String ORB = "orb";
    public static final String LAUNCHER = "launcher";
    public static final String COMPAT = "compat";
    public static final String NE = "ne";
    public static final int ERN_MIN = 10000;
    private String name;
    private int sequence;
    public final int psequence;
    private String originalVersionStr;

    public InternalLayerVersion(String string, int n, String string2) {
        this.originalVersionStr = string2;
        int n2 = n;
        if (n2 < 10000 && n2 > -1) {
            n2 *= 100;
        }
        if (n2 > 999900) {
            n2 = 999900;
        }
        this.name = string == null ? "" : string;
        this.psequence = this.sequence = n2;
    }

    public InternalLayerVersion(String string, int n) {
        this(string, n, null);
    }

    public String getOriginalVersionStr() {
        return this.originalVersionStr;
    }

    public boolean isUnavailable() {
        return this.sequence == -1;
    }

    public InternalLayerVersion(String string) {
        this.name = string;
        this.sequence = -1;
        this.psequence = -1;
    }

    public InternalLayerVersion(String string, IBuildInformation iBuildInformation) {
        String string2 = iBuildInformation.getNgrp().getMajorReleaseNumber() + iBuildInformation.getNgrp().getMaintenanceReleaseNumber();
        String string3 = string2.substring(0, 2) + string2.substring(3);
        Comparable comparable = ComparableFactory.createComparable(string, VersionFormatEnum.INTERNAL, string3);
        if (!(comparable instanceof InternalLayerVersion)) {
            throw new IllegalStateException("this implementation of ILV requires the Comparable be an instanceof InternalLayerVersion, not: " + comparable.getClass().getName());
        }
        this.copyState((InternalLayerVersion)comparable);
        this.psequence = this.sequence;
    }

    public InternalLayerVersion(String string, String string2) {
        Comparable comparable = ComparableFactory.createComparable(string, VersionFormatEnum.MANIFEST_FULL_VERSION, string2);
        if (!(comparable instanceof InternalLayerVersion)) {
            throw new IllegalStateException("this implementation of ILV requires the Comparable be an instanceof InternalLayerVersion, not: " + comparable.getClass().getName());
        }
        this.copyState((InternalLayerVersion)comparable);
        this.psequence = this.sequence;
    }

    public InternalLayerVersion(Comparable comparable) {
        if (!(comparable instanceof InternalLayerVersion)) {
            throw new IllegalStateException("this implementation of ILV requires the Comparable be an instanceof InternalLayerVersion, not: " + comparable.getClass().getName());
        }
        this.copyState((InternalLayerVersion)comparable);
        this.psequence = this.sequence;
    }

    public InternalLayerVersion(String string, Comparable comparable) {
        if (!(comparable instanceof InternalLayerVersion)) {
            throw new IllegalStateException("this implementation of ILV requires the Comparable be an instanceof InternalLayerVersion, not: " + comparable.getClass().getName());
        }
        this.copyState((InternalLayerVersion)comparable);
        this.psequence = this.sequence;
        this.name = string;
    }

    private void copyState(InternalLayerVersion internalLayerVersion) {
        this.name = internalLayerVersion.name;
        this.sequence = internalLayerVersion.sequence;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (this != object) {
            int n2 = 0;
            if (object instanceof InternalLayerVersion) {
                n2 = ((InternalLayerVersion)object).sequence;
            } else {
                if (object == null) {
                    return -1;
                }
                Class<?> clazz = object.getClass();
                if (clazz.getName().equals(MY_NAME)) {
                    try {
                        Field field = clazz.getField("psequence");
                        Integer n3 = (Integer)field.get(object);
                        n2 = n3;
                    }
                    catch (ClassCastException classCastException) {
                        if (db.on()) {
                            KDebug.printStackTrace(classCastException);
                        }
                        return -1;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (db.on()) {
                            KDebug.printStackTrace(noSuchFieldException);
                        }
                        return -1;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (db.on()) {
                            KDebug.printStackTrace(illegalAccessException);
                        }
                        return -1;
                    }
                } else {
                    db.severe("ILV: unsupported compare type: " + object.getClass().getName());
                    return -1;
                }
            }
            n = ComparisonUtil.compare(this.sequence, n2);
        }
        return n;
    }

    public String getLayerName() {
        return this.name;
    }

    public int getLayerVersion() {
        return this.sequence / 100;
    }

    public String getLayerVersionString() {
        String string = sixDigitFormat.format(this.sequence).toString();
        return string;
    }

    public Comparable getLayerComparable() {
        return this;
    }

    public int hashCode() {
        int n = 7;
        n = 13 * n + this.name.hashCode();
        n = 13 * n + this.sequence;
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof InternalLayerVersion) {
            InternalLayerVersion internalLayerVersion = (InternalLayerVersion)object;
            bl = this.getLayerName().equals(internalLayerVersion.getLayerName()) && this.getLayerComparable().compareTo(internalLayerVersion.getLayerComparable()) == 0;
        }
        return bl;
    }

    public boolean isCoreJarFile() {
        boolean bl = false;
        if (this.name.equals(ORB) || this.name.equals(LAUNCHER) || this.name.equals(IF) || this.name.equals(NET)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        String string = this.getLayerName();
        string = string != null && string.length() > 0 ? string.toUpperCase() + ".v." : "";
        return string + this.sequence;
    }

    public String prettyString() {
        return "ILV: name=" + this.name + "  sequence=" + this.sequence;
    }

    static {
        LATEST_VER_OBJ = MARCOPOLO_OBJ = new InternalLayerVersion("marcopolo", 920);
    }
}

