/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import com.cisco.ctc.core.download.JarTransferEnum;
import java.util.Locale;

public enum ClassLoaderEnum {
    SYSTEM(ClassLoaderEnum.toUpperCase("launcher"), "bootstrap", JarTransferEnum.getCoreNoCompressionPreferredTypes()),
    IF(ClassLoaderEnum.toUpperCase("if"), SYSTEM, "interface", JarTransferEnum.getCoreCompressionPreferredTypes()),
    NET(ClassLoaderEnum.toUpperCase("net"), IF, "network", JarTransferEnum.getCoreCompressionPreferredTypes()),
    ELE(ClassLoaderEnum.toUpperCase("ele"), IF, false, "element");

    public final String jarPrefix;
    public final String jarMcPrefix;
    public final String jarLcPrefix;
    public final String voName;
    public final String extenderPref;
    public final String clurlPrefix;
    public final String extenderFilesPref;
    public final String manifestPrefix;
    public final boolean isCore;
    public final ClassLoaderEnum parent;
    public final JarTransferEnum.Type[] preferredDownloadTypes;

    private ClassLoaderEnum(String string2, String string3, JarTransferEnum.Type[] typeArray) {
        this(string2, null, true, string3, typeArray);
    }

    private ClassLoaderEnum(String string2, ClassLoaderEnum classLoaderEnum, String string3) {
        this(string2, classLoaderEnum, true, string3);
    }

    private ClassLoaderEnum(String string2, ClassLoaderEnum classLoaderEnum, String string3, JarTransferEnum.Type[] typeArray) {
        this(string2, classLoaderEnum, true, string3, typeArray);
    }

    private ClassLoaderEnum(String string2, ClassLoaderEnum classLoaderEnum, boolean bl, String string3) {
        this(string2, classLoaderEnum, bl, string3, JarTransferEnum.getPreferredTypes());
    }

    private ClassLoaderEnum(String string2, ClassLoaderEnum classLoaderEnum, boolean bl, String string3, JarTransferEnum.Type[] typeArray) {
        this.jarPrefix = string2;
        this.jarMcPrefix = ClassLoaderEnum.mixedCase(string2);
        this.voName = this.jarLcPrefix = ClassLoaderEnum.toLowerCase(string2);
        this.extenderPref = this.jarLcPrefix + "." + "classpath.extender";
        this.extenderFilesPref = this.jarLcPrefix + "." + "classpath.extender.files";
        this.clurlPrefix = "ctc.clurl" + string2;
        this.parent = classLoaderEnum;
        this.isCore = bl;
        this.manifestPrefix = string3;
        this.preferredDownloadTypes = typeArray;
    }

    private static String toLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    private static String mixedCase(String string) {
        return ClassLoaderEnum.toUpperCase(string.substring(0, 1)) + ClassLoaderEnum.toLowerCase(string.substring(1));
    }

    public static ClassLoaderEnum getClassLoaderEnum(String string) {
        String string2 = ClassLoaderEnum.toUpperCase(string);
        ClassLoaderEnum classLoaderEnum = null;
        for (ClassLoaderEnum classLoaderEnum2 : ClassLoaderEnum.values()) {
            if (!string2.startsWith(classLoaderEnum2.jarPrefix)) continue;
            classLoaderEnum = classLoaderEnum2;
            break;
        }
        if (classLoaderEnum == null && string.compareToIgnoreCase("ctclauncher.jar") == 0) {
            classLoaderEnum = SYSTEM;
        }
        return classLoaderEnum;
    }

    public static ClassLoaderEnum getClassLoaderEnumByCLURL(String string) {
        ClassLoaderEnum classLoaderEnum = null;
        for (ClassLoaderEnum classLoaderEnum2 : ClassLoaderEnum.values()) {
            if (!string.startsWith(classLoaderEnum2.clurlPrefix)) continue;
            classLoaderEnum = classLoaderEnum2;
            break;
        }
        return classLoaderEnum;
    }
}

