/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CmsClassLoader;
import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import com.cisco.ctc.core.AbstractClassLoaderLocatingStrategy;
import com.cisco.ctc.core.BaseCoreReflectionUtil;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.CoreClassLoaderLocatingStrategy;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.EleClassLoaderLocatingStrategy;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.RetryableException;
import java.io.IOException;
import java.util.Observer;

public class ClassLoaderManager
implements IClassLoaderManager {
    public static final CoreClassLoaderLocatingStrategy defaultCcll = CoreClassLoaderLocatingStrategy.instance();
    public static final EleClassLoaderLocatingStrategy defaultEcll = EleClassLoaderLocatingStrategy.instance();
    private static boolean dontCare = ClassLoaderManager.initEcll();
    protected CoreClassLoaderLocatingStrategy ccll = defaultCcll;
    protected EleClassLoaderLocatingStrategy ecll = defaultEcll;
    private static final long RETRY_MSEC_TIME = CoreConstants.prefs.getInt("ctc", "classloading.retrytime", 1000);
    private static Debug db = new Debug("ClassLoaderManager");
    private static ClassLoaderManager instance;

    private static boolean initEcll() {
        defaultEcll.setCoreCllStrategy(defaultCcll);
        return true;
    }

    protected ClassLoaderManager() throws IOException {
    }

    public static IClassLoaderManager instance() {
        return instance;
    }

    protected synchronized ClassLoader getClassLoader(AbstractClassLoaderLocatingStrategy abstractClassLoaderLocatingStrategy, String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws ClassLoaderException, IOException, ClassNotFoundException {
        ClassLoader classLoader = null;
        if (db.isFinerEnabled()) {
            db.finer("entering getClassLoader(" + CoreConstants.GetActualAddress(string) + ", " + (Object)((Object)nETypeEnum) + ", " + (Object)((Object)classLoaderEnum) + ", " + comparable + ")");
        }
        int n = 0;
        while (true) {
            try {
                Comparable comparable2 = null;
                if (!classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM)) {
                    INgrp iNgrp = this.getSystemNgrp();
                    comparable2 = iNgrp.getManifestVersionOrdinal();
                }
                classLoader = abstractClassLoaderLocatingStrategy.locateClassLoader(string, nETypeEnum, classLoaderEnum, comparable, comparable2);
                break;
            }
            catch (RetryableException retryableException) {
                if (db.on()) {
                    db.println("starting retry #" + (n + 1) + " CL locating...");
                    Debug.printStackTrace(retryableException);
                }
                try {
                    abstractClassLoaderLocatingStrategy.waitToRetry(RETRY_MSEC_TIME);
                }
                catch (InterruptedException interruptedException) {
                    Debug.printStackTrace(interruptedException);
                }
            }
            catch (RuntimeException runtimeException) {
                Debug.printStackTrace(runtimeException);
                throw runtimeException;
            }
            catch (Throwable throwable) {
                if (db.on()) {
                    Debug.printStackTrace(throwable);
                }
                if (throwable instanceof ClassLoaderException) {
                    throw (ClassLoaderException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof ClassNotFoundException && classLoaderEnum == ClassLoaderEnum.ELE) {
                    throw (ClassNotFoundException)throwable;
                }
                throw new ClassLoaderException(throwable);
            }
            ++n;
        }
        return classLoader;
    }

    @Override
    public ClassLoader getCoreClassLoader(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) throws ClassLoaderException, IOException {
        try {
            return this.getClassLoader(this.ccll, string, nETypeEnum, classLoaderEnum, comparable);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassLoaderException(classNotFoundException);
        }
    }

    @Override
    public ClassLoader getEleClassLoader(String string, NETypeEnum nETypeEnum, Comparable comparable) throws ClassLoaderException, IOException, ClassNotFoundException {
        ClassLoaderEnum classLoaderEnum = ClassLoaderEnum.ELE;
        return this.getClassLoader(this.ecll, string, nETypeEnum, classLoaderEnum, comparable);
    }

    @Override
    public boolean removeClassLoader(ClassLoader classLoader) {
        boolean bl = this.ccll.removeClassLoader(classLoader);
        if (!bl) {
            bl = this.ecll.removeClassLoader(classLoader);
        }
        return bl;
    }

    @Override
    public String getSystemSwVersion() {
        return this.ccll.getSystemSwVersion();
    }

    @Override
    public INgrp getSystemNgrp() {
        return this.ccll.getSystemNgrp();
    }

    @Override
    public void addObserver(Observer observer) {
        this.ccll.addObserver(observer);
        this.ecll.addObserver(observer);
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.ccll.deleteObserver(observer);
        this.ecll.deleteObserver(observer);
    }

    @Override
    public ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaderArray = this.ccll.getClassLoaders();
        ClassLoader[] classLoaderArray2 = this.ecll.getClassLoaders();
        ClassLoader[] classLoaderArray3 = new ClassLoader[classLoaderArray.length + classLoaderArray2.length];
        System.arraycopy(classLoaderArray, 0, classLoaderArray3, 0, classLoaderArray.length);
        System.arraycopy(classLoaderArray2, 0, classLoaderArray3, classLoaderArray.length, classLoaderArray2.length);
        return classLoaderArray3;
    }

    static {
        try {
            instance = new ClassLoaderManager();
        }
        catch (IOException iOException) {
            db.println("ClassLoaderManager creation failed:");
            Debug.printStackTrace(iOException);
            throw new RuntimeException(iOException);
        }
        catch (RuntimeException runtimeException) {
            db.println("ClassLoaderManager creation failed:");
            Debug.printStackTrace(runtimeException);
            throw runtimeException;
        }
    }

    public static class Debug
    extends KDebug
    implements IDebugDiag {
        public Debug(String string) {
            super(string);
        }

        @Override
        public final void dumpDiag() {
            defaultCcll.dumpDiag();
            defaultEcll.dumpDiag();
        }

        public final void dumpClassLoaders() {
            ClassLoader[] classLoaderArray = instance.getClassLoaders();
            this.println("# of CLs: " + classLoaderArray.length);
            for (ClassLoader classLoader : classLoaderArray) {
                this.println("  " + classLoader);
            }
        }

        public final void loadClass(String string, String string2) {
            try {
                ClassLoaderEnum classLoaderEnum = ClassLoaderEnum.getClassLoaderEnum(string);
                ClassLoader[] classLoaderArray = instance.getClassLoaders();
                ClassLoader classLoader = null;
                for (ClassLoader classLoader2 : classLoaderArray) {
                    CmsClassLoader cmsClassLoader;
                    ClassLoaderEnum classLoaderEnum2;
                    if (!(classLoader2 instanceof CmsClassLoader) || !(classLoaderEnum2 = (cmsClassLoader = (CmsClassLoader)classLoader2).getClassLoaderEnum()).equals((Object)classLoaderEnum)) continue;
                    classLoader = classLoader2;
                    break;
                }
                Class clazz = BaseCoreReflectionUtil.loadClass(classLoader, string2, true);
                this.println("class: " + string2 + " loaded ok by: " + (classLoader == null ? "SCL" : classLoader.toString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.printStackTrace(classNotFoundException);
            }
        }
    }
}

