/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.NETypeEnum;

public class CtcBootstrapJar {
    private final ClassLoaderEnum clEnum;
    private final NETypeEnum neType;
    private Comparable version;
    private String name;

    public CtcBootstrapJar(ClassLoaderEnum classLoaderEnum, NETypeEnum nETypeEnum, Comparable comparable) {
        this.clEnum = classLoaderEnum;
        this.neType = nETypeEnum;
        this.version = comparable;
        this.initName();
    }

    private void initName() {
        StringBuilder stringBuilder = new StringBuilder(this.clEnum.jarPrefix);
        if (this.version != null) {
            NETypeEnum nETypeEnum;
            NETypeEnum nETypeEnum2 = nETypeEnum = this.clEnum.isCore ? NETypeEnum.NE_DONT_CARE : this.neType;
            if (nETypeEnum != null && nETypeEnum != NETypeEnum.NE_DONT_CARE) {
                stringBuilder.append(nETypeEnum.fifteenType);
            }
            stringBuilder.append("_");
            stringBuilder.append(CoreVersionUtil.instance().toString(this.version));
        }
        this.name = stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof CtcBootstrapJar) {
            CtcBootstrapJar ctcBootstrapJar = (CtcBootstrapJar)object;
            bl = this.name.equals(ctcBootstrapJar.name);
        }
        return bl;
    }

    public ClassLoaderEnum getClEnum() {
        return this.clEnum;
    }

    public NETypeEnum getNeType() {
        return this.neType;
    }

    public Comparable getVersion() {
        return this.version;
    }

    public void setVersion(Comparable comparable) {
        this.version = comparable;
        this.initName();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

