/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.cache;

import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClientFutureProofer;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.CtcBootstrapJar;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.NameVersion;
import com.cisco.ctc.core.cache.CtcCachedFile;
import com.cisco.ctc.core.cache.ICacheManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Observable;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class CacheManager
extends Observable
implements ICacheManager {
    private static final CacheManager instance = new CacheManager();
    private static final JarFileFilter JAR_FILTER = new JarFileFilter();
    private static final String CLEAN_ME_FILE = "cache.cleanme";
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static boolean refreshedOnce = false;
    private HashMap<String, INgrp> ngrpMap = new HashMap();
    private CmDebug db = new CmDebug();
    private String[] originalCacheDirList;
    private long[] originalLastModDates;
    private String writeDir;
    private LinkedList<CtcCachedFile> allCachedFiles = new LinkedList();
    private HashMap<CtcBootstrapJar, CtcCachedFile> bjarMap = new HashMap();
    private HashMap<String, CtcCachedFile> externalMap = new HashMap();
    private Object maplock = new Object();

    private CacheManager() {
    }

    @Override
    public void refresh(String[] stringArray) throws IOException {
        this.refresh(stringArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(String[] stringArray, int n) throws IOException {
        int n2;
        if (stringArray == null || stringArray.length == 0) {
            throw new IOException("The cache directory list is empty.");
        }
        if (n < 0 || n >= stringArray.length) {
            throw new IOException("Write directory index: " + n + " is out of bounds");
        }
        this.ngrpMap.clear();
        if (this.db.on()) {
            this.db.println("Directories passed are:");
            String[] objectArray = stringArray;
            n2 = objectArray.length;
            for (int string = 0; string < n2; ++string) {
                String bl = objectArray[string];
                this.db.println("   " + bl);
            }
        }
        long[] lArray = new long[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String file = stringArray[n2];
            File file2 = new File(file);
            if (!file2.exists()) {
                throw new IOException("The cache directory " + file + " does not exist.");
            }
            lArray[n2] = file2.lastModified();
            if (file2.isFile()) {
                throw new IOException(file + " is not a directory.");
            }
            stringArray[n2] = file2.getCanonicalPath();
        }
        n2 = 0;
        File file = null;
        Object object = this.maplock;
        synchronized (object) {
            refreshedOnce = true;
            this.allCachedFiles.clear();
            this.externalMap.clear();
            this.bjarMap.clear();
            this.originalCacheDirList = stringArray;
            this.originalLastModDates = lArray;
            this.writeDir = this.originalCacheDirList[n];
            for (String string : stringArray) {
                File file3 = new File(string);
                String[] stringArray2 = file3.list(JAR_FILTER);
                if (this.db.on()) {
                    this.db.println("Jar files found in " + file3 + " (" + stringArray2.length + "):");
                    for (String string2 : stringArray2) {
                        this.db.println(string2);
                    }
                }
                for (String string2 : stringArray2) {
                    if (n2 == 0 && CoreConstants.isDownloadingPermitted && string2.equals(CLEAN_ME_FILE)) {
                        n2 = 1;
                        file = new File(file3, string2);
                    }
                    try {
                        CtcCachedFile ctcCachedFile = this.check(string, string2);
                        if (ctcCachedFile.state == CtcCachedFile.State.EXTERNAL) {
                            int n3 = string2.lastIndexOf(46);
                            String string3 = string2.substring(0, n3);
                            if (this.externalMap.containsKey(string3)) {
                                this.db.warning("warning: duplicate external jar for the " + this.externalMap.get((Object)string3).file + " (file eclipsed was: " + ctcCachedFile.file + ")");
                                ctcCachedFile.state = CtcCachedFile.State.ECLIPSED;
                            } else {
                                this.externalMap.put(string3, ctcCachedFile);
                            }
                        } else {
                            if (this.bjarMap.containsKey(ctcCachedFile.bootstrapJar)) {
                                this.db.warning("warning: duplicate bootstrap cache jar for the " + (Object)((Object)ctcCachedFile.bootstrapJar.getClEnum()) + " Classloader is: " + this.bjarMap.get((Object)ctcCachedFile.bootstrapJar).file + " (file eclipsed was: " + ctcCachedFile.file + ")");
                                ctcCachedFile.state = CtcCachedFile.State.ECLIPSED;
                            }
                            if (ctcCachedFile.state == CtcCachedFile.State.VALID) {
                                this.bjarMap.put(ctcCachedFile.bootstrapJar, ctcCachedFile);
                            } else {
                                this.db.severe(ctcCachedFile.state.toString() + ":" + ctcCachedFile.getPath());
                            }
                        }
                        this.allCachedFiles.addLast(ctcCachedFile);
                    }
                    catch (RuntimeException runtimeException) {
                        this.db.println("error encountered on cache dir jar: " + string2);
                        CmDebug.printStackTrace(runtimeException);
                        throw runtimeException;
                    }
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
        if (this.db.isFinestEnabled()) {
            this.db.dumpDiag();
        }
        if (n2 != 0) {
            this.db.println("Startup cache cleanup running");
            boolean bl = this.deleteCache();
            if (!bl) {
                this.db.println("Startup cache cleanup was not successful");
                this.db.println("Check for a rogue CTC/java process holding onto 1/more of the cached jar files");
            }
            file.delete();
            try {
                CoreConstants.prefs.store();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void refresh() throws IOException {
        this.refresh(this.originalCacheDirList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesNeedRefresh() throws IOException {
        boolean bl = false;
        Object object = this.maplock;
        synchronized (object) {
            for (int i = 0; i < this.originalCacheDirList.length && !bl; ++i) {
                String string = this.originalCacheDirList[i];
                File file = new File(string);
                bl = this.originalLastModDates[i] != file.lastModified();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CtcCachedFile check(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        ClassLoaderEnum classLoaderEnum;
        INgrp iNgrp;
        CtcBootstrapJar ctcBootstrapJar;
        File file;
        block48: {
            file = new File(string, string2);
            if (this.db.on()) {
                this.db.println("Checking " + file);
            }
            if ((ctcBootstrapJar = cvu.parseBootstrapJarName(string2)) == null) {
                return new CtcCachedFile(file);
            }
            iNgrp = null;
            classLoaderEnum = ctcBootstrapJar.getClEnum();
            try {
                object3 = file.toURI().toURL();
                object2 = classLoaderEnum.isCore ? classLoaderEnum : ClassLoaderEnum.IF;
                iNgrp = cvu.getNgrp((URL)object3, (ClassLoaderEnum)((Object)object2));
            }
            catch (MalformedURLException malformedURLException) {
                CmDebug.printStackTrace(malformedURLException);
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                if (!this.db.on()) break block48;
                CmDebug.printStackTrace(unsupportedClassVersionError);
            }
        }
        if (iNgrp == null && classLoaderEnum.equals((Object)ClassLoaderEnum.SYSTEM)) {
            object3 = null;
            try {
                object2 = file.getCanonicalPath();
                object = new ClientFutureProofer((String)object2);
                object3 = new JarFile(file);
                Manifest manifest = ((JarFile)object3).getManifest();
                iNgrp = object.getNgrp(manifest, (String)object2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.db.on()) {
                    CmDebug.printStackTrace(classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (this.db.on()) {
                    CmDebug.printStackTrace(instantiationException);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.db.on()) {
                    CmDebug.printStackTrace(invocationTargetException);
                }
            }
            catch (IOException iOException) {
                if (this.db.on()) {
                    CmDebug.printStackTrace(iOException);
                }
            }
            catch (CoreException coreException) {
                if (this.db.on()) {
                    CmDebug.printStackTrace(coreException);
                }
            }
            finally {
                if (object3 != null) {
                    try {
                        ((ZipFile)object3).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        object3 = CtcCachedFile.State.INVALID;
        boolean bl = false;
        if (iNgrp == null || iNgrp.isEmpty()) {
            this.db.println("NGRP missing in the manifest:" + file);
        } else {
            object = iNgrp.getManifestVersionOrdinal();
            if (object == null) {
                this.db.println("Comparable(VO) missing in the manifest:" + file);
            } else if (ctcBootstrapJar.getVersion() == null) {
                ctcBootstrapJar.setVersion((Comparable)object);
                object3 = CtcCachedFile.State.VALID;
            } else if (object.compareTo(ctcBootstrapJar.getVersion()) == 0) {
                object3 = CtcCachedFile.State.VALID;
            }
            if (classLoaderEnum.isCore) {
                bl = true;
            }
        }
        object = new CtcCachedFile(file, (CtcCachedFile.State)((Object)object3), ctcBootstrapJar);
        if (bl) {
            this.ngrpMap.put(((CtcCachedFile)object).getPath(), iNgrp);
        }
        return object;
    }

    @Override
    public CtcCachedFile store(File file, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, boolean bl) throws IOException {
        return this.store(file, new CtcBootstrapJar(classLoaderEnum, nETypeEnum, comparable), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtcCachedFile store(File file, CtcBootstrapJar ctcBootstrapJar, boolean bl) throws IOException {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            ctcCachedFile = this.bjarMap.get(ctcBootstrapJar);
            if (ctcCachedFile == null) {
                File file2 = this.move(file, ctcBootstrapJar.toString(), bl);
                ctcCachedFile = new CtcCachedFile(file2, CtcCachedFile.State.VALID, ctcBootstrapJar);
                this.bjarMap.put(ctcBootstrapJar, ctcCachedFile);
                this.allCachedFiles.addFirst(ctcCachedFile);
                this.setChanged();
            } else {
                file.delete();
                if (this.db.on()) {
                    this.db.println("Store bootstrap jar already in cache. File deleted:" + file.toString());
                }
            }
        }
        if (this.db.on()) {
            this.db.println("Store bootstrap jar " + ctcBootstrapJar + " cached file=" + ctcCachedFile);
        }
        this.notifyObservers();
        return ctcCachedFile;
    }

    @Override
    public CtcCachedFile store(File file, CtcBootstrapJar ctcBootstrapJar) throws IOException {
        return this.store(file, ctcBootstrapJar, true);
    }

    @Override
    public CtcCachedFile store(File file, NameVersion nameVersion) throws IOException {
        return this.store(file, nameVersion.toString(), nameVersion.name);
    }

    @Override
    public CtcCachedFile store(File file, String string) throws IOException {
        return this.store(file, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtcCachedFile store(File file, String string, String string2) throws IOException {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            if (string2 != null && !string2.equals(string) && (ctcCachedFile = this.externalMap.get(string2)) != null) {
                this._delete(ctcCachedFile);
                if (file == null) {
                    file = ctcCachedFile.file;
                }
            }
            if (file == null) {
                return null;
            }
            ctcCachedFile = this.externalMap.get(string);
            if (ctcCachedFile == null) {
                File file2 = this.move(file, string, true);
                ctcCachedFile = new CtcCachedFile(file2);
                this.externalMap.put(string, ctcCachedFile);
                this.allCachedFiles.addFirst(ctcCachedFile);
                this.setChanged();
            } else {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                if (this.db.on()) {
                    this.db.println("Store external jar name already in cache. File deleted:" + file.toString());
                }
            }
        }
        if (this.db.on()) {
            this.db.println("Store external jar name " + string + " cached file=" + ctcCachedFile);
        }
        this.notifyObservers();
        return ctcCachedFile;
    }

    private File move(File file, String string, boolean bl) throws IOException {
        boolean bl2;
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        File file2 = new File(this.writeDir, string + ".jar");
        if (file.equals(file2)) {
            return file2;
        }
        if (file2.exists()) {
            file2.delete();
        }
        boolean bl3 = bl2 = bl && file.renameTo(file2);
        if (!bl2) {
            this.copy(file, file2, bl);
        }
        return file2;
    }

    /*
     * Exception decompiling
     */
    private void copy(File var1_1, File var2_2, boolean var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CtcCachedFile retrieve(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) {
        return this.retrieve(new CtcBootstrapJar(classLoaderEnum, nETypeEnum, comparable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtcCachedFile retrieve(CtcBootstrapJar ctcBootstrapJar) {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            ctcCachedFile = this.bjarMap.get(ctcBootstrapJar);
        }
        if (this.db.on()) {
            this.db.println("retrieve " + ctcBootstrapJar.toString() + "=" + ctcCachedFile);
        }
        return ctcCachedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtcCachedFile retrieve(String string) {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            ctcCachedFile = this.externalMap.get(string);
        }
        if (this.db.on()) {
            this.db.println("retrieve " + string + "=" + ctcCachedFile);
        }
        return ctcCachedFile;
    }

    @Override
    public CtcCachedFile retrieve(NameVersion nameVersion, boolean bl) {
        CtcCachedFile ctcCachedFile = this.retrieve(nameVersion.toString());
        if (ctcCachedFile == null && !bl) {
            ctcCachedFile = this.retrieve(nameVersion.name);
        }
        return ctcCachedFile;
    }

    @Override
    public CtcCachedFile retrieve(NameVersion nameVersion) {
        return this.retrieve(nameVersion, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtcCachedFile[] retrieve(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum) {
        LinkedList<CtcCachedFile> linkedList = new LinkedList<CtcCachedFile>();
        if (nETypeEnum == null) {
            nETypeEnum = NETypeEnum.NE_DONT_CARE;
        }
        Object object = this.maplock;
        synchronized (object) {
            for (CtcBootstrapJar ctcBootstrapJar : this.bjarMap.keySet()) {
                if (ctcBootstrapJar.getClEnum() != classLoaderEnum || ctcBootstrapJar.getNeType() != nETypeEnum) continue;
                linkedList.add(this.bjarMap.get(ctcBootstrapJar));
            }
        }
        return linkedList.toArray(new CtcCachedFile[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CtcCachedFile[] retrieveAll() {
        Object object = this.maplock;
        synchronized (object) {
            return this.allCachedFiles.toArray(new CtcCachedFile[0]);
        }
    }

    @Override
    public String[] getCacheDirList() {
        return this.originalCacheDirList;
    }

    @Override
    public boolean delete(CtcCachedFile ctcCachedFile) {
        return this.delete(ctcCachedFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(CtcCachedFile ctcCachedFile, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        Object object = this.maplock;
        synchronized (object) {
            bl3 = this._delete(ctcCachedFile);
        }
        System.gc();
        boolean bl4 = bl2 = !ctcCachedFile.file.exists() || ctcCachedFile.file.delete();
        if (this.db.on()) {
            this.db.println("Del " + ctcCachedFile.file + " res=" + bl2);
        }
        if (bl3) {
            this.setChanged();
            if (bl) {
                this.notifyObservers();
            }
        }
        return bl2;
    }

    private boolean _delete(CtcCachedFile ctcCachedFile) {
        boolean bl = false;
        if (ctcCachedFile.state == CtcCachedFile.State.VALID) {
            if (ctcCachedFile.bootstrapJar != null) {
                if (this.db.on()) {
                    this.db.println("Deleting bootstrap jar: " + ctcCachedFile.bootstrapJar);
                }
                this.bjarMap.remove(ctcCachedFile.bootstrapJar);
            }
        } else if (ctcCachedFile.state == CtcCachedFile.State.EXTERNAL) {
            String string = ctcCachedFile.file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            if (this.db.on()) {
                this.db.println("Deleting external jar: " + string);
            }
            this.externalMap.remove(string);
        } else {
            this.db.println("Deleting invalid bootstrap jar: " + ctcCachedFile.bootstrapJar + " ST=" + (Object)((Object)ctcCachedFile.state));
        }
        bl = this.allCachedFiles.remove(ctcCachedFile);
        return bl;
    }

    @Override
    public boolean deleteCache() {
        if (this.db.on()) {
            this.db.println("Deleting cache");
        }
        File file = new File(this.writeDir);
        LinkedList<CtcCachedFile> linkedList = new LinkedList<CtcCachedFile>();
        for (CtcCachedFile object2 : this.allCachedFiles) {
            if (!file.equals(object2.file.getParentFile())) break;
            linkedList.add(object2);
        }
        boolean bl = true;
        for (CtcCachedFile ctcCachedFile : linkedList) {
            if (this.db.on()) {
                this.db.println("Deleting " + ctcCachedFile.getPath());
            }
            bl &= this.delete(ctcCachedFile, false);
        }
        this.notifyObservers();
        if (!bl) {
            this.db.println("Cache cleanup was NOT successful");
        }
        File file2 = new File(this.writeDir, CLEAN_ME_FILE);
        boolean bl2 = file2.exists();
        if (CoreConstants.isDownloadingPermitted) {
            if (!bl) {
                if (!bl2) {
                    try {
                        file2.createNewFile();
                        this.db.println("Requested cache cleanup was not successful");
                        this.db.println("Will attempt remaining cache cleanup at next CTC launcher startup");
                    }
                    catch (IOException iOException) {
                        this.db.println("Requested cache cleanup on restart failed");
                    }
                }
            } else if (bl2) {
                file2.delete();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INgrp getNgrp(CtcCachedFile ctcCachedFile) {
        INgrp iNgrp = null;
        Object object = this.maplock;
        synchronized (object) {
            iNgrp = this.ngrpMap.get(ctcCachedFile.getPath());
        }
        return iNgrp;
    }

    public static CacheManager instance() {
        return instance;
    }

    public class CmDebug
    extends KDebug
    implements IDebugDiag {
        public CmDebug() {
            super("CacheManager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showAll() {
            this.println("--- Global List:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (CtcCachedFile ctcCachedFile : CacheManager.this.allCachedFiles) {
                    this.println("   " + ctcCachedFile.toString());
                }
                this.println("--- Write directory:" + CacheManager.this.writeDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showExternal() {
            this.println("--- External Map:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (CtcCachedFile ctcCachedFile : CacheManager.this.externalMap.values()) {
                    this.println("   " + ctcCachedFile.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showBjar() {
            this.println("--- Bootstrap Map:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (CtcCachedFile ctcCachedFile : CacheManager.this.bjarMap.values()) {
                    this.println("   " + ctcCachedFile.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showNgrp() {
            this.println("--- NGRP Map:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (String string : CacheManager.this.ngrpMap.keySet()) {
                    INgrp iNgrp = (INgrp)CacheManager.this.ngrpMap.get(string);
                    this.println("   " + string + " -> " + iNgrp);
                }
            }
        }

        @Override
        public final void dumpDiag() {
            this.showAll();
            this.showExternal();
            this.showBjar();
            this.showNgrp();
        }
    }

    private static class JarFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String string) {
            String string2 = string.toUpperCase(Locale.ENGLISH);
            return string2.endsWith(".JAR") || string2.startsWith("CACHE.");
        }

        private JarFileFilter() {
        }
    }
}

