/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class LazyFileOutputStream
extends OutputStream {
    private File outputFile;
    private FileOutputStream actualStream;

    public LazyFileOutputStream(File file) {
        this.outputFile = file;
    }

    public LazyFileOutputStream(FileDescriptor fileDescriptor) {
        throw new RuntimeException("not supported!");
    }

    private void lazyInit() throws IOException {
        if (this.actualStream == null) {
            this.actualStream = new FileOutputStream(this.outputFile);
        }
    }

    public FileChannel getChannel() throws IOException {
        this.lazyInit();
        return this.actualStream.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        this.lazyInit();
        return this.actualStream.getFD();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.lazyInit();
        this.actualStream.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.lazyInit();
        this.actualStream.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.lazyInit();
        this.actualStream.write(n);
    }

    @Override
    public void close() throws IOException {
        if (this.actualStream != null) {
            this.actualStream.close();
        }
    }
}

