/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractTransferer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class StreamCompressor
extends AbstractTransferer {
    private final boolean gzipMode;
    protected File file;
    protected InputStream is;
    protected OutputStream gzipOs;
    protected static KDebug db = new KDebug("StreamCompressor");

    public StreamCompressor(File file, boolean bl) {
        super(db);
        this.file = file;
        this.gzipMode = bl;
    }

    @Override
    public InputStream preTransferInput(Object object) throws IOException {
        this.checkPreTransferInputState();
        this.is = object instanceof InputStream ? (InputStream)object : new FileInputStream(this.file);
        return this.is;
    }

    @Override
    public OutputStream preTransferOutput(Object object) throws IOException {
        this.checkPreTransferOutputState();
        if (!(object instanceof File)) {
            throw new IllegalArgumentException("cannot handle arg: " + (object == null ? "null" : object.getClass().getName()));
        }
        File file = (File)object;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.gzipOs = this.getOutputStream(fileOutputStream);
        return this.gzipOs;
    }

    protected OutputStream getOutputStream(OutputStream outputStream) throws IOException {
        return this.gzipMode ? new GZIPOutputStream(outputStream) : outputStream;
    }

    @Override
    public void startTransfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.checkStartTransferState();
        if (db.on()) {
            db.println("GZIP compressing..." + inputStream.getClass().getName() + " -> " + this.gzipOs.getClass().getName());
        }
        this.streamCopy(inputStream, this.gzipOs);
    }

    @Override
    public void endTransfer(Object object) throws IOException {
        this.checkEndTransferState();
        this.is.close();
        this.gzipOs.close();
    }
}

