/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import com.cisco.ctc.core.CacheLocator;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.CtcBootstrapJar;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.NameVersion;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.cache.CtcCachedFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public final class DefaultCtcReqs {
    private static final Comparable CTC_CONQUEROR = DefaultCtcReqs.getCtcVersion("0800");
    private static final Comparable CTC_MARINER = DefaultCtcReqs.getCtcVersion("0700");
    private static final Comparable CTC_WARRIOR = DefaultCtcReqs.getCtcVersion("0600");
    private static final Comparable CTC_CHIEF2 = DefaultCtcReqs.getCtcVersion("0470");
    private static final Comparable CTC_PATRIOT = DefaultCtcReqs.getCtcVersion("0460");
    private static final Comparable CTC_HAWK = DefaultCtcReqs.getCtcVersion("0400");
    private static final Comparable CTC_MMX = DefaultCtcReqs.getCtcVersion("0330");
    public static final JreVersion JRE_1_2_2 = new JreVersion("1.2.2");
    public static final JreVersion JRE_1_3 = new JreVersion("1.3");
    public static final JreVersion JRE_1_3_1 = new JreVersion("1.3.1");
    public static final JreVersion JRE_1_4 = new JreVersion("1.4");
    public static final JreVersion JRE_1_4_2 = new JreVersion("1.4.2");
    public static final JreReqs JRE_1_2_ONLY = new JreReqs(JRE_1_2_2, JRE_1_3, JRE_1_2_2);
    public static final JreReqs JRE_1_3_BRIDGE = new JreReqs(JRE_1_2_2, JRE_1_4, JRE_1_3_1);
    public static final JreReqs JRE_1_3_ONLY = new JreReqs(JRE_1_3, JRE_1_4, JRE_1_3_1);
    public static final JreReqs JRE_1_4_BRIDGE = new JreReqs(JRE_1_3_1, JreVersion.JRE_5, JRE_1_4_2);
    public static final JreReqs JRE_1_4_ONLY = new JreReqs(JRE_1_4, JreVersion.JRE_5, JRE_1_4_2);
    public static final JreReqs JRE_5_BRIDGE = new JreReqs(JRE_1_4, JreVersion.JRE_6, JRE_1_4);
    private static final NameVersion VBJORB_4_5 = new NameVersion("vbjorb", "0405");
    private static final NameVersion JACORB_1_4_1 = new NameVersion("ORB", "0141");
    private static final NameVersion JACORB_2_1_3 = new NameVersion("ORB", "0213");
    private static final NameVersion JVIEWS_6_5 = new NameVersion("jviews", "6_5");
    private static final NameVersion JHALL_2_0_0_1 = new NameVersion("jhall", "2_0_0_1");
    private static final NameVersion[] JARSET_VASCO_0300 = new NameVersion[]{VBJORB_4_5};
    private static final NameVersion[] JARSET_PATRIOT_0460 = new NameVersion[]{JACORB_1_4_1, JHALL_2_0_0_1};
    private static final NameVersion[] JARSET_WARRIOR_0600 = new NameVersion[]{JACORB_2_1_3, JHALL_2_0_0_1};
    private static final NameVersion[] JARSET_MARINER_0700 = new NameVersion[]{JACORB_2_1_3, JHALL_2_0_0_1, JVIEWS_6_5};
    private static final ClassLoaderEnum[] CORE_CLE = new ClassLoaderEnum[]{ClassLoaderEnum.IF, ClassLoaderEnum.NET};
    private static final ClassLoaderEnum[] CORE_AND_SYSTEM_CLE = new ClassLoaderEnum[]{ClassLoaderEnum.SYSTEM, ClassLoaderEnum.IF, ClassLoaderEnum.NET};

    private static final Comparable getCtcVersion(String string) {
        return CoreVersionUtil.instance().createVersionOrdinal(ClassLoaderEnum.SYSTEM, (Comparable)((Object)string));
    }

    public static final JreReqs getJreReqs(Comparable comparable) {
        if (comparable.compareTo(CTC_MARINER) >= 0) {
            return JRE_5_BRIDGE;
        }
        if (comparable.compareTo(CTC_CHIEF2) >= 0) {
            return JRE_1_4_ONLY;
        }
        if (comparable.compareTo(CTC_PATRIOT) >= 0) {
            return JRE_1_4_BRIDGE;
        }
        if (comparable.compareTo(CTC_HAWK) >= 0) {
            return JRE_1_3_ONLY;
        }
        if (comparable.compareTo(CTC_MMX) >= 0) {
            return JRE_1_3_BRIDGE;
        }
        return JRE_1_2_ONLY;
    }

    private static final NameVersion[] getExtJarSet(Comparable comparable) {
        if (comparable.compareTo(CTC_MARINER) >= 0) {
            return JARSET_MARINER_0700;
        }
        if (comparable.compareTo(CTC_WARRIOR) >= 0) {
            return JARSET_WARRIOR_0600;
        }
        if (comparable.compareTo(CTC_PATRIOT) >= 0) {
            return JARSET_PATRIOT_0460;
        }
        return JARSET_VASCO_0300;
    }

    public static boolean supports(Comparable comparable) {
        return comparable.compareTo(CTC_MMX) >= 0;
    }

    public static boolean isComplete(Comparable comparable) {
        CacheManager cacheManager = CacheManager.instance();
        String string = null;
        if (cacheManager.retrieve(NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.IF, comparable) == null) {
            string = ClassLoaderEnum.IF.toString();
        } else if (cacheManager.retrieve(NETypeEnum.NE_DONT_CARE, ClassLoaderEnum.NET, comparable) == null) {
            string = ClassLoaderEnum.NET.toString();
        } else {
            NameVersion[] nameVersionArray;
            for (NameVersion nameVersion : nameVersionArray = DefaultCtcReqs.getExtJarSet(comparable)) {
                if (cacheManager.retrieve(nameVersion) != null) continue;
                string = nameVersion.toString();
                break;
            }
        }
        return string == null;
    }

    public static void makeComplete(Comparable comparable, CacheLocator cacheLocator) throws IOException, ClassLoaderException {
        NameVersion[] nameVersionArray;
        cacheLocator.locateBootstrapJarInCache(ClassLoaderEnum.IF);
        cacheLocator.locateBootstrapJarInCache(ClassLoaderEnum.NET);
        for (NameVersion nameVersion : nameVersionArray = DefaultCtcReqs.getExtJarSet(comparable)) {
            cacheLocator.locateNonBootstrapJarToCache(nameVersion);
        }
    }

    public static boolean isOrbInTheClassPath(Comparable comparable) {
        return comparable.compareTo(CTC_CHIEF2) < 0;
    }

    public static final ArrayList<String> getArgs(ArrayList<String> arrayList, ArrayList<String> arrayList2, Comparable comparable) throws FileNotFoundException {
        NameVersion[] nameVersionArray = DefaultCtcReqs.getExtJarSet(comparable);
        NameVersion nameVersion = nameVersionArray[0];
        String string = DefaultCtcReqs.getPath(nameVersion);
        if (!DefaultCtcReqs.isOrbInTheClassPath(comparable)) {
            arrayList.add("-Dctc.launcher.ctc-jar-orb=" + string);
        } else if (comparable.compareTo(CTC_MMX) >= 0) {
            arrayList2.add(string);
            if (comparable.compareTo(CTC_PATRIOT) >= 0) {
                arrayList2.add(DefaultCtcReqs.getPath(JHALL_2_0_0_1));
            }
            arrayList.add("-Dctc.orb.jarfile=" + nameVersion.getName() + ".jar");
        } else {
            arrayList.add("-Xbootclasspath");
            arrayList.add(string);
        }
        String string2 = DefaultCtcReqs.getPath(ClassLoaderEnum.IF, comparable);
        arrayList.add("-Dctc.launcher.ctc-jar-if=" + string2);
        string2 = DefaultCtcReqs.getPath(ClassLoaderEnum.NET, comparable);
        arrayList.add("-Dctc.launcher.ctc-jar-net=" + string2);
        return arrayList;
    }

    private static String getPath(NameVersion nameVersion) throws FileNotFoundException {
        CtcCachedFile ctcCachedFile = CacheManager.instance().retrieve(nameVersion);
        if (ctcCachedFile == null) {
            throw new FileNotFoundException(nameVersion.toString());
        }
        return ctcCachedFile.getPath();
    }

    private static String getPath(ClassLoaderEnum classLoaderEnum, Comparable comparable) throws FileNotFoundException {
        CtcBootstrapJar ctcBootstrapJar = new CtcBootstrapJar(classLoaderEnum, NETypeEnum.NE_DONT_CARE, comparable);
        CtcCachedFile ctcCachedFile = CacheManager.instance().retrieve(ctcBootstrapJar);
        if (ctcCachedFile == null) {
            throw new FileNotFoundException(ctcBootstrapJar.toString());
        }
        return ctcCachedFile.getPath();
    }
}

