/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class CUESSplashWindow
extends JComponent {
    public static Color GREEN_COLOR = Color.decode("#336666");
    public static Color DARK_GREEN_COLOR = Color.decode("#003333");
    public static Color LIGHT_GREEN_COLOR = Color.decode("#699999");
    public static Color LIGHT_GREY_COLOR = Color.decode("#999999");
    protected static String CISCO_IMG_PATH = "/images/cisco-small.gif";
    protected static String PROD_IMG_PATH = "/images/mba02466_splash.jpg";
    protected static String PROD_IMG_PATH_LOGIN = "/images/ctc-gg.jpg";
    protected static String PROD_IMG_PATH_LAUNCHER = "/images/startctc-gg.jpg";
    public static Dimension WINDOW_DIM = new Dimension(398, 330);
    public static Dimension PROD_NAME_DIM = new Dimension(220, 152);
    public static Dimension PHOTO_AREA_DIM = new Dimension(180, 152);
    public static Point PRODUCT_BANNER_TOP = new Point(0, 80);
    protected Image ciscoLogoImg = null;
    protected Image prodImg = null;
    protected String title = null;
    protected Thread statusThread = null;
    protected String statusMsg = null;
    protected JLabel statusBar = null;
    protected String[] prodNames = null;
    protected String verNum = null;
    protected String copyrightYear = null;

    public CUESSplashWindow(String string, String string2, String string3, String string4) {
        this.title = string;
        this.prodNames = this.formatProductName(string2);
        this.verNum = string3 != null ? string3 : "";
        this.copyrightYear = this.formatCopyrightYear(string4);
        this.setLayout(null);
        this.setBorder(this.createDefaultBorder());
        try {
            URL uRL = CUESSplashWindow.class.getResource(CISCO_IMG_PATH);
            this.ciscoLogoImg = Toolkit.getDefaultToolkit().getImage(uRL);
            URL uRL2 = string.compareTo("CTC Launcher") == 0 ? CUESSplashWindow.class.getResource(PROD_IMG_PATH_LAUNCHER) : CUESSplashWindow.class.getResource(PROD_IMG_PATH_LOGIN);
            this.prodImg = Toolkit.getDefaultToolkit().getImage(uRL2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    protected void init() {
        this.add(this.createLogoImagePane());
        this.add(this.createProductImagePane());
        this.statusBar = this.createStatusBar();
        this.add(this.statusBar);
        this.add(this.createCopyrightPane(this.title));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Rectangle rectangle = new Rectangle(0, 70, this.getTopBannerDimension().width, this.getTopBannerDimension().height);
        graphics2D.setColor(DARK_GREEN_COLOR);
        graphics2D.fill(new Rectangle(0, 70, this.getTopBannerDimension().width, this.getTopBannerDimension().height));
        for (n = 0; n < 6; ++n) {
            rectangle = new Rectangle(this.getProductNameDimension().width + n, 70 - n, this.getPreferredSize().width - this.getProductNameArea().width - 2 - n, 1);
            graphics2D.fill(rectangle);
        }
        graphics2D.setColor(GREEN_COLOR);
        graphics2D.fill(this.getProductNameArea());
        graphics2D.setColor(DARK_GREEN_COLOR);
        n = this.getProductNameArea().y + this.getProductNameArea().height;
        if (n == 0) {
            n = this.getPhotoDimension().height;
        }
        Rectangle rectangle2 = new Rectangle(0, n, this.getBottomBannerDimension().width, this.getBottomBannerDimension().height);
        graphics2D.fill(rectangle2);
        graphics2D.setColor(LIGHT_GREEN_COLOR);
        Font font = graphics2D.getFont();
        graphics2D.setFont(new Font("Arial", 1, 19));
        graphics2D.setColor(Color.white);
        int n2 = 130;
        for (int i = 0; i < this.prodNames.length; ++i) {
            graphics2D.drawString(this.prodNames[i], 18, n2);
            n2 += 25;
        }
        graphics2D.setFont(new Font("Arial", 1, 12));
        graphics2D.drawString("Version " + this.verNum, 21, this.getBottomBannerArea().y - 20);
        graphics2D.setFont(font);
    }

    protected JLabel createLogoImagePane() {
        JLabel jLabel = null;
        try {
            jLabel = new JLabel(new ImageIcon(this.ciscoLogoImg));
        }
        catch (Exception exception) {
            jLabel = new JLabel();
        }
        jLabel.setSize(92, 66);
        jLabel.setLocation(3, 3);
        return jLabel;
    }

    protected JLabel createProductImagePane() {
        JLabel jLabel = null;
        try {
            jLabel = new JLabel(new ImageIcon(this.prodImg));
        }
        catch (Exception exception) {
            jLabel = new JLabel();
        }
        jLabel.setSize(this.getPhotoDimension());
        jLabel.setLocation(this.getProductNameArea().width, this.getProductNameArea().y);
        return jLabel;
    }

    protected JLabel createStatusBar() {
        JLabel jLabel = new JLabel();
        jLabel.setBackground(LIGHT_GREEN_COLOR);
        jLabel.setLocation(this.getBottomBannerArea().width, this.getBottomBannerArea().y);
        jLabel.setSize(this.getStatusBarDimension());
        jLabel.setOpaque(true);
        return jLabel;
    }

    protected JScrollPane createCopyrightPane(String string) {
        JComponent jComponent = this.createCopyrightContainer(string);
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(null);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setLocation(10, this.getBottomBannerArea().y + this.getBottomBannerArea().height);
        jScrollPane.setSize(this.getPreferredSize().width - 16, 60);
        return jScrollPane;
    }

    protected JComponent createCopyrightContainer(String string) {
        String string2 = this.getCopyrightText();
        JTextArea jTextArea = new JTextArea(string2, 3, 150);
        jTextArea.setFont(new Font("Arial", 0, 10));
        jTextArea.setForeground(LIGHT_GREY_COLOR);
        jTextArea.setBackground(Color.white);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        return jTextArea;
    }

    protected String getCopyrightText() {
        String string = this.copyrightYear + "\n" + "Cisco, Cisco Systems and Cisco Systems logo are registered trademarks " + "of Cisco Systems, Inc.\nand/or its affiliates in the U.S and certain other countries";
        return string;
    }

    protected String formatCopyrightYear(String string) {
        return "\nCopyright \u00a9 " + string + " Cisco Systems, Inc.";
    }

    protected String[] formatProductName(String string) {
        String string2;
        String[] stringArray = null;
        String string3 = string2 = string != null ? string : "";
        if (string2.length() > 15) {
            stringArray = new String[2];
            int n = string2.indexOf(" ", 15);
            stringArray[0] = string2.substring(0, n).trim();
            stringArray[1] = string2.substring(n, string2.length()).trim();
        } else {
            stringArray = new String[]{string2};
        }
        return stringArray;
    }

    protected Border createDefaultBorder() {
        return BorderFactory.createLineBorder(Color.black, 2);
    }

    protected void showWindow(String string, String string2) {
        new CUESSplashWindowContainer();
    }

    @Override
    public Dimension getPreferredSize() {
        return WINDOW_DIM;
    }

    public Point getTopBannerPoint() {
        return PRODUCT_BANNER_TOP;
    }

    public Dimension getPhotoDimension() {
        return PHOTO_AREA_DIM;
    }

    public Dimension getTopBannerDimension() {
        return new Dimension(this.getPreferredSize().width - 2, 10);
    }

    public Dimension getBottomBannerDimension() {
        return new Dimension(this.getProductNameDimension().width, 26);
    }

    public Rectangle getBottomBannerArea() {
        return new Rectangle(0, this.getProductNameArea().y + this.getProductNameArea().height, this.getBottomBannerDimension().width, this.getBottomBannerDimension().height);
    }

    public Dimension getProductNameDimension() {
        return PROD_NAME_DIM;
    }

    public Rectangle getProductNameArea() {
        return new Rectangle(PRODUCT_BANNER_TOP, this.getProductNameDimension());
    }

    public Dimension getStatusBarDimension() {
        return new Dimension(this.getPreferredSize().width - this.getProductNameDimension().width - 2, 26);
    }

    public void startStatus(String string) {
        final String string2 = string;
        String string3 = this.statusMsg = string != null ? string2 : "";
        if (this.statusThread == null) {
            this.statusThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        CUESSplashWindow.this.statusMsg = CUESSplashWindow.this.statusMsg + " .";
                        CUESSplashWindow.this.statusBar.setText(CUESSplashWindow.this.statusMsg);
                        if (CUESSplashWindow.this.statusMsg.length() <= 90) continue;
                        CUESSplashWindow.this.statusMsg = string2;
                    }
                }
            });
            this.statusThread.start();
            this.statusThread = null;
        }
    }

    public void setCenter(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getPreferredSize();
        int n = (dimension.width - dimension2.width) / 2;
        dimension.height = dimension2.height;
        int n2 = dimension.height / 2;
        window.setLocation(n, n2);
    }

    protected class CUESSplashWindowContainer
    extends JWindow {
        public CUESSplashWindowContainer() {
            this.getContentPane().setBackground(Color.white);
            this.add(CUESSplashWindow.this);
            this.setSize(this.getPreferredSize());
            this.pack();
        }
    }
}

