/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.KDebug;
import com.cisco.sot.Base64;
import com.cisco.sot.NioBufferHelper;
import com.cisco.sot.Tl1TunnelAddr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class Tl1Buffer {
    private static KDebug dbg = new KDebug("Tl1Buffer");
    protected static final int TL1_BUFFER_SIZE = 2000;
    protected static final int TL1_LV_HDR_LEN = 4;
    private static final int TL1_REPLY_HDR_LEN = 4;
    private SocketChannel channel;
    protected ByteBuffer bbw;
    protected ByteBuffer bbr;
    protected boolean bbrLenUnknown;
    protected boolean bbrNativeTl1Type;
    protected Tl1TunnelAddr addr;
    private boolean loaded = false;
    protected int tl1OutHdrLen;
    protected int tl1InHdrLen;
    protected int tl1InTrailerLen;

    Tl1Buffer(SocketChannel socketChannel, Tl1TunnelAddr tl1TunnelAddr) {
        this.channel = socketChannel;
        this.addr = tl1TunnelAddr;
        this.bbw = ByteBuffer.allocateDirect(2000);
        this.bbr = ByteBuffer.allocateDirect(2000);
        this.initHeaders();
        this.bbr.clear();
        this.bbr.limit(this.tl1InHdrLen);
    }

    protected void initHeaders() {
        String string = "SOTL1:" + this.addr.pneTid + "::1:::DATA=";
        this.bbw.clear();
        if (this.addr.isLV()) {
            this.bbw.put((byte)3);
            this.bbw.put((byte)0);
            this.bbw.putShort((short)0);
            this.tl1InHdrLen = 8;
            this.tl1InTrailerLen = 1;
        } else if (this.addr.isRaw()) {
            this.tl1InHdrLen = 4;
            this.tl1InTrailerLen = 1;
        } else {
            this.tl1InHdrLen = 4;
            this.tl1InTrailerLen = 3;
        }
        this.bbw.put(string.getBytes());
        this.tl1OutHdrLen = this.bbw.position();
    }

    protected void adjustTl1OutHdr(int n) {
        if (this.addr.isLV()) {
            this.bbw.put(2, (byte)(n >> 8 & 0xFF));
            this.bbw.put(3, (byte)(n & 0xFF));
        } else if (this.addr.isTelnet()) {
            this.bbw.put((byte)13);
            this.bbw.put((byte)10);
        }
    }

    protected int getTl1InLength() throws IOException {
        int n;
        if (this.addr.isLV()) {
            if (this.bbr.get(0) != 3 || this.bbr.get(1) != 0) {
                NioBufferHelper.dump(this.bbr, dbg, 64);
                throw new IOException("The received LV header is invalid.");
            }
            n = ((this.bbr.get(2) & 0xFF) << 8) + (this.bbr.get(3) & 0xFF);
            if (n == 4) {
                return 0;
            }
            byte by = this.bbr.get(4);
            this.bbrNativeTl1Type = by < 48 || by > 57;
        } else {
            n = 0;
            for (int i = 0; i < 4; ++i) {
                byte by = this.bbr.get(i);
                if (by < 48 || by > 57) {
                    this.bbrNativeTl1Type = true;
                    return -1;
                }
                n = n * 10 + (by - 48);
            }
            this.bbrNativeTl1Type = false;
        }
        if (n > 2000) {
            NioBufferHelper.dump(this.bbr, dbg, 64);
            throw new IOException("The TL1 reply header reported that the length (" + n + ") was too long.");
        }
        if (n < this.tl1InHdrLen + this.tl1InTrailerLen) {
            throw new IOException("The TL1 reply header reported that the length (" + n + ") was too short.");
        }
        return n;
    }

    public boolean readInBuffer(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        while (this.bbr.position() < this.tl1InHdrLen) {
            n2 = this.channel.read(this.bbr);
            if (n2 == 0) {
                byteBuffer.clear().flip();
                return true;
            }
            if (n2 < 0) {
                throw new IOException("The socket is closed.");
            }
            if (this.bbr.hasRemaining()) continue;
            n = this.getTl1InLength();
            if (n == 0) {
                this.bbr.position(4);
                this.bbr.compact();
                this.bbr.limit(this.tl1InHdrLen);
                byteBuffer.clear().flip();
                return true;
            }
            if (n > 0) {
                this.bbr.limit(n);
                this.bbrLenUnknown = false;
                break;
            }
            this.bbrLenUnknown = true;
            break;
        }
        if (this.bbrLenUnknown) {
            do {
                n2 = this.bbr.position();
                this.bbr.limit(n2 + 1);
                n = this.channel.read(this.bbr);
                if (n == 0) {
                    byteBuffer.clear().flip();
                    return false;
                }
                if (n >= 0) continue;
                throw new IOException("The socket is closed.");
            } while (this.bbr.get(n2) != 59);
        } else {
            while (this.bbr.hasRemaining()) {
                n2 = this.channel.read(this.bbr);
                if (n2 == 0) {
                    byteBuffer.clear().flip();
                    return true;
                }
                if (n2 >= 0) continue;
                throw new IOException("The socket is closed.");
            }
        }
        if (dbg.on()) {
            dbg.println("READ:");
            NioBufferHelper.dump(this.bbr, dbg, 128);
        }
        byteBuffer.clear();
        if (this.bbrNativeTl1Type) {
            if (this.addr.isLV()) {
                this.bbr.position(this.tl1InHdrLen);
            } else {
                this.bbr.position(0);
            }
            byteBuffer.put(this.bbr);
            byteBuffer.flip();
        } else {
            this.bbr.position(this.tl1InHdrLen);
            this.bbr.limit(this.bbr.limit() - this.tl1InTrailerLen);
            if (this.addr.isDataBase64()) {
                try {
                    Base64.decode(this.bbr, byteBuffer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IOException("The Base 64 decoding failed.");
                }
            } else {
                byteBuffer.put(this.bbr);
            }
            byteBuffer.flip();
            if (dbg.isFinestEnabled()) {
                dbg.println("SSH MUX IN:");
                NioBufferHelper.dump(byteBuffer, dbg, 128);
            }
        }
        this.bbr.clear();
        this.bbr.limit(this.tl1InHdrLen);
        return !this.bbrNativeTl1Type;
    }

    public void loadOutBuffer(ByteBuffer byteBuffer) throws IOException {
        this.loadOutBuffer(byteBuffer, this.addr.isDataBase64());
    }

    public void loadOutBuffer(ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (this.loaded) {
            throw new IOException("The TL1 buffer is already loaded.");
        }
        this.bbw.position(this.tl1OutHdrLen);
        this.bbw.limit(this.bbw.capacity());
        if (dbg.isFinestEnabled()) {
            dbg.println("SSH MUX OUT:");
            NioBufferHelper.dump(byteBuffer, dbg, 128);
        }
        if (bl) {
            Base64.encode(byteBuffer, this.bbw);
        } else {
            this.bbw.put(byteBuffer);
        }
        this.bbw.put((byte)59);
        this.adjustTl1OutHdr(this.bbw.position());
        this.bbw.flip();
        if (dbg.on()) {
            dbg.println("SEND:");
            NioBufferHelper.dump(this.bbw, dbg, 128);
        }
        this.loaded = true;
    }

    public void loadOutBuffer(String string) throws IOException {
        if (this.loaded) {
            throw new IOException("The TL1 buffer is already loaded.");
        }
        this.bbw.position(this.tl1OutHdrLen);
        this.bbw.limit(this.bbw.capacity());
        if (this.addr.isLV()) {
            int n = string.length() + 4;
            this.bbw.put((byte)3);
            this.bbw.put((byte)0);
            this.bbw.put((byte)(n >> 8 & 0xFF));
            this.bbw.put((byte)(n & 0xFF));
        }
        this.bbw.put(string.getBytes());
        this.bbw.flip();
        this.bbw.position(this.tl1OutHdrLen);
        if (dbg.on()) {
            dbg.println("SEND:" + string);
        }
        this.loaded = true;
    }

    public boolean isOutBufferLoaded() {
        return this.loaded;
    }

    public boolean resendOutBuffer() throws IOException {
        if (this.loaded) {
            while (this.bbw.hasRemaining()) {
                if (this.channel.write(this.bbw) != 0) continue;
                return false;
            }
            this.loaded = false;
        }
        return true;
    }

    public static void setTrace(boolean bl) {
        dbg.set(bl);
    }
}

