/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.INodeCache;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeKeyComparator;
import cerent.util.ConcurrentReaderMap;
import cerent.util.GlobalCollection;
import cerent.util.KDebug;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public class NodeCache
implements INodeCache {
    private ConcurrentReaderMap map = new ConcurrentReaderMap();
    private static final String NodeCacheName = "NodeCache";
    protected static Debug db = new Debug("NodeCache");
    protected static final NullPointerException CacheCleanupException = new NullPointerException();

    public static INodeCache getInstance() {
        return (INodeCache)GlobalCollection.get(NodeCacheName);
    }

    protected NodeCache(Comparator comparator) {
    }

    @Override
    public INodeModel add(Object object, INodeModel iNodeModel) {
        INodeModel iNodeModel2;
        block5: {
            if (db.on()) {
                db.println("about to add: '" + object + "'(" + object.getClass().getName() + ")  for node: " + iNodeModel);
            } else if (iNodeModel == null) {
                db.println("attempt to add null INodeModel for key: " + object);
                Debug.printStackTrace((Throwable)new NullPointerException());
                return null;
            }
            iNodeModel2 = null;
            try {
                iNodeModel2 = NodeCache.getINM(this.map.put(object, new WeakReference<INodeModel>(iNodeModel)));
            }
            catch (NullPointerException nullPointerException) {
                if (nullPointerException == CacheCleanupException) break block5;
                throw nullPointerException;
            }
        }
        return iNodeModel2;
    }

    @Override
    public INodeModel remove(Object object) {
        INodeModel iNodeModel;
        block3: {
            if (db.on()) {
                db.println("about to remove: " + object);
            }
            iNodeModel = null;
            try {
                iNodeModel = NodeCache.getINM(this.map.remove(object));
            }
            catch (NullPointerException nullPointerException) {
                if (nullPointerException == CacheCleanupException) break block3;
                throw nullPointerException;
            }
        }
        return iNodeModel;
    }

    @Override
    public INodeModel getINodeModel(Object object) {
        INodeModel iNodeModel = null;
        if (db.isFinerEnabled()) {
            db.finer("about to lookup node: " + object);
        }
        try {
            iNodeModel = NodeCache.getINM(this.map.get(object));
        }
        catch (NullPointerException nullPointerException) {
            if (nullPointerException == CacheCleanupException) {
                if (db.isFinerEnabled()) {
                    db.finer("removed old INM entry: " + object);
                }
                this.map.remove(object);
            }
            throw nullPointerException;
        }
        return iNodeModel;
    }

    protected static INodeModel getINM(Object object, boolean bl) {
        INodeModel iNodeModel = null;
        if (object instanceof WeakReference) {
            WeakReference weakReference = (WeakReference)object;
            INodeModel iNodeModel2 = iNodeModel = weakReference == null ? null : (INodeModel)weakReference.get();
            if (bl && weakReference != null && iNodeModel == null) {
                throw CacheCleanupException;
            }
        }
        if (db.isFinestEnabled()) {
            db.finest("found INM: " + iNodeModel);
        }
        return iNodeModel;
    }

    protected static INodeModel getINM(Object object) {
        return NodeCache.getINM(object, true);
    }

    static {
        GlobalCollection.put(NodeCacheName, new NodeCache(NodeKeyComparator.getInstance()));
    }

    public static class Debug
    extends KDebug {
        public Debug(String string) {
            super(string);
        }

        public final void dump() {
            NodeCache nodeCache = (NodeCache)NodeCache.getInstance();
            ConcurrentReaderMap concurrentReaderMap = nodeCache.map;
            HashSet hashSet = new HashSet(concurrentReaderMap.keySet());
            Iterator iterator = hashSet.iterator();
            this.println("NodeCache size: " + concurrentReaderMap.size());
            int n = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                INodeModel iNodeModel = NodeCache.getINM(concurrentReaderMap.get(e), false);
                String string = iNodeModel == null ? "null" : iNodeModel.getClass().getName() + "/" + iNodeModel.getIndex();
                this.println("  " + n + ": " + e + " - " + string);
                ++n;
            }
        }
    }
}

