/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.util.ComparisonUtil;

public class NodeKey
implements Comparable {
    public static final int WILD_NODE_ID_0 = 0;
    public static final int WILD_NODE_ID_1 = -1;
    private int nodeId;
    private int ipAddr;
    private Object typeObj;

    public NodeKey(int n, int n2, Object object) {
        this.nodeId = n;
        this.ipAddr = n2;
        this.typeObj = object;
    }

    public NodeKey(int n, Object object) {
        this(0, n, object);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getIpAddr() {
        return this.ipAddr;
    }

    public Object getTypeObj() {
        return this.typeObj;
    }

    protected static boolean isWildcard(int n) {
        return n == 0 || n == -1;
    }

    public int compareTo(Object object) {
        int n;
        int n2 = n = this == object ? 0 : 1;
        if (n != 0 && object instanceof NodeKey) {
            NodeKey nodeKey = (NodeKey)object;
            n = NodeKey.compareTypeObjs(this.typeObj, nodeKey.typeObj);
            if (n == 0 && (n = ComparisonUtil.compare((int)this.ipAddr, (int)nodeKey.ipAddr)) == 0) {
                n = NodeKey.isWildcard(this.nodeId) || NodeKey.isWildcard(nodeKey.nodeId) ? 0 : ComparisonUtil.compare((int)this.nodeId, (int)nodeKey.nodeId);
            }
        }
        return n;
    }

    protected static int compareTypeObjs(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : 1;
        }
        if (object2 == null) {
            return -1;
        }
        if (object == object2) {
            return 0;
        }
        if (object instanceof Comparable && object2 instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof Class && object2 instanceof Class) {
            object = (Class)object;
            object2 = (Class)object2;
        }
        return object.equals(object2) ? 0 : 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        int n = this.typeObj.hashCode();
        n *= 7;
        n += this.ipAddr;
        if (!NodeKey.isWildcard(this.nodeId)) {
            n *= 7;
            n += this.nodeId;
        }
        return n;
    }

    protected static String makeDottedString(int n) {
        String string = (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF);
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("nodeId: ");
        stringBuffer.append(Integer.toString(this.nodeId));
        stringBuffer.append(", ipAddr: ");
        String string = NodeKey.makeDottedString(this.ipAddr);
        stringBuffer.append(string);
        stringBuffer.append(", typeObj: ");
        this.typeObj = this.typeObj;
        stringBuffer.append(this.typeObj);
        return stringBuffer.toString();
    }
}

