/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.fv.IFvEventInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IAlarmMessage;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISonetLineModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.IBestEffortBean;
import cerent.util.KDebug;
import cerent.util.SDHTDMTerminology;
import cerent.util.SonetLoNum;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class EventInfo
implements IBestEffortBean,
IFvEventInfo {
    protected static final int BITS_OBJECT = 21;
    protected static final int SYNC_EXT_OBJECT = 25;
    public static final char RAISE = 'R';
    public static final char CLEAR = 'C';
    public static final char TRANS = 'T';
    public static final String DWDM_LINE = "LINE";
    public static final String DWDM_CHAN = "CHAN";
    public static final String DWDM_BAND = "BAND";
    public static final String DWDM_LINEWL = "LINEWL";
    public static final String DWDM_RX = "RX";
    public static final String DWDM_TX = "TX";
    public static final String COND_PM_TCA = "PM-TCA";
    public static final int UNDEFINED_VALUE = -1;
    private static final int DS1PERDS3 = 28;
    public static final int UTS_MAX_PHYSICAL_SLOT = 17;
    public static final int UTS_FAN_LOGICAL_SLOT = 20;
    public static final int UTS_BITS_LOGICAL_SLOT = 25;
    public static final int UTS_MSISC_A_LOGICAL_SLOT = 24;
    public static final int UTS_MSISC_B_LOGICAL_SLOT = 26;
    public static final int UTS_ADC_LOGICAL_SLOT = 29;
    public static final int UTS_PWRA_LOGICAL_SLOT = 30;
    public static final int UTS_LCD_LOGICAL_SLOT = 31;
    public static final int UTS_PWRB_LOGICAL_SLOT = 32;
    private String nodeName;
    private long timeStamp;
    private long sequenceNumber;
    private long correlateNumber;
    private boolean newAlm;
    private String nodeHostName;
    private int nodeId;
    private INodeModel nodeModel;
    private TDMTerminology terms;
    private boolean isSonet = true;
    private boolean isMultishelf;
    private int objectType;
    private int eqType;
    private int shelfId;
    private int slot;
    private int port;
    private int index;
    private int wavelength = -1;
    private boolean needWavelength = false;
    private String tl1Name;
    private int severity;
    private boolean srvAffecting;
    private char state;
    private int condition = -1;
    private String condDesc;
    private String condCode;
    private short subtype;
    private int subtypeInt;
    private int data1 = -1;
    private int data2 = -1;
    private int entityId = -1;
    private int entityType = -1;
    private String entityTypeString;
    private boolean suppressed;
    private String myPortName;
    private int pathWidth = -1;
    private String neDate;
    private String ctcDate;
    private int stsNum = -1;
    private int vtNum = -1;
    private int ringID = -1;
    private int bitsNumber = -1;
    private int fanIndex = -1;
    private int ds1Num = -1;
    private int ds3Num = -1;
    private int[] entityHierarchyNum = new int[0];
    private String detectName;
    private String condShortCode;
    private String TCAMonType;
    private String TCALocation;
    private String TCAPeriod;
    private String almLocation;
    private String almDirection;
    private IAlarmMessage alarmMsg;
    private ObjIdentPortnumEqtype objIdent;
    private boolean is600 = false;
    private static final String[] directionText = new String[]{"", " Transmit", " Receive", " NA"};
    private static final String[] tcaDirectionText = new String[]{"", " Receive", " Transmit"};
    private static final String[] locationText = new String[]{"", " FAR", " NEAR", " NA"};
    private static final String[] periodText = new String[]{"", " 15MIN", " 1DAY", " ??", " 1HOUR", " ??", " ??", " ??"};
    static final int AICI_PORT_LOW = 9;
    static final int AICI_PORT_EOW = 10;
    static final int AICI_PORT_DCC_A = 11;
    static final int AICI_PORT_DCC_B = 12;
    static final int AICI_PORT_UDC_A = 15;
    static final int AICI_PORT_UDC_B = 16;
    static final int AICI_PORT_IN_MIN = 19;
    private static final int PORT_EXT_OUT_MIN = 51;
    private static final String AID_DELIMITER = "-";
    private boolean requiredNewCardName;
    private EventInfo correlated;
    private static final KDebug db = new KDebug("EventInfo");

    public EventInfo(INodeModel iNodeModel, long l, String string, String string2, IAlarmMessage iAlarmMessage, IAlarmDecoder iAlarmDecoder) {
        int n;
        Object object;
        this.nodeName = iNodeModel.getName();
        this.nodeHostName = iNodeModel.getHostName();
        this.nodeModel = iNodeModel;
        this.requiredNewCardName = Feature.provides(iNodeModel, Feature.MULTISHELF);
        try {
            this.nodeId = iNodeModel.getNodeId();
            object = iNodeModel.getNeType();
            if (object != null) {
                this.is600 = ((String)object).startsWith("15600");
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.nodeId = -1;
        }
        try {
            this.isSonet = true;
            if (iNodeModel.getDelegate() == null) {
                this.terms = null;
                this.isSonet = true;
            } else if (Feature.provides(iNodeModel, Feature.SDH_AU3)) {
                this.terms = iNodeModel.getTDMTerminology();
                this.isSonet = iNodeModel.getTdmProtocolTypeObj().isSonet();
            } else if (Feature.provides(iNodeModel, Feature.FTG)) {
                this.terms = iNodeModel.getTDMTerminology();
                this.isSonet = iNodeModel.getFramingTypeObj().isSonet();
            } else {
                this.terms = TDMTerminology.getDefault();
                this.isSonet = !(this.terms instanceof SDHTDMTerminology);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println(abstractCmsIOException + ": during construction of EventInfo)");
            }
            this.terms = null;
            this.isSonet = true;
        }
        catch (AbstractMethodError abstractMethodError) {
            this.terms = null;
            this.isSonet = true;
        }
        if (this.nodeId == 0) {
            this.nodeId = -1;
        }
        this.timeStamp = l;
        this.ctcDate = string;
        this.neDate = string2;
        this.alarmMsg = iAlarmMessage;
        this.objectType = iAlarmMessage.getObject().getType();
        this.index = iAlarmMessage.getObject().getIndex();
        this.state = this.testState(iAlarmMessage.getAlarm().getState());
        this.condition = iAlarmMessage.getAlarm().getCondition();
        this.severity = iAlarmMessage.getAlarm().getSeverity();
        boolean bl = this.srvAffecting = iAlarmMessage.getAlarm().getService() == 1;
        if (Feature.provides(iNodeModel, Feature.TCA_DIRECTION)) {
            this.subtypeInt = iAlarmMessage.getAlarm().getSubtypeInt();
        } else {
            this.subtype = iAlarmMessage.getAlarm().getSubtype();
        }
        this.data1 = iAlarmMessage.getAlarm().getDat();
        this.data2 = iAlarmMessage.getAlarm().getDat2();
        this.objIdent = new ObjIdentPortnumEqtype(iNodeModel, iAlarmMessage);
        this.suppressed = this.computeSuppressed(iAlarmMessage);
        this.sequenceNumber = this.computeSequenceNumber(iAlarmMessage);
        this.correlateNumber = this.computeCorrelateNumber(iAlarmMessage);
        this.newAlm = true;
        object = iAlarmMessage.getObject().getName();
        for (n = 0; n < ((Object)object).length && object[n] != false; ++n) {
        }
        this.tl1Name = new String((char[])object, 0, n);
        try {
            this.isMultishelf = iNodeModel.getDelegate() != null && this.condition < 1024 && Feature.provides(iNodeModel, Feature.MULTISHELF) && iNodeModel.isMultishelf();
        }
        catch (Exception exception) {
            this.isMultishelf = false;
        }
        if (Feature.provides(iNodeModel, Feature.EID_REMOVAL)) {
            char[] cArray;
            this.entityType = iAlarmMessage.getObject().getEntityType();
            if (this.state != 'T' && this.entityType == 41) {
                this.entityType = 40;
            }
            if ((this.entityType == 13 || this.entityType == 40) && (cArray = iAlarmMessage.getObject().getDetectName()) != null && cArray.length > 0) {
                for (n = 0; n < cArray.length && cArray[n] != '\u0000'; ++n) {
                }
                this.detectName = new String(cArray, 0, n);
            }
        } else {
            this.entityId = iAlarmMessage.getObject().getEntityId();
            this.entityType = this.entityId >>> 24;
        }
        this.pathWidth = this.computePathWidth(iAlarmMessage);
        this.parseDataFromAid(iNodeModel);
        if (Feature.provides(iNodeModel, Feature.OPTIONAL_ALARM_FIELDS)) {
            this.condCode = iAlarmMessage.getAlarm().getOptionalName();
            if (this.condCode.length() <= 1) {
                this.condCode = iAlarmDecoder.getCondCode(iNodeModel, this);
            }
            this.condDesc = iAlarmMessage.getAlarm().getOptionalDesc();
            if (this.condDesc.length() <= 1) {
                this.condDesc = iAlarmDecoder.getCondDesc(iNodeModel, this);
            }
        } else {
            this.condCode = iAlarmDecoder.getCondCode(iNodeModel, this);
            this.condDesc = iAlarmDecoder.getCondDesc(iNodeModel, this);
        }
        if (this.isValidPortNum(this.port)) {
            this.myPortName = this.getPortNameFor(iNodeModel, this.index);
            this.wavelength = Feature.provides(iNodeModel, Feature.COLOR_DIR_LESS) ? iAlarmMessage.getObject().getWavelength() : this.getWavelengthFor(iNodeModel, this.index);
        }
        this.convertStsToVc4(iNodeModel);
        this.condShortCode = iAlarmDecoder.getConditionCode(this.condition);
        this.TCAMonType = this.computeTCAConditionCode(iNodeModel, iAlarmDecoder);
        if (Feature.provides(iNodeModel, Feature.TCA_DIRECTION)) {
            this.TCALocation = this.computeTCALocation(this.getSubTypeInt(), (long)this.getData1(), (long)this.getData2());
            this.TCAPeriod = this.computeTCAPeriod(this.getSubTypeInt(), (long)this.getData1(), (long)this.getData2());
        } else {
            this.TCALocation = this.computeTCALocation(this.getSubType(), (long)this.getData1(), (long)this.getData2());
            this.TCAPeriod = this.computeTCAPeriod(this.getSubType(), (long)this.getData1(), (long)this.getData2());
        }
        if (Feature.provides(iNodeModel, Feature.ALARM_DIRECTION_LOCATION)) {
            this.almLocation = this.computeAlmLocation(this.getSubTypeInt());
            this.almDirection = this.computeAlmDirection(this.getSubTypeInt());
        } else {
            this.almLocation = "";
            this.almDirection = "";
        }
        if (db.on()) {
            db.println("************************************");
            db.println("Entity Type:" + this.entityType + " eqType: " + this.eqType + " AID: " + this.tl1Name + " DetectName: " + this.detectName);
            db.println("condShortCode: " + this.condShortCode + " slot: " + this.getSlot() + " port: " + this.port + " stsNum: " + this.stsNum + " vtNum: " + this.vtNum + " ringID: " + this.ringID + " bitsNumber: " + this.bitsNumber + " fanIndex: " + this.fanIndex + " ds1Num: " + this.ds1Num + " ds3Num: " + this.ds3Num + " entHierNum: " + PortHelper.getConcatenatedString(this.entityHierarchyNum));
            db.println("condShortCode: " + this.condShortCode + " condCode: " + this.condCode + " condDesc: " + this.condDesc + " TCAMonType: " + this.TCAMonType + " TCALocation: " + this.TCALocation + " TCAPeriod: " + this.TCAPeriod);
            db.println("************************************");
        }
    }

    public EventInfo(INodeModel iNodeModel, long l, String string, IAlarmMessage iAlarmMessage, IAlarmDecoder iAlarmDecoder) {
        this(iNodeModel, l, "", "", iAlarmMessage, iAlarmDecoder);
        this.ctcDate = string + " " + TimeZone.getDefault().getDisplayName(true, 0);
        this.neDate = this.ctcDate + "*";
    }

    public boolean isCorrelated() {
        return this.correlated != null;
    }

    public EventInfo getCorrelated() {
        return this.correlated;
    }

    public void setCorrelated(EventInfo eventInfo) {
        this.correlated = eventInfo;
    }

    private int computeShelfId(String string) {
        int n = this.convertStringToInt(string);
        return n;
    }

    protected String getPortNameFor(INodeModel iNodeModel, int n) {
        String string;
        block4: {
            string = null;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                IPortModel iPortModel = (IPortModel)iEntityModel;
                if (null == iPortModel) {
                    return null;
                }
                IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
                if (iInterfaceModel == null) {
                    return null;
                }
                string = iPortModel.getInterfaceModel().getAlias();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("index 0x" + n + " is not valid entity");
            }
        }
        return string;
    }

    protected int getWavelengthFor(INodeModel iNodeModel, int n) {
        int n2;
        block3: {
            n2 = -1;
            try {
                if (iNodeModel.provides(Feature.OCH_TRAIL_PROVISIONING)) {
                    IPortModel iPortModel = (IPortModel)iNodeModel.getEntityTable().getEntityModelByIndex(n);
                    n2 = ((IOpticsChannelModel)((Object)iPortModel.getInterfaceModel())).getActualWaveLength();
                }
            }
            catch (Exception exception) {
                if (!DWDM_LINEWL.equals(this.entityTypeString)) break block3;
                this.needWavelength = true;
            }
        }
        return n2;
    }

    public boolean hasValidStsNum(int n) {
        return n == 13 || n == 15 || n == 40 || n == 41 || n == 18;
    }

    private int computeStsNum(String string) {
        int n = -1;
        if (this.hasValidStsNum(this.entityType)) {
            n = this.isElectricalCard() ? this.getElectricalStsNum() : this.convertStringToInt(string);
        }
        return n;
    }

    public boolean hasValidVtNum(int n) {
        return n == 40 || n == 41;
    }

    private int getDs3StsNum() {
        return 1;
    }

    private boolean isValidPortNum(int n) {
        boolean bl = false;
        if (n == 0) {
            bl = this.isZeroBasedPort();
        } else if (n > 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean isZeroBasedPort() {
        return this.getEqType() == 103 || this.getEqType() == 104 || this.getEqType() == 102 || this.getEqType() == 238 || this.getEqType() == 221 || this.getEqType() == 105 || this.getEqType() == 285 || this.getEqType() == 164;
    }

    protected boolean isElectricalCard() {
        return this.eqType == 32 || this.eqType == 6 || this.eqType == 7 || this.eqType == 8 || this.eqType == 145 || this.eqType == 57 || this.eqType == 58 || this.eqType == 65 || this.eqType == 12 || this.eqType == 13;
    }

    private int getElectricalStsNum() {
        return 1;
    }

    private int getElectricalPathWidth() {
        return 1;
    }

    public boolean hasValidDs1Num(int n) {
        return n == 4;
    }

    private int computeDS1Num(String string) {
        int n = -1;
        if (this.hasValidDs1Num(this.eqType)) {
            n = this.convertStringToInt(string);
        }
        return n;
    }

    public boolean hasValidDs3Num(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 57: 
            case 58: 
            case 66: 
            case 67: 
            case 145: {
                return true;
            }
        }
        return false;
    }

    private int computeDS3Num(String string) {
        int n = -1;
        if (this.hasValidDs3Num(this.eqType)) {
            n = this.convertStringToInt(string);
        }
        return n;
    }

    private int computeWbePort(int n, int n2) {
        return (n - 1) * 28 + n2;
    }

    private int[] buildEntityHierarchyNum() {
        int[] nArray = new int[]{};
        if (this.entityHierarchyNum.length > 0) {
            return this.entityHierarchyNum;
        }
        if (this.getPort() > 0) {
            nArray = new int[]{this.getPort()};
        }
        return nArray;
    }

    private String computeTCAConditionCode(INodeModel iNodeModel, IAlarmDecoder iAlarmDecoder) {
        String string = null;
        if (COND_PM_TCA.equals(this.condShortCode)) {
            try {
                string = iAlarmDecoder.getCondCode(iNodeModel, this);
            }
            catch (AbstractMethodError abstractMethodError) {
                if (db.on()) {
                    db.println("Method Not implemented");
                }
                string = this.condCode;
            }
        }
        return string;
    }

    private String computeTCAPeriod(short s, long l, long l2) {
        int n = (s & 0x300) >> 8;
        return this.computePeriod(n, l, l2);
    }

    private String computeTCAPeriod(int n, long l, long l2) {
        int n2 = (n & 0x300) >> 8;
        return this.computePeriod(n2, l, l2);
    }

    private String computePeriod(int n, long l, long l2) {
        String string;
        block3: {
            string = null;
            if (COND_PM_TCA.equals(this.condShortCode)) {
                try {
                    string = periodText[n];
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    db.println(" Exception when obtaining TCA period");
                }
            }
        }
        return string;
    }

    private String computeTCALocation(short s, long l, long l2) {
        int n = (s & 0xC0) >> 6;
        return this.computeLocation(n, l, l2);
    }

    private String computeAlmDirection(int n) {
        int n2 = 0;
        if (this.condShortCode.equals(COND_PM_TCA)) {
            n2 = (n & 0x30000) >> 16;
            if (n2 < tcaDirectionText.length) {
                return tcaDirectionText[n2];
            }
            return "";
        }
        n2 = (n & 0xC0000) >> 18;
        if (n2 < directionText.length) {
            return directionText[n2];
        }
        return "";
    }

    private String computeAlmLocation(int n) {
        int n2 = 0;
        n2 = this.condShortCode.equals(COND_PM_TCA) ? (n & 0xC0) >> 6 : (n & 0x30000) >> 16;
        if (n2 < locationText.length) {
            return locationText[n2];
        }
        return "";
    }

    private String computeTCALocation(int n, long l, long l2) {
        int n2 = (n & 0xC0) >> 6;
        return this.computeLocation(n2, l, l2);
    }

    private String computeLocation(int n, long l, long l2) {
        String string;
        block3: {
            string = null;
            if (COND_PM_TCA.equals(this.condShortCode)) {
                try {
                    string = locationText[n];
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    db.println(" Exception when obtaining TCA location");
                }
            }
        }
        return string;
    }

    private int computePathWidth(IAlarmMessage iAlarmMessage) {
        int n = -1;
        try {
            if (this.hasValidStsNum(this.entityType)) {
                n = iAlarmMessage.getObject().getStsWidth();
                if (!this.isSonet) {
                    n /= 3;
                }
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            int n2 = iAlarmMessage.getObject().getName().length;
            n = iAlarmMessage.getObject().getName()[n2 - 6] & 0xFF;
        }
        return n;
    }

    private boolean computeSuppressed(IAlarmMessage iAlarmMessage) {
        try {
            return iAlarmMessage.getAlarm().getSuppressFlag() == 'S';
        }
        catch (AbstractMethodError abstractMethodError) {
            int n = iAlarmMessage.getObject().getName().length;
            return iAlarmMessage.getObject().getName()[n - 5] == 'S';
        }
    }

    private int computeSequenceNumber(IAlarmMessage iAlarmMessage) {
        try {
            return iAlarmMessage.getSeqNum();
        }
        catch (AbstractMethodError abstractMethodError) {
            int n = iAlarmMessage.getObject().getName().length;
            return ((iAlarmMessage.getObject().getName()[n - 4] & 0xFF) << 8) + (iAlarmMessage.getObject().getName()[n - 3] & 0xFF);
        }
    }

    private int computeCorrelateNumber(IAlarmMessage iAlarmMessage) {
        try {
            return iAlarmMessage.getRefNum();
        }
        catch (AbstractMethodError abstractMethodError) {
            int n = iAlarmMessage.getObject().getName().length;
            return ((iAlarmMessage.getObject().getName()[n - 2] & 0xFF) << 8) + (iAlarmMessage.getObject().getName()[n - 1] & 0xFF);
        }
    }

    private char testState(char c) {
        int n = c == '\u0001' ? 67 : (c == '\u0000' ? 82 : (c == '\u0002' ? 84 : 0));
        return (char)n;
    }

    private void parseDataFromAid(INodeModel iNodeModel) {
        block65: {
            if (this.tl1Name == null || this.tl1Name.length() <= 0) {
                if (db.on()) {
                    db.println("aid (tl1Name) is either null or empty");
                }
                return;
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.tl1Name, AID_DELIMITER);
                boolean bl = false;
                int n = stringTokenizer.countTokens();
                if (stringTokenizer.hasMoreTokens()) {
                    this.entityTypeString = stringTokenizer.nextToken();
                }
                switch (this.entityType) {
                    case 4: 
                    case 74: {
                        this.parseEntityHierarchy(stringTokenizer, stringTokenizer.countTokens(), iNodeModel);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 10: 
                    case 14: 
                    case 17: 
                    case 19: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 29: 
                    case 30: 
                    case 32: 
                    case 33: 
                    case 45: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 66: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 88: 
                    case 90: 
                    case 97: 
                    case 99: 
                    case 100: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 135: 
                    case 136: {
                        this.parseEntityHierarchy(stringTokenizer, stringTokenizer.countTokens(), iNodeModel);
                        this.port = this.entityHierarchyNum.length > 0 ? this.entityHierarchyNum[0] : 0;
                        break;
                    }
                    case 38: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.slot = this.computeSlotNum(stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.port = this.computePortNum(stringTokenizer.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        this.ds1Num = this.computeDS1Num(stringTokenizer.nextToken());
                        break;
                    }
                    case 13: 
                    case 15: 
                    case 18: 
                    case 20: 
                    case 47: 
                    case 68: 
                    case 69: {
                        int n2 = stringTokenizer.countTokens() - 1;
                        if (this.entityType == 13 && this.entityTypeString.startsWith("VFAC")) {
                            n2 = stringTokenizer.countTokens();
                        }
                        this.parseEntityHierarchy(stringTokenizer, n2, iNodeModel);
                        int n3 = this.port = this.entityHierarchyNum.length > 0 ? this.entityHierarchyNum[0] : 0;
                        if (!stringTokenizer.hasMoreTokens()) break;
                        if (this.getEqType() == 248) {
                            this.port = this.convertStringToInt(stringTokenizer.nextToken());
                            break;
                        }
                        this.stsNum = this.computeStsNum(stringTokenizer.nextToken());
                        break;
                    }
                    case 27: {
                        this.setShelf(stringTokenizer);
                        bl = true;
                        if (this.isUts6Shelf(this.shelfId)) {
                            this.slot = 29;
                        }
                    }
                    case 28: 
                    case 42: 
                    case 43: {
                        if (!bl) {
                            this.shelfId = 1;
                            if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                                this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                            }
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.entityTypeString = this.entityTypeString + AID_DELIMITER + stringTokenizer.nextToken();
                        }
                        this.port = this.objIdent.getPortNumber();
                        this.eqType = this.objIdent.getEqType();
                        if (iNodeModel != null) {
                            IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.index);
                            this.slot = iEntityModel.getSlot();
                            break;
                        }
                        db.println("Error: node is null");
                        break;
                    }
                    case 35: {
                        if (!stringTokenizer.hasMoreTokens()) break;
                        this.ringID = this.convertStringToInt(stringTokenizer.nextToken());
                        break;
                    }
                    case 21: {
                        this.setShelf(stringTokenizer);
                        if (this.isUts6Shelf(this.shelfId)) {
                            this.slot = 25;
                            this.setPort(stringTokenizer);
                            this.bitsNumber = this.port;
                            break;
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        this.bitsNumber = this.computeBits(stringTokenizer.nextToken());
                        break;
                    }
                    case 138: {
                        this.setShelf(stringTokenizer);
                        if (!this.isUts6Shelf(this.shelfId) || !stringTokenizer.hasMoreTokens()) break;
                        String string = stringTokenizer.nextToken();
                        this.slot = string.equals("A") ? 24 : 26;
                        this.setPort(stringTokenizer);
                        break;
                    }
                    case 139: {
                        this.setShelf(stringTokenizer);
                        break;
                    }
                    case 25: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        this.bitsNumber = this.computeBits(stringTokenizer.nextToken());
                        break;
                    }
                    case 8: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (this.isUts6Shelf(this.shelfId) || this.isUts2Shelf(this.shelfId)) {
                            this.slot = 20;
                        } else if (stringTokenizer.hasMoreTokens()) {
                            this.computeSlotNum(stringTokenizer.nextToken());
                        }
                        if (!this.is600 || !stringTokenizer.hasMoreTokens()) break;
                        this.fanIndex = this.convertStringToInt(stringTokenizer.nextToken());
                        break;
                    }
                    case 34: 
                    case 36: 
                    case 58: 
                    case 60: 
                    case 61: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.slot = this.computeSlotNum(stringTokenizer.nextToken());
                        }
                        this.port = this.objIdent.getPortNumber();
                        break;
                    }
                    case 41: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.slot = this.computeSlotNum(stringTokenizer.nextToken());
                        }
                        if (this.entityTypeString.equals("VCM") || this.entityTypeString.equals("VFAC")) {
                            if (!stringTokenizer.hasMoreTokens()) break;
                            this.port = this.computePortNum(stringTokenizer.nextToken());
                            break;
                        }
                        if (this.entityTypeString.equals("VC12") || this.entityTypeString.equals("VC11")) {
                            int n4;
                            for (n4 = 0; n4 < 2 && stringTokenizer.hasMoreTokens(); ++n4) {
                                stringTokenizer.nextToken();
                            }
                            n4 = 1;
                            int n5 = 1;
                            if (stringTokenizer.hasMoreTokens()) {
                                n4 = this.convertStringToInt(stringTokenizer.nextToken());
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                n5 = this.convertStringToInt(stringTokenizer.nextToken());
                            }
                            this.port = (n5 - 1) * 7 + n4;
                            break;
                        }
                        if (!this.entityTypeString.equals("VT1")) break;
                        if (stringTokenizer.hasMoreTokens()) {
                            this.stsNum = this.computeStsNum(stringTokenizer.nextToken());
                        }
                        int n6 = 0;
                        int n7 = 0;
                        if (stringTokenizer.hasMoreTokens()) {
                            n6 = this.convertStringToInt(stringTokenizer.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        n7 = this.convertStringToInt(stringTokenizer.nextToken());
                        this.vtNum = SonetLoNum.GetLoVal(n6, n7, SonetLoNum.NumOfGroups());
                        int n8 = this.port = this.port == 0 ? this.vtNum : this.port;
                        if (this.eqType != 234) break;
                        this.port = this.computeWbePort(this.stsNum, this.vtNum);
                        break;
                    }
                    case 40: 
                    case 52: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (this.entityTypeString.equals("VC12") || this.entityTypeString.equals("VC11") || this.entityTypeString.equals("VC3")) {
                            if (stringTokenizer.hasMoreTokens()) {
                                this.slot = this.computeSlotNum(stringTokenizer.nextToken());
                            }
                            if (!stringTokenizer.hasMoreTokens()) break;
                            this.port = this.computePortNum(stringTokenizer.nextToken());
                            break;
                        }
                        if (this.entityTypeString.equals("VT1") || this.entityTypeString.equals("VT2")) {
                            this.parseEntityHierarchy(stringTokenizer, stringTokenizer.countTokens() - 3, iNodeModel);
                            this.eqType = this.objIdent.getEqType();
                            if (this.eqType == 218) {
                                this.port = this.objIdent.getPortNumber();
                            } else {
                                int n9 = this.port = this.entityHierarchyNum.length > 0 ? this.entityHierarchyNum[0] : 0;
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                this.stsNum = this.computeStsNum(stringTokenizer.nextToken());
                            }
                            int n10 = 0;
                            int n11 = 0;
                            if (stringTokenizer.hasMoreTokens()) {
                                n10 = this.convertStringToInt(stringTokenizer.nextToken());
                            }
                            if (!stringTokenizer.hasMoreTokens()) break;
                            n11 = this.convertStringToInt(stringTokenizer.nextToken());
                            this.vtNum = SonetLoNum.GetLoVal(n10, n11, SonetLoNum.NumOfGroups());
                            int n12 = this.port = this.port == 0 ? this.vtNum : this.port;
                            if (this.eqType != 234) break;
                            this.port = this.computeWbePort(this.stsNum, this.vtNum);
                            break;
                        }
                        if (!this.entityTypeString.equals("VCM") && !this.entityTypeString.equals("VFAC")) break;
                        if (stringTokenizer.hasMoreTokens()) {
                            this.slot = this.computeSlotNum(stringTokenizer.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        this.port = this.computePortNum(stringTokenizer.nextToken());
                        break;
                    }
                    case 67: {
                        this.setShelf(stringTokenizer);
                        if (this.isUts6Shelf(this.shelfId)) {
                            if (!stringTokenizer.hasMoreTokens()) break;
                            String string = stringTokenizer.nextToken();
                            if (string.equals("A")) {
                                this.slot = 30;
                                break;
                            }
                            this.slot = 32;
                            break;
                        }
                        if (!this.isUts2Shelf(this.shelfId)) break;
                        this.slot = 30;
                        break;
                    }
                    case 140: {
                        this.setShelf(stringTokenizer);
                        if (!this.isUts6Shelf(this.shelfId)) break;
                        this.slot = 31;
                        break;
                    }
                    case 137: {
                        this.shelfId = 1;
                        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
                            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.slot = this.computeSlotNum(stringTokenizer.nextToken());
                        }
                        if (!stringTokenizer.hasMoreTokens()) break;
                        this.entityHierarchyNum = new int[1];
                        this.entityHierarchyNum[0] = this.computePortNum(stringTokenizer.nextToken());
                        break;
                    }
                    default: {
                        this.shelfId = 1;
                        if (!this.isMultishelf || !stringTokenizer.hasMoreTokens()) break;
                        this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
                    }
                }
                this.entityHierarchyNum = this.buildEntityHierarchyNum();
            }
            catch (Exception exception) {
                if (!db.on()) break block65;
                db.println("Error: Exception while parsing AID");
                db.println("EntityType: " + this.entityType + " AID: " + this.tl1Name);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void parseEntityHierarchy(StringTokenizer stringTokenizer, int n, INodeModel iNodeModel) {
        if (db.isFineEnabled()) {
            db.fine("parseEntityHierarchy: token count = " + stringTokenizer.countTokens() + " EntityCnt = " + n);
        }
        this.shelfId = 1;
        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
            --n;
        }
        if (stringTokenizer.hasMoreTokens()) {
            int n2;
            this.slot = this.computeSlotNum(stringTokenizer.nextToken());
            --n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            String string = null;
            for (n2 = 0; n2 < n && stringTokenizer.hasMoreTokens(); ++n2) {
                string = stringTokenizer.nextToken();
                if (Feature.provides(iNodeModel, Feature.POS_ON_MLMR) && n2 == n - 1 && (string.equals("E") || string.equals("W"))) break;
                arrayList.add(this.convertStringToInt(string));
            }
            this.entityHierarchyNum = new int[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.entityHierarchyNum[n2] = (Integer)arrayList.get(n2);
            }
        }
    }

    private void setShelf(StringTokenizer stringTokenizer) {
        this.shelfId = 1;
        if (this.isMultishelf && stringTokenizer.hasMoreTokens()) {
            this.shelfId = this.computeShelfId(stringTokenizer.nextToken());
        }
    }

    private void setPort(StringTokenizer stringTokenizer) {
        this.port = 1;
        if (stringTokenizer.hasMoreTokens()) {
            this.port = this.computePortNum(stringTokenizer.nextToken());
        }
    }

    private int computeSlotNum(String string) {
        int n = this.convertStringToInt(string);
        if (n > 0) {
            this.eqType = this.objIdent.getEqType();
            if (this.eqType == 21 || this.eqType == 25) {
                n = 0;
            }
        }
        return n;
    }

    private int computePortNum(String string) {
        int n = this.convertStringToInt(string);
        switch (this.getEqType()) {
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 221: 
            case 238: {
                if (n <= 0) break;
                return n >= 5 ? n - 5 : n - 1;
            }
            case 183: 
            case 184: 
            case 243: 
            case 282: {
                if (n < 11) break;
                return n - 10;
            }
            case 273: {
                if (n <= 19) break;
                return n - 19;
            }
        }
        return n;
    }

    private int computeBits(String string) {
        if (this.entityType == 25 && string != null && string.startsWith("BITS")) {
            string = string.substring(string.length() - 1, string.length());
        }
        return this.convertStringToInt(string);
    }

    private int convertStringToInt(String string) {
        int n;
        block3: {
            n = -1;
            try {
                if (string != null) {
                    n = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!db.on()) break block3;
                db.println("Error: NumberFormatException while parsing " + string + " from " + this.tl1Name + " for EntityType " + this.entityType);
                KDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        return n;
    }

    private void convertStsToVc4(INodeModel iNodeModel) {
        switch (this.eqType) {
            case 28: 
            case 29: 
            case 30: 
            case 61: {
                if (!this.tl1Name.substring(0, 3).equals("STS")) break;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel == null) {
                    return;
                }
                try {
                    boolean bl;
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.index);
                    IPortModel iPortModel = (IPortModel)iEntityModel;
                    if (Feature.provides(iNodeModel, Feature.FTG)) {
                        ITdmLineModel iTdmLineModel = (ITdmLineModel)iPortModel.getInterfaceModel();
                        bl = iTdmLineModel.getMediumType() == 0;
                    } else {
                        ISonetLineModel iSonetLineModel = (ISonetLineModel)iPortModel.getInterfaceModel();
                        boolean bl2 = bl = iSonetLineModel.getMediumType() == 0;
                    }
                    if (!bl) break;
                    this.tl1Name = "VC4" + this.tl1Name.substring(3);
                    break;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break;
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    break;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!db.on()) break;
                    KDebug.printStackTrace((Throwable)abstractCmsIOException);
                    break;
                }
                catch (Exception exception) {
                    if (!db.on()) break;
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    public String getNodeHostName() {
        return this.nodeHostName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    public boolean isSonet() {
        return this.isSonet;
    }

    public boolean requireNewCardName() {
        return this.requiredNewCardName;
    }

    public TDMTerminology getTDMTerminology() {
        return this.terms;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public boolean isOnMultishelf() {
        return this.isMultishelf;
    }

    public boolean isMultishelfViewCondition() {
        return this.isMultishelf && this.getTl1Name().trim().equals("SYSTEM");
    }

    public int getShelfId() {
        return this.shelfId;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getPort() {
        return this.port;
    }

    public int getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(int n) {
        this.wavelength = n;
    }

    public boolean needsWavelength() {
        return this.needWavelength;
    }

    public int getRelativePort() {
        if (this.getEqType() == 97) {
            return this.getAiciPort(this.port);
        }
        return this.port;
    }

    protected int getAiciPort(int n) {
        int n2 = 0;
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = n;
                break;
            }
            default: {
                n2 = n < 51 ? n + 19 - 1 : n + 51 - 1;
            }
        }
        return n2;
    }

    public char getState() {
        return this.state;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCondition() {
        return this.condition;
    }

    public String getCondDesc() {
        return this.condDesc;
    }

    public String getCondCode() {
        return this.condCode;
    }

    public String getConditionShortCode() {
        return this.condShortCode;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public int getEqType() {
        return this.eqType;
    }

    public String getTl1Name() {
        return this.tl1Name;
    }

    public String getDetectName() {
        return this.detectName;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getPortType() {
        int n;
        block2: {
            n = -1;
            try {
                n = this.alarmMsg.getObject().getPortType();
            }
            catch (AbstractMethodError abstractMethodError) {
                if (!db.on()) break block2;
                db.println("Abstract Method Error in getPortType()");
            }
        }
        return n;
    }

    public String getDate() {
        return this.getCtcDate() + "*";
    }

    public String getNeDate() {
        return this.neDate;
    }

    public String getCtcDate() {
        return this.ctcDate;
    }

    public boolean getSrvAffecting() {
        return this.srvAffecting;
    }

    public int getData1() {
        return this.data1;
    }

    public int getData2() {
        return this.data2;
    }

    public short getSubType() {
        return this.subtype;
    }

    public int getSubTypeInt() {
        return this.subtypeInt;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getCorrelateNumber() {
        return this.correlateNumber;
    }

    public boolean getNewAlm() {
        return this.newAlm;
    }

    public void setState(char c) {
        this.state = c;
    }

    public void setNewAlm(boolean bl) {
        this.newAlm = bl;
    }

    public boolean getSuppressed() {
        return this.suppressed;
    }

    public int getPathWidth() {
        return this.pathWidth;
    }

    public int getStsNum() {
        return this.stsNum;
    }

    public int getVtNum() {
        return this.vtNum;
    }

    public int getDs1Num() {
        return this.ds1Num;
    }

    public int getDs3Num() {
        return this.ds3Num;
    }

    public int getRingID() {
        return this.ringID;
    }

    public int getFanIndex() {
        return this.fanIndex;
    }

    public int getBitsNumber() {
        return this.bitsNumber;
    }

    public String getAlmDirection() {
        return this.almDirection;
    }

    public String getAlmLocation() {
        return this.almLocation;
    }

    public String getTCALocation() {
        return this.TCALocation;
    }

    public String getTCAMonType() {
        return this.TCAMonType;
    }

    public String getTCAPeriod() {
        return this.TCAPeriod;
    }

    public String getPortName() {
        if (this.myPortName == null) {
            return "";
        }
        return this.myPortName;
    }

    public void setNodeId(int n) {
        this.nodeId = n;
    }

    public void setPortName(String string) {
        this.myPortName = string;
    }

    public int[] getEntityHierarchyNum() {
        return this.entityHierarchyNum;
    }

    public String toString() {
        return "(Nd:" + this.getNodeName() + ";Id:" + Integer.toHexString(this.nodeId) + ";ix:" + Integer.toHexString(this.getIndex()) + ";sh:" + this.getShelfId() + ";sl:" + this.getSlot() + ";po:" + this.getPort() + ";cd:" + this.getCondCode() + ";st:" + this.getState() + ";sv:" + this.getSeverity() + ";eq:" + this.getEqType() + ";pt:" + this.getPortType() + ";ob:" + this.objectType + ";eid:" + Integer.toHexString(this.entityId) + ")";
    }

    public boolean isUts6Shelf(int n) {
        if (Feature.provides(this.nodeModel, Feature.NETWORK_EXPLORER)) {
            IEntityModel iEntityModel = this.nodeModel.getIChassisModelsInstance().getEntityByShelfId(this.shelfId);
            int n2 = 0;
            if (iEntityModel != null) {
                n2 = iEntityModel.getEqType();
            }
            if (n2 == 335 || n2 == 336) {
                return true;
            }
        }
        return false;
    }

    public boolean isUts2Shelf(int n) {
        IEntityModel iEntityModel;
        int n2;
        return Feature.provides(this.nodeModel, Feature.NETWORK_EXPLORER) && ((n2 = (iEntityModel = this.nodeModel.getIChassisModelsInstance().getEntityByShelfId(this.shelfId)).getEqType()) == 333 || n2 == 334);
    }

    class ObjIdentPortnumEqtype {
        int portNumber;
        int eqType;

        ObjIdentPortnumEqtype(INodeModel iNodeModel, IAlarmMessage iAlarmMessage) {
            if (Feature.provides(iNodeModel, Feature.STSDATA_REMOVAL)) {
                this.portNumber = iAlarmMessage.getObject().getPortNumber();
                this.eqType = iAlarmMessage.getObject().getEqType();
            } else {
                short s = iAlarmMessage.getObject().getStsData();
                this.portNumber = s >>> 8 & 0xFF;
                this.eqType = s & 0xFF;
            }
            if (db.on()) {
                db.println("portNumber = " + this.portNumber + " eqType = " + this.eqType);
            }
        }

        public int getPortNumber() {
            return this.portNumber;
        }

        public int getEqType() {
            return this.eqType;
        }
    }
}

