/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.vf;

import cerent.cms.model.Feature;
import cerent.cms.model.vf.Version;
import java.io.Serializable;

public abstract class AbstractVersionedFeature
implements Serializable {
    public static final int COMPATIBLE = 0;
    public static final int INCOMPATIBLE = 1;
    public static final int UNKNOWN = 2;
    private Version version;
    private Feature feature;

    public AbstractVersionedFeature(Feature feature, Version version) {
        this.feature = feature;
        this.version = version;
    }

    public static boolean isCompatibilityPresent(AbstractVersionedFeature abstractVersionedFeature, AbstractVersionedFeature abstractVersionedFeature2) {
        boolean bl;
        if (abstractVersionedFeature == null || abstractVersionedFeature2 == null) {
            bl = false;
        } else {
            int n = abstractVersionedFeature.getCompatibility(abstractVersionedFeature2);
            int n2 = abstractVersionedFeature2.getCompatibility(abstractVersionedFeature);
            bl = n == 0 && n2 == 0 || n == 0 && n2 == 2 || n == 2 && n2 == 0;
        }
        return bl;
    }

    public abstract int getCompatibility(AbstractVersionedFeature var1);

    public int hashCode() {
        return this.version.hashCode() * 13 + this.feature.hashCode() * 17;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof AbstractVersionedFeature) {
            AbstractVersionedFeature abstractVersionedFeature = (AbstractVersionedFeature)object;
            bl = this.feature.equals(abstractVersionedFeature.feature) && this.version.equals(abstractVersionedFeature.version);
        }
        return bl;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.feature.toString() + "[" + this.version.toString() + "]";
    }
}

