/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.helper;

import cerent.cms.model.Feature;
import cerent.cms.model.IIpAddr;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.gui.AbstractTableWriter;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ComponentPrinter;
import cerent.util.gui.ExtensionFileFilter;
import cerent.util.gui.HTMLReportWriter;
import cerent.util.gui.HtmlContentPrinter;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.gui.TableCSVWriter;
import cerent.util.gui.TableContentPrinter;
import cerent.util.gui.TableHTMLWriter;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JTable;

public class ViewHelper {
    private IUiToolkit uiToolkit = null;
    private static List dispTables = null;
    private static String dispHtmlReport = null;
    private static ViewHelper instance = null;
    private static final KDebug db = new KDebug("ViewHelper");
    private static final String EXPORT_PATH = "ctc";
    private static final String EXPORT_PROP = "export.file.path";

    public static ViewHelper instance(IUiToolkit iUiToolkit) {
        if (instance == null) {
            instance = new ViewHelper(iUiToolkit);
        }
        return instance;
    }

    public static void init(IUiToolkit iUiToolkit) {
        if (instance == null) {
            instance = new ViewHelper(iUiToolkit);
        }
    }

    public static ViewHelper instance() {
        if (instance == null) {
            throw new IllegalStateException("The ViewHelper has not been initialized yet.");
        }
        return instance;
    }

    public void printView(IViewController iViewController, int n) throws Exception {
        dispTables = null;
        dispHtmlReport = null;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        switch (n) {
            case 0: {
                ComponentPrinter componentPrinter = new ComponentPrinter(this.uiToolkit.getApplicationFrame());
                book.append(componentPrinter, printerJob.defaultPage());
                break;
            }
            case 1: {
                ComponentPrinter componentPrinter = new ComponentPrinter(iViewController.getTabbedView());
                book.append(componentPrinter, printerJob.defaultPage());
                break;
            }
            case 2: {
                JTable[] jTableArray = ViewHelper.getInnermostTables(iViewController.getTabbedView());
                if (jTableArray == null) {
                    String string = this.getInnermostHtmlReport(iViewController.getTabbedView());
                    HtmlContentPrinter htmlContentPrinter = new HtmlContentPrinter(string);
                    book.append(htmlContentPrinter, printerJob.defaultPage());
                    break;
                }
                String string = iViewController.getTabbedView().getSelectedComponent().getName() + " - " + new Date();
                for (int i = 0; i < jTableArray.length; ++i) {
                    JTable jTable = jTableArray[i];
                    if (jTable != null && jTable.getName() != null) {
                        string = jTable.getName();
                    }
                    TableContentPrinter tableContentPrinter = new TableContentPrinter(jTable, true, string);
                    book.append(tableContentPrinter, printerJob.defaultPage(), tableContentPrinter.calcPages());
                }
                break;
            }
            default: {
                throw new Exception("An invalid print mode was requested.");
            }
        }
        this.printBook(printerJob, book);
    }

    public void printBook(PrinterJob printerJob, Book book) {
        if (printerJob != null && book != null) {
            DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            if (printServiceArray.length == 0) {
                if (db.on()) {
                    db.println("Either the printJob or the Book was null.");
                }
                return;
            }
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            if (printService != null && (printService = ServiceUI.printDialog(null, 20, 20, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet)) != null) {
                try {
                    printerJob.setPrintService(printService);
                    printerJob.setPageable(book);
                    this.updatePageFormat(book, ViewHelper.createPageFormat(printService, hashPrintRequestAttributeSet));
                    printerJob.print(hashPrintRequestAttributeSet);
                }
                catch (PrinterException printerException) {
                    if (db.on()) {
                        db.println("Error printing: " + printerException);
                    }
                    KDebug.printStackTrace((Throwable)printerException);
                }
            }
        } else if (db.on()) {
            db.println("Either the printJob or the Book was null.");
        }
    }

    private void updatePageFormat(Book book, PageFormat pageFormat) {
        for (int i = 0; i < book.getNumberOfPages(); ++i) {
            book.setPage(i, book.getPrintable(i), pageFormat);
        }
    }

    private static PageFormat createPageFormat(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        PageFormat pageFormat = new PageFormat();
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (orientationRequested != null) {
            int n = orientationRequested.getValue();
            switch (n) {
                case 3: {
                    pageFormat.setOrientation(1);
                    break;
                }
                case 4: {
                    pageFormat.setOrientation(0);
                    break;
                }
                case 5: {
                    pageFormat.setOrientation(2);
                }
            }
        }
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        if (mediaPrintableArea != null) {
            MediaSize mediaSize;
            Object object;
            Paper paper = pageFormat.getPaper();
            if (ViewHelper.isSupportedValue(printService, mediaPrintableArea, printRequestAttributeSet)) {
                object = mediaPrintableArea.getPrintableArea(25400);
                for (int i = 0; i < ((float[])object).length; ++i) {
                    object[i] = object[i] * 72.0f;
                }
                paper.setImageableArea(object[0], object[1], object[2], object[3]);
            }
            if (ViewHelper.isSupportedValue(printService, media, printRequestAttributeSet) && media instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)(object = (Object)((MediaSizeName)media)))) != null) {
                float f = mediaSize.getX(25400) * 72.0f;
                float f2 = mediaSize.getY(25400) * 72.0f;
                paper.setSize(f, f2);
            }
        }
        return pageFormat;
    }

    protected static boolean isSupportedValue(PrintService printService, Attribute attribute, PrintRequestAttributeSet printRequestAttributeSet) {
        return attribute != null && printService != null && printService.isAttributeValueSupported(attribute, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printRequestAttributeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidFileName(String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            fileWriter.write("test");
            fileWriter.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            String string2 = KErrorMsg.getString((EID)KEMC.EID_FILE_SAVE_EXCEPTION_PARAM_1, (Object)string);
            CerentDialog.errorDialog(this.uiToolkit.getApplicationFrame(), string2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void exportView(AbstractViewController abstractViewController, int n, JTable[] jTableArray, String string, String string2) throws Exception {
        if (jTableArray != null) {
            this.exportTables(n, true, null, string, string2, jTableArray);
        }
    }

    public void exportView(IViewController iViewController, int n) throws Exception {
        String string;
        JTable[] jTableArray;
        dispTables = null;
        dispHtmlReport = null;
        TabbedView tabbedView = iViewController.getTabbedView();
        String string2 = "Exported Data - " + tabbedView.getSelectedComponent().getName() + " - " + new Date();
        String string3 = null;
        if (!iViewController.getViewName().isNetworkView()) {
            jTableArray = this.makeDottedString(tabbedView.getUiModel().getNodeModel().getIpConfig().getIpAddress());
            string = tabbedView.getUiModel().getNodeModel().getName();
            string3 = "NE Name: " + string + "   Node Address: " + (String)jTableArray;
            if (Feature.provides(tabbedView.getUiModel().getNodeModel(), Feature.MULTISHELF) && tabbedView.getUiModel().getNodeModel().isMultishelf() && !iViewController.getViewName().isNodeView()) {
                string3 = string3 + "   Shelf " + iViewController.getCurrentView().getShelfId();
            }
            if (iViewController.getViewName().isCardView()) {
                string3 = string3 + "   Slot " + iViewController.getCurrentView().getSlotId();
            }
        }
        if ((jTableArray = ViewHelper.getInnermostTables(tabbedView)) == null) {
            string = this.getInnermostHtmlReport(tabbedView);
            this.exportHtmlReport(n, string);
        } else {
            this.exportTables(n, true, null, string2, string3, jTableArray);
        }
    }

    public void exportTable(int n, boolean bl, TableModelAdapter tableModelAdapter, String string, String string2, JTable jTable) throws Exception {
        JTable[] jTableArray = new JTable[]{jTable};
        this.exportTables(n, bl, tableModelAdapter, string, string2, jTableArray);
    }

    public void exportTable(int n, boolean bl, TableModelAdapter tableModelAdapter, String string, JTable jTable) throws Exception {
        this.exportTable(n, bl, tableModelAdapter, string, null, jTable);
    }

    public void exportTables(int n, boolean bl, TableModelAdapter tableModelAdapter, String string, String string2, JTable[] jTableArray) throws Exception {
        String string3 = null;
        boolean bl2 = false;
        String string4 = null;
        if (jTableArray == null) {
            throw new Exception("A valid table could not be located for exporting.");
        }
        String string5 = jTableArray.length > 1 ? String.valueOf(0) : null;
        String[] stringArray = jTableArray.length > 1 ? new String[jTableArray.length] : null;
        AbstractTableWriter abstractTableWriter = null;
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
        switch (n) {
            case 0: {
                File file;
                extensionFileFilter.addExtension("html");
                extensionFileFilter.setDescription("HTML files");
                while (!bl2 && (file = PersistentFileChooserDialog.getFileUseChooser(this.uiToolkit.getApplicationFrame(), (byte)2, EXPORT_PATH, EXPORT_PROP, extensionFileFilter)) != null) {
                    Object object;
                    try {
                        for (int i = 0; i < jTableArray.length; ++i) {
                            File file2;
                            object = jTableArray[i];
                            string4 = ((Component)object).getName() == null ? string : ((Component)object).getName();
                            abstractTableWriter = new TableHTMLWriter(this.uiToolkit, (JTable)object, bl, tableModelAdapter, string4, string2);
                            string3 = file.getAbsolutePath();
                            if (string5 != null) {
                                string5 = String.valueOf(i);
                            }
                            if ((file2 = new File(string3 = this.makeFilenameUnique(string3, string5, "html"))).exists() && !this.continueFileOverwrite(string3) || !(bl2 = this.isValidFileName(string3))) continue;
                            abstractTableWriter.writeFile(string3);
                            if (stringArray == null) continue;
                            stringArray[i] = string3;
                        }
                    }
                    catch (IOException iOException) {
                        if (abstractTableWriter == null || ((String)(object = ((TableHTMLWriter)abstractTableWriter).getErrorString())).length() <= 0) continue;
                        CerentDialog.errorDialog((Component)this.uiToolkit.getApplicationFrame(), (String)object, "Error Saving Table");
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("Error Exporting file - " + exception.getMessage());
                        }
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
                break;
            }
            case 1: {
                File file;
                extensionFileFilter.addExtension("csv");
                extensionFileFilter.setDescription("CSV files");
                while (!bl2 && (file = PersistentFileChooserDialog.getFileUseChooser(this.uiToolkit.getApplicationFrame(), (byte)2, EXPORT_PATH, EXPORT_PROP, extensionFileFilter)) != null) {
                    try {
                        for (int i = 0; i < jTableArray.length; ++i) {
                            File file3;
                            JTable jTable = jTableArray[i];
                            string4 = jTable.getName() == null ? string : jTable.getName();
                            string4 = string4.replace(',', ' ');
                            abstractTableWriter = new TableCSVWriter(this.uiToolkit, jTable, bl, tableModelAdapter, string4, string2);
                            string3 = file.getAbsolutePath();
                            if (string5 != null) {
                                string5 = String.valueOf(i);
                            }
                            if ((file3 = new File(string3 = this.makeFilenameUnique(string3, string5, "csv"))).exists() && !this.continueFileOverwrite(string3) || !(bl2 = this.isValidFileName(string3))) continue;
                            abstractTableWriter.writeFile(string3);
                            if (stringArray == null) continue;
                            stringArray[i] = string3;
                        }
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("Error Exporting file - " + exception.getMessage());
                        }
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
                break;
            }
            case 2: {
                File file;
                extensionFileFilter.addExtension("tsv");
                extensionFileFilter.setDescription("TSV files");
                while (!bl2 && (file = PersistentFileChooserDialog.getFileUseChooser(this.uiToolkit.getApplicationFrame(), (byte)2, EXPORT_PATH, EXPORT_PROP, extensionFileFilter)) != null) {
                    try {
                        for (int i = 0; i < jTableArray.length; ++i) {
                            File file4;
                            JTable jTable = jTableArray[i];
                            string4 = jTable.getName() == null ? string : jTable.getName();
                            abstractTableWriter = new TableCSVWriter(this.uiToolkit, jTable, bl, tableModelAdapter, string4, string2);
                            abstractTableWriter.setDelimiter("\t");
                            abstractTableWriter.setDelimiterReplacement(" ");
                            string3 = file.getAbsolutePath();
                            if (string5 != null) {
                                string5 = String.valueOf(i);
                            }
                            if ((file4 = new File(string3 = this.makeFilenameUnique(string3, string5, "tsv"))).exists() && !this.continueFileOverwrite(string3) || !(bl2 = this.isValidFileName(string3))) continue;
                            abstractTableWriter.writeFile(string3);
                            if (stringArray == null) continue;
                            stringArray[i] = string3;
                        }
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("Error Exporting file - " + exception.getMessage());
                        }
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
                break;
            }
            default: {
                throw new Exception("An invalid export mode was requested.");
            }
        }
        if (!bl2) {
            return;
        }
        if (stringArray != null && stringArray.length > 1) {
            this.showFileNames(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String multiExportTables(int n, boolean bl, TableModelAdapter tableModelAdapter, String string, String[] stringArray, JTable[] jTableArray) throws Exception {
        Object object;
        String string2;
        String string3;
        String string4 = null;
        boolean bl2 = false;
        String string5 = null;
        if (jTableArray == null) {
            throw new Exception("A valid table could not be located for exporting.");
        }
        AbstractTableWriter abstractTableWriter = null;
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
        switch (n) {
            case 0: {
                string3 = "html";
                string2 = "HTML files";
                break;
            }
            case 1: 
            case 2: {
                string3 = "csv";
                string2 = "CSV files";
                break;
            }
            default: {
                Object var12_13 = null;
                Object var13_15 = null;
                throw new Exception("A valid table could not be located for exporting.");
            }
        }
        extensionFileFilter.addExtension(string3);
        extensionFileFilter.setDescription(string2);
        while (!bl2) {
            File file = PersistentFileChooserDialog.getFileUseChooser(this.uiToolkit.getApplicationFrame(), (byte)2, EXPORT_PATH, EXPORT_PROP, extensionFileFilter);
            if (file == null) continue;
            string4 = file.getAbsolutePath();
            object = new File(string4 = this.makeFilenameUnique(string4, null, string3));
            if (((File)object).exists() && !this.continueFileOverwrite(string4)) continue;
            bl2 = this.isValidFileName(string4);
        }
        switch (n) {
            case 0: {
                try {
                    if (!bl2) break;
                    for (int i = 0; i < jTableArray.length; ++i) {
                        object = jTableArray[i];
                        String string6 = string5 = string == null ? ((Component)object).getName() : string;
                        if (i == 0) {
                            abstractTableWriter = new TableHTMLWriter(this.uiToolkit, (JTable)object, bl, tableModelAdapter, string5, stringArray[i]);
                            abstractTableWriter.writeFileAndContinue(string4);
                            continue;
                        }
                        abstractTableWriter.addTable(bl, tableModelAdapter, (JTable)object, "", stringArray[i], false);
                    }
                    break;
                }
                catch (IOException iOException) {
                    if (abstractTableWriter == null || ((String)(object = ((TableHTMLWriter)abstractTableWriter).getErrorString())).length() <= 0) break;
                    CerentDialog.errorDialog((Component)this.uiToolkit.getApplicationFrame(), (String)object, "Error Saving Table");
                    break;
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Error Exporting file - " + exception.getMessage());
                    }
                    KDebug.printStackTrace((Throwable)exception);
                    break;
                }
                finally {
                    abstractTableWriter.closeFile();
                }
            }
            case 1: 
            case 2: {
                try {
                    if (!bl2) break;
                    for (int i = 0; i < jTableArray.length; ++i) {
                        object = jTableArray[i];
                        String string7 = string5 = string == null ? ((Component)object).getName() : string;
                        if (i == 0) {
                            string5 = string5.replace(',', ' ');
                            abstractTableWriter = new TableCSVWriter(this.uiToolkit, (JTable)object, bl, tableModelAdapter, string5, stringArray[i]);
                            if (n == 2) {
                                abstractTableWriter.setDelimiter("\t");
                                abstractTableWriter.setDelimiterReplacement(" ");
                            }
                            abstractTableWriter.writeFileAndContinue(string4);
                            continue;
                        }
                        abstractTableWriter.addTable(bl, tableModelAdapter, (JTable)object, "", stringArray[i], false);
                    }
                    break;
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Error Exporting file - " + exception.getMessage());
                    }
                    KDebug.printStackTrace((Throwable)exception);
                    break;
                }
            }
            default: {
                throw new Exception("An invalid export mode was requested.");
            }
        }
        if (!bl2) {
            return null;
        }
        if (string4 != null) {
            String[] stringArray2 = new String[]{string4};
            this.showFileNames(stringArray2);
        }
        return string4;
    }

    private String makeFilenameUnique(String string, String string2, String string3) {
        String string4 = null;
        String string5 = string2;
        if (string5 != null && "0".equals(string5)) {
            string5 = null;
        }
        if (string.endsWith(string3)) {
            if (string5 == null) {
                string4 = string;
            } else {
                int n = string.indexOf(string3);
                string4 = string.substring(0, n - 1) + string5 + "." + string3;
            }
        } else {
            string4 = string5 == null ? string + "." + string3 : string + string5 + "." + string3;
        }
        return string4;
    }

    protected boolean continueFileOverwrite(String string) {
        return CerentDialog.yesNoDialog(this.uiToolkit.getApplicationFrame(), "The file " + string + " already exists.\nDo you want to replace it?", "File Export");
    }

    private void showFileNames(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + "\n" + stringArray[i];
        }
        CerentDialog.infoDialog(this.uiToolkit.getApplicationFrame(), "Multiple files were created during export: " + string, "Export");
    }

    public void exportHtmlReport(int n, String string) throws Exception {
        String string2 = null;
        boolean bl = false;
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
        if (string == null) {
            throw new Exception("A valid report could not be found for exporting.");
        }
        HTMLReportWriter hTMLReportWriter = null;
        File file = null;
        switch (n) {
            case 0: {
                extensionFileFilter.addExtension("html");
                extensionFileFilter.setDescription("HTML files");
                while (!bl && (file = PersistentFileChooserDialog.getFileUseChooser(this.uiToolkit.getApplicationFrame(), (byte)2, EXPORT_PATH, EXPORT_PROP, extensionFileFilter)) != null) {
                    try {
                        hTMLReportWriter = new HTMLReportWriter(string);
                        string2 = file.getAbsolutePath().endsWith("html") ? file.getAbsolutePath() : file.getAbsolutePath() + "." + "html";
                        file = new File(string2);
                        if (file.exists() && !this.continueFileOverwrite(string2)) continue;
                        bl = this.isValidFileName(string2);
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("Error Exporting file - " + exception.getMessage());
                        }
                        KDebug.printStackTrace((Throwable)exception);
                    }
                    bl = this.isValidFileName(string2);
                }
                break;
            }
            default: {
                throw new Exception("An invalid export mode was requested.");
            }
        }
        if (!bl) {
            return;
        }
        this.uiToolkit.setSBText("Exporting ...");
        hTMLReportWriter.writeFile(string2);
        this.uiToolkit.setSBText("");
    }

    public static JTable[] getInnermostTables(TabbedView tabbedView) {
        Component component;
        dispTables = null;
        if (tabbedView != null && (component = tabbedView.getSelectedComponent()) != null && component instanceof Pane) {
            TabbedView tabbedView2 = ((Pane)component).getSubTabs();
            if (tabbedView2 != null) {
                ViewHelper.getInnermostTables(tabbedView2);
            }
            if (dispTables == null) {
                dispTables = ViewHelper.getTables((Container)component);
            }
        }
        if (dispTables == null || dispTables.size() == 0) {
            return null;
        }
        return dispTables.toArray(new JTable[0]);
    }

    private static List getTables(Container container) {
        ArrayList<Container> arrayList = new ArrayList<Container>();
        if (container instanceof JTable) {
            if (container instanceof UTable) {
                boolean bl = ((UTable)container).isExportable();
                if (bl) {
                    arrayList.add(container);
                }
            } else {
                arrayList.add(container);
            }
        } else {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof Container)) continue;
                arrayList.addAll(ViewHelper.getTables((Container)component));
            }
        }
        return arrayList;
    }

    private String getInnermostHtmlReport(TabbedView tabbedView) {
        Component component;
        if (tabbedView != null && (component = tabbedView.getSelectedComponent()) != null && component instanceof Pane) {
            TabbedView tabbedView2 = ((Pane)component).getSubTabs();
            if (tabbedView2 != null) {
                this.getInnermostHtmlReport(tabbedView2);
            }
            if (dispHtmlReport == null) {
                dispHtmlReport = ((Pane)component).getHtmlReport();
            }
        }
        return dispHtmlReport;
    }

    private ViewHelper(IUiToolkit iUiToolkit) {
        this.uiToolkit = iUiToolkit;
    }

    private String makeDottedString(IIpAddr iIpAddr) {
        byte[] byArray = iIpAddr.getAddr();
        return Integer.toString(0xFF & byArray[12]) + "." + Integer.toString(0xFF & byArray[13]) + "." + Integer.toString(0xFF & byArray[14]) + "." + Integer.toString(0xFF & byArray[15]);
    }
}

