/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IHoNum;
import cerent.util.KDebug;

public abstract class AbstractHoNum
implements IHoNum {
    static final int VC4_SIZE_2_STS_SIZE = 3;
    private volatile int hashCode = 0;
    protected static KDebug db = new KDebug("AbstractHoNum");

    public static int StsNum2Vc4(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 0 || (n - 1) % 3 != 0) {
            throw new IllegalArgumentException("The STS number " + n + " is invalid.");
        }
        return (n - 1) / 3 + 1;
    }

    public static int Vc4Num2Sts(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            throw new IllegalArgumentException("The VC4 number " + n + " is invalid.");
        }
        return (n - 1) * 3 + 1;
    }

    public abstract int getHoVal();

    public boolean equals(Object object) {
        if (object instanceof IHoNum) {
            IHoNum iHoNum = (IHoNum)object;
            return this.getFramingType() == iHoNum.getFramingType() && this.getIdlHoNum() == iHoNum.getIdlHoNum();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this.getFramingType();
            this.hashCode = n = 37 * n + this.getIdlHoNum();
        }
        return this.hashCode;
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            n = 1;
        } else if (object instanceof IHoNum) {
            IHoNum iHoNum = (IHoNum)object;
            n = AbstractHoNum.compareByType(this, iHoNum);
        } else {
            throw new ClassCastException("The object type " + object.getClass().getName() + " is not supported for comparisons.");
        }
        return n;
    }

    public static int compareByType(IHoNum iHoNum, IHoNum iHoNum2) {
        int n = iHoNum == null && iHoNum2 == null ? 0 : (iHoNum != null && iHoNum2 == null ? 1 : (iHoNum == null && iHoNum2 != null ? -1 : iHoNum.getFramingType() - iHoNum2.getFramingType()));
        return n;
    }

    public static boolean areSameType(IHoNum iHoNum, IHoNum iHoNum2) {
        boolean bl = true;
        if (iHoNum != null && iHoNum2 != null) {
            bl = AbstractHoNum.compareByType(iHoNum, iHoNum2) == 0;
        }
        return bl;
    }

    public String toString() {
        return new Integer(this.getHoVal()).toString();
    }

    public String dumpString() {
        return "HoVal-" + this.getHoVal() + ":Frame-" + this.getFramingType();
    }

    public abstract int toSonetSts();

    public static int GetNextLegalSts(int n, int n2) {
        int n3;
        int n4 = n2 + 1;
        if (n == 1 && (n3 = n2 % 3) != 0) {
            n4 += 3 - n3;
        }
        return n4;
    }

    @Override
    public short getIdlHoNum() {
        return (short)this.toSonetSts();
    }

    @Override
    public boolean isSameTimeslot(IHoNum iHoNum) {
        return this.toSonetSts() == ((AbstractHoNum)iHoNum).toSonetSts();
    }
}

