/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IMetrics;
import cerent.util.KDebug;
import cerent.util.LogLevel;
import cerent.util.Metrics;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class PerformanceMetrics {
    private static PerformanceMetrics instance = new PerformanceMetrics();
    private KDebug dbg = new MyDebug("PerformanceMetrics");
    private IMetrics defaultMetrics = new Metrics("Default", this.dbg, LogLevel.FINE);
    private Map metricsMap = Collections.synchronizedMap(new TreeMap());

    private PerformanceMetrics() {
    }

    public static PerformanceMetrics getInstance() {
        return instance;
    }

    public IMetrics getMetrics(String string, KDebug kDebug, LogLevel logLevel) {
        if ((kDebug.on() || IMetrics.allDb.on()) && (kDebug.getLogLevel().intValue() <= logLevel.intValue() || IMetrics.allDb.getLogLevel().intValue() <= logLevel.intValue())) {
            return new Metrics(string, kDebug, logLevel);
        }
        return this.defaultMetrics;
    }

    public IMetrics getMetrics(String string, KDebug kDebug, LogLevel logLevel, boolean bl) {
        if (kDebug.on() || IMetrics.allDb.on()) {
            if (bl) {
                IMetrics iMetrics = (IMetrics)this.metricsMap.get(string);
                if (iMetrics == null) {
                    iMetrics = new Metrics(string, kDebug, logLevel, bl);
                    this.metricsMap.put(string, iMetrics);
                }
                return iMetrics;
            }
            return new Metrics(string, kDebug, logLevel);
        }
        return this.defaultMetrics;
    }

    public class MyDebug
    extends KDebug {
        public MyDebug(String string) {
            super(string);
        }

        public final void instanceCount() {
            this.println("Metrics.instanceCount=> " + Metrics.instanceCount);
        }

        public final void dumpMetricsMap() {
            this.println("Metrics Map:");
            for (String string : PerformanceMetrics.this.metricsMap.keySet()) {
                Metrics metrics = (Metrics)PerformanceMetrics.this.metricsMap.get(string);
                this.println("name=> " + string + ", cumulative execution time=> " + metrics.getCumulativeTime());
            }
        }
    }
}

