/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.IModel;
import cerent.launcher.CmsClassLoader;
import cerent.util.ComparisonUtil;
import cerent.util.IBestEffortBean;
import cerent.util.IBestEffortEnum;
import cerent.util.IFieldAccess;
import cerent.util.KDebug;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.EqualityMatcher;
import cerent.util.matcher.NotMatcher;
import com.cisco.ctc.core.CoreReflectionUtil;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.Streamable;

public class ReflectionUtil
extends CoreReflectionUtil {
    protected static final String CERENT_PREFIX = "cerent.";
    public static final String[] StringArrayTemplate = new String[0];
    public static final Class[] ClassArrayTemplate = new Class[0];
    public static final Field[] FieldArrayTemplate = new Field[0];
    public static final Method[] MethodArrayTemplate = new Method[0];
    public static final NoUiMatcher noUiMatcher = new NoUiMatcher();
    public static final InheritanceComparator inhComparator = new InheritanceComparator();
    public static final NotMatcher NoObjectClassMatcher = new NotMatcher("NoObjectClassMatcher", new EqualityMatcher("", java.lang.Object.class));
    public static final String ProductPrefix = "15";
    public static final String UnspecifiedNeType = "unspecified";
    private static final String IDL_IMPL = "org.omg.CORBA.portable.IDLEntity";
    public static final int IDL_STRUCT = 0;
    public static final int IDL_ENUM = 1;
    public static final int IDL_UNION = 2;
    public static final int IDL_UNKNOWN = 3;
    public static final int NOT_IDL = 4;
    private static final String FROM_INT = "from_int";
    private static final String DISCRIMINATOR = "_discriminator";
    public static final String NO_ARGUMENTS = "NO_ARGUMENTS";
    private static HashMap nonloadableClasses;
    private static HashMap primitiveClasses;
    private static HashMap unprimitiveClasses;
    private static HashMap subclasses;
    public static final int DIR_DONT_CARE = 0;
    public static final int DIR_ENCODE = 1;
    public static final int DIR_DECODE = 2;
    protected static final int PASS_COUNT = 1;
    protected static final int PASS_COMPUTE = 2;
    private static final char PRIM_NORM = 'a';
    public static final int BYTE_TYPE = 24;
    public static final int CHAR_TYPE = 2;
    public static final int DOUBLE_TYPE = 3;
    public static final int FLOAT_TYPE = 5;
    public static final int INT_TYPE = 8;
    public static final int LONG_TYPE = 11;
    public static final int SHORT_TYPE = 18;
    public static final int BOOLEAN_TYPE = 14;
    protected static final String[] SupportedIfs;

    protected ReflectionUtil() {
    }

    public static Method getMethodWithSignature(Class clazz, String string, String[] stringArray) {
        int n;
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equals(NO_ARGUMENTS)) {
            stringArray = new String[]{};
        }
        Class[] classArray = null;
        try {
            classArray = ReflectionUtil.forName((java.lang.Object)clazz, stringArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        if (method != null && ((n = method.getModifiers()) & 1) == 0) {
            method = null;
        }
        return method;
    }

    public static boolean isSameClass(Class clazz, Class clazz2) {
        if (clazz == null && clazz2 == null) {
            return true;
        }
        if (clazz == null ^ clazz2 == null) {
            return false;
        }
        if (clazz.isInterface()) {
            return ReflectionUtil.doesImplement(clazz2, clazz);
        }
        if (clazz2.isInterface()) {
            return ReflectionUtil.doesImplement(clazz, clazz2);
        }
        Class[] classArray = ReflectionUtil.superclasses(clazz, NoObjectClassMatcher);
        Class[] classArray2 = ReflectionUtil.superclasses(clazz2, NoObjectClassMatcher);
        int n = classArray.length;
        int n2 = classArray2.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!classArray[i].equals(classArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static Class[] superclasses(Class clazz, AbstractMatcher abstractMatcher) {
        if (clazz == null) {
            Class[] classArray = new Class[]{clazz};
            return classArray;
        }
        ArrayList arrayList = new ArrayList();
        while (clazz != null && (abstractMatcher == null || abstractMatcher.doesMatch(clazz))) {
            arrayList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(ClassArrayTemplate);
    }

    protected static void _superinterfaces(Class clazz, AbstractMatcher abstractMatcher, Set set) {
        if (set.contains(clazz)) {
            return;
        }
        while (clazz != null && !clazz.equals(java.lang.Object.class) && (abstractMatcher == null || abstractMatcher.doesMatch(clazz))) {
            if (clazz.isInterface()) {
                set.add(clazz);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                ReflectionUtil._superinterfaces(classArray[i], abstractMatcher, set);
            }
            if (clazz.isInterface()) break;
            clazz = clazz.getSuperclass();
        }
    }

    public static Class[] superinterfaces(Class clazz, AbstractMatcher abstractMatcher) {
        HashSet hashSet = new HashSet();
        ReflectionUtil._superinterfaces(clazz, abstractMatcher, hashSet);
        return hashSet.toArray(ClassArrayTemplate);
    }

    public static Class[] superclasses(java.lang.Object object, String string, AbstractMatcher abstractMatcher) throws ClassNotFoundException {
        return ReflectionUtil.superclasses(ReflectionUtil.forName(object, string), abstractMatcher);
    }

    public static boolean isSuperclassOf(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return false;
        }
        Class[] classArray = ReflectionUtil.superclasses(clazz, NoObjectClassMatcher);
        int n = classArray == null ? 0 : classArray.length;
        boolean bl = false;
        int n2 = 0;
        while (!bl & n2 < n) {
            if (classArray[n2] != null) {
                bl = classArray[n2].equals(clazz2);
            }
            ++n2;
        }
        return bl;
    }

    public static boolean isImplementedInSuperclass(Class clazz, Class clazz2, String string, Class[] classArray, boolean bl) {
        Class[] classArray2 = ReflectionUtil.superclasses(clazz, NoObjectClassMatcher);
        int n = classArray2.length;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            Class clazz3 = classArray2[i];
            if (clazz3.equals(clazz) || clazz2 != null && !clazz3.equals(clazz2)) continue;
            try {
                Method method = bl ? clazz3.getDeclaredMethod(string, classArray) : clazz3.getMethod(string, classArray);
                bl2 = true;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2;
    }

    public static boolean isImplementedInSuperclass(Class clazz, Class clazz2, String string, Class[] classArray) {
        return ReflectionUtil.isImplementedInSuperclass(clazz, clazz2, string, classArray, true);
    }

    public static boolean isImplementedInSuperclass(Class clazz, Class clazz2, Method method, boolean bl) {
        return ReflectionUtil.isImplementedInSuperclass(clazz, clazz2, method.getName(), method.getParameterTypes(), bl);
    }

    public static boolean isImplementedInSuperclass(Class clazz, Class clazz2, Method method) {
        return ReflectionUtil.isImplementedInSuperclass(clazz, clazz2, method.getName(), method.getParameterTypes(), true);
    }

    public static List subclasses(java.lang.Object object, String string, AbstractMatcher abstractMatcher, AbstractMatcher abstractMatcher2) {
        if (subclasses == null) {
            ReflectionUtil.initializeSubclasses(object, abstractMatcher, abstractMatcher2);
        }
        return (List)subclasses.get(string);
    }

    private static java.lang.Object determineLoader(java.lang.Object object) {
        java.lang.Object object2 = null;
        ClassLoader classLoader = null;
        if (object == null) {
            object2 = ReflectionUtil.class;
        } else if (object instanceof Class) {
            object2 = (Class)object;
            classLoader = ((Class)object2).getClassLoader();
        } else {
            object2 = object instanceof ClassLoader ? (ClassLoader)object : object.getClass();
        }
        return object2;
    }

    protected static void initializeSubclasses(java.lang.Object object, AbstractMatcher abstractMatcher, AbstractMatcher abstractMatcher2) {
        subclasses = new HashMap();
        java.lang.Object object2 = ReflectionUtil.determineLoader(object);
        Class clazz = null;
        ClassLoader classLoader = null;
        if (object2 instanceof Class) {
            clazz = (Class)object2;
        } else if (object2 instanceof ClassLoader) {
            classLoader = (ClassLoader)object2;
        }
        if (classLoader == null && clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader instanceof URLClassLoader) {
            String[] stringArray = ReflectionUtil.getClassNames((URLClassLoader)classLoader);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    if (abstractMatcher != null && !abstractMatcher.doesMatch(string)) continue;
                    Class clazz2 = ReflectionUtil.loadClass((java.lang.Object)object2, (String)string);
                    if (abstractMatcher2 != null && !abstractMatcher2.doesMatch(clazz2)) continue;
                    Class[] classArray = ReflectionUtil.superclasses(object, string, NoObjectClassMatcher);
                    for (int j = 0; j < classArray.length; ++j) {
                        LinkedList linkedList;
                        String string2 = classArray[j].getName();
                        if (string2.equals(string)) continue;
                        if (!subclasses.containsKey(string2)) {
                            linkedList = new LinkedList();
                            linkedList.add(string);
                            subclasses.put(string2, linkedList);
                            continue;
                        }
                        linkedList = (LinkedList)subclasses.get(string2);
                        linkedList.add(string);
                    }
                    continue;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    KDebug.printStackTrace((Throwable)unsatisfiedLinkError);
                    continue;
                }
                catch (IllegalAccessError illegalAccessError) {
                    KDebug.printStackTrace((Throwable)illegalAccessError);
                    continue;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    KDebug.printStackTrace((Throwable)exceptionInInitializerError);
                    continue;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    KDebug.printStackTrace((Throwable)noClassDefFoundError);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
    }

    public static void loadClasses(Set set, java.lang.Object object, AbstractMatcher abstractMatcher, AbstractMatcher abstractMatcher2) {
        java.lang.Object object2 = ReflectionUtil.determineLoader(object);
        Class clazz = null;
        ClassLoader classLoader = null;
        if (object2 instanceof Class) {
            clazz = (Class)object2;
        } else if (object2 instanceof ClassLoader) {
            classLoader = (ClassLoader)object2;
        }
        if (classLoader == null && clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (classLoader instanceof URLClassLoader) {
            String[] stringArray = ReflectionUtil.getClassNames((URLClassLoader)classLoader);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    if (abstractMatcher != null && !abstractMatcher.doesMatch(string)) continue;
                    Class clazz2 = ReflectionUtil.loadClass((java.lang.Object)object2, (String)string);
                    if (abstractMatcher2 != null && !abstractMatcher2.doesMatch(clazz2)) continue;
                    set.add(clazz2);
                    continue;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    KDebug.printStackTrace((Throwable)unsatisfiedLinkError);
                    continue;
                }
                catch (IllegalAccessError illegalAccessError) {
                    KDebug.printStackTrace((Throwable)illegalAccessError);
                    continue;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    KDebug.printStackTrace((Throwable)exceptionInInitializerError);
                    continue;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    KDebug.printStackTrace((Throwable)noClassDefFoundError);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
    }

    public static void subinterfaces(Set set, java.lang.Object object, AbstractMatcher abstractMatcher, Class clazz) {
        IfExtensionMatcher ifExtensionMatcher = new IfExtensionMatcher(clazz, true);
        if (object == null) {
            object = clazz;
        }
        ReflectionUtil.loadClasses(set, object, abstractMatcher, ifExtensionMatcher);
    }

    public static boolean isAccessor(Method method) {
        return method != null && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType()) && (method.getModifiers() & 8) == 0;
    }

    public static boolean isMutator(Method method) {
        return method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType()) && (method.getModifiers() & 8) == 0;
    }

    private static String[] getArgTypeNames(Class[] classArray) {
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    private static boolean doesMatch(String[] stringArray, String[] stringArray2) {
        return ReflectionUtil.isEqual(stringArray, stringArray2);
    }

    private static boolean isEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray == null ^ stringArray2 == null) {
            return false;
        }
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        if (stringArray.length == 0 && stringArray2.length == 0) {
            return true;
        }
        java.lang.Object[] objectArray = new java.lang.Object[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        java.lang.Object[] objectArray2 = new java.lang.Object[stringArray2.length];
        System.arraycopy(stringArray2, 0, objectArray2, 0, stringArray2.length);
        return Arrays.equals(objectArray, objectArray2);
    }

    public static boolean isIdlEntity(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof IDLEntity) {
            bl = true;
        }
        return bl;
    }

    public static boolean isIdlClass(Class clazz) {
        boolean bl = false;
        if (ReflectionUtil.isIdlHolderClass(clazz) || ReflectionUtil.isIdlValueClass(clazz)) {
            bl = true;
        }
        return bl;
    }

    public static int getIdlType(java.lang.Object object) {
        int n = 3;
        if (ReflectionUtil.isIdlEntity(object)) {
            java.lang.Object object2;
            n = 0;
            boolean bl = false;
            try {
                object2 = new Class[]{Integer.TYPE};
                Method method = object.getClass().getMethod(FROM_INT, (Class<?>)object2);
                n = 1;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = true;
            }
            if (bl) {
                try {
                    object2 = object.getClass().getMethod(DISCRIMINATOR, new Class[0]);
                    n = 2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    n = 0;
                }
            }
        } else {
            n = 4;
        }
        return n;
    }

    public static boolean isIdlValueClass(Class clazz) {
        boolean bl = false;
        try {
            if (ReflectionUtil.doesImplement(clazz, ReflectionUtil.forName(ReflectionUtil.class, IDL_IMPL))) {
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isIdlHolderClass(Class clazz) {
        boolean bl = ReflectionUtil.doesImplement(clazz, Streamable.class);
        if (bl) {
            int n = 1;
            Field[] fieldArray = ReflectionUtil.getMatchingFields(clazz, n, n);
            boolean bl2 = bl = fieldArray.length == 1;
            if (bl) {
                Class<?> clazz2 = fieldArray[0].getType();
                Constructor constructor = null;
                try {
                    constructor = clazz.getConstructor(clazz2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                bl = constructor != null;
            }
        }
        return bl;
    }

    public static boolean isIdlInterfaceClass(Class clazz) {
        return ReflectionUtil.doesImplement(clazz, Object.class);
    }

    public static boolean doesExtend(Class clazz, Class clazz2) {
        if (clazz2 == null || clazz == null) {
            return false;
        }
        boolean bl = !clazz2.isInterface() && clazz2.isAssignableFrom(clazz);
        return bl;
    }

    public static boolean doesImplement(Class clazz, Class clazz2) {
        if (clazz2 == null || clazz == null) {
            return false;
        }
        boolean bl = clazz2.isInterface() && clazz2.isAssignableFrom(clazz);
        return bl;
    }

    public static boolean isArrayClass(Class clazz) {
        return clazz.isArray();
    }

    public static boolean isMapClass(Class clazz) {
        return ReflectionUtil.doesImplement(clazz, Map.class);
    }

    public static boolean isCollectionClass(Class clazz) {
        return ReflectionUtil.doesImplement(clazz, Collection.class) || ReflectionUtil.doesImplement(clazz, Iterator.class);
    }

    public static boolean isAbstractClass(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isEnumClass(Class clazz) {
        boolean bl = ReflectionUtil.doesImplement(clazz, IBestEffortEnum.class);
        String string = clazz.getName();
        Field[] fieldArray = clazz.getFields();
        boolean bl2 = fieldArray.length > 0;
        int n = 0;
        for (int i = 0; bl2 && i < fieldArray.length; ++i) {
            boolean bl3;
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            boolean bl4 = bl3 = (n2 & 0x10) != 0 || bl;
            if (bl3 && (n2 & 8) != 0 && (n2 & 1) != 0) {
                Class<?> clazz2 = field.getType();
                String string2 = clazz2.getName();
                String string3 = field.getName();
                if (clazz2.equals(Long.TYPE) && string3.equals("serialVersionUID")) continue;
                boolean bl5 = bl2 = string2.equals("int") || string2.equals(string);
                if (bl2) {
                    ++n;
                    continue;
                }
                if (!bl) continue;
                bl2 = true;
                continue;
            }
            if (bl) continue;
            bl2 = false;
        }
        return bl2 && n > 0;
    }

    public static boolean isStructClass(Class clazz) {
        String string = clazz.getName();
        Field[] fieldArray = clazz.getFields();
        boolean bl = fieldArray.length > 0;
        int n = 0;
        for (int i = 0; bl && i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            boolean bl2 = (n2 & 8) == 0;
            if (bl2 && (n2 & 1) != 0) {
                ++n;
                continue;
            }
            if (!bl2) {
                if (!field.getType().equals(Long.TYPE) || !field.getName().equals("serialVersionUID")) continue;
                continue;
            }
            bl = false;
        }
        return bl && n > 0;
    }

    public static Field[] getStructFields(Class clazz) {
        String string = clazz.getName();
        Field[] fieldArray = clazz.getFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if ((n & 8) != 0 || (n & 1) == 0) continue;
            arrayList.add(field);
        }
        return arrayList.toArray(FieldArrayTemplate);
    }

    public static Class[] getStructFieldTypes(Class clazz) {
        String string = clazz.getName();
        Field[] fieldArray = clazz.getFields();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if ((n & 8) != 0 || (n & 1) == 0) continue;
            arrayList.add(field.getType());
        }
        return arrayList.toArray(ClassArrayTemplate);
    }

    public static boolean isBeanClass(Class clazz, int n) {
        if (ReflectionUtil.doesImplement(clazz, IBestEffortEnum.class)) {
            return false;
        }
        if (ReflectionUtil.doesImplement(clazz, IBestEffortBean.class)) {
            return true;
        }
        String string = clazz.getName();
        Method[] methodArray = clazz.getMethods();
        boolean bl = methodArray.length > 0;
        int n2 = 0;
        for (int i = 0; bl && i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n3 = method.getModifiers();
            if ((n3 & 8) == 0 && (n3 & 1) != 0) {
                if (ReflectionUtil.doesDeclareMethod(java.lang.Object.class, method) || ReflectionUtil.doesImplement(clazz, Comparable.class) && ReflectionUtil.doesDeclareMethod(Comparable.class, method)) continue;
                ++n2;
                bl = ReflectionUtil.isBeanAccessor(method) || ReflectionUtil.isBeanMutator(method);
                continue;
            }
            bl = false;
        }
        boolean bl2 = bl = bl && n2 > 0;
        if (bl) {
            bl = n != 2 || !clazz.isInterface();
        }
        return bl;
    }

    public static boolean isBeanClass(Class clazz) {
        return ReflectionUtil.isBeanClass(clazz, 0);
    }

    public static boolean isSymmetricBean(Class clazz) {
        boolean bl = true;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Method[] methodArray = ReflectionUtil.getBeanMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            String string;
            java.lang.Object object = methodArray[i];
            if (ReflectionUtil.isBeanAccessor((Method)object)) {
                string = ((Method)object).getName();
                if (string.startsWith("get")) {
                    hashMap.put(string.substring(3), ((Method)object).getReturnType());
                    continue;
                }
                if (!string.startsWith("is")) continue;
                hashMap.put(string.substring(2), ((Method)object).getReturnType());
                continue;
            }
            if (!ReflectionUtil.isBeanMutator((Method)object) || !(string = ((Method)object).getName()).startsWith("set")) continue;
            hashMap2.put(string.substring(3), ((Method)object).getParameterTypes()[0]);
        }
        for (java.lang.Object object : hashMap.keySet()) {
            if (!hashMap2.containsKey(object)) {
                bl = false;
                break;
            }
            if (hashMap.get(object) == hashMap2.get(object)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static Method[] getBeanMethods(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        return ReflectionUtil.getBeanMethods(clazz, methodArray, true, false);
    }

    public static Method[] getBeanMethods(Class clazz, Method[] methodArray, boolean bl, boolean bl2) {
        Method[] methodArray2 = null;
        int n = 0;
        int n2 = 0;
        for (int i = 1; i <= 2; ++i) {
            if (i == 2) {
                methodArray2 = new Method[n];
            }
            for (int j = 0; j < methodArray.length; ++j) {
                Method method = methodArray[j];
                int n3 = method.getModifiers();
                if ((n3 & 8) != 0 || (n3 & 1) == 0 || ReflectionUtil.doesDeclareMethod(java.lang.Object.class, method) || ReflectionUtil.doesImplement(clazz, Comparable.class) && ReflectionUtil.doesDeclareMethod(Comparable.class, method)) continue;
                Class<?> clazz2 = null;
                if ((bl || bl2) && ReflectionUtil.isBeanAccessor(method)) {
                    clazz2 = method.getReturnType();
                } else if ((bl || !bl2) && ReflectionUtil.isBeanMutator(method)) {
                    clazz2 = method.getParameterTypes()[0];
                }
                if (clazz2 == null || clazz2.equals(clazz)) continue;
                if (i == 1) {
                    ++n;
                    continue;
                }
                methodArray2[n2++] = method;
            }
        }
        if (methodArray2 == null) {
            methodArray2 = MethodArrayTemplate;
        }
        return methodArray2;
    }

    public static Class[] getBeanMethodTypes(Class clazz) {
        String string = clazz.getName();
        Method[] methodArray = clazz.getMethods();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if ((n & 8) != 0 || (n & 1) == 0 || ReflectionUtil.doesDeclareMethod(java.lang.Object.class, method) || ReflectionUtil.doesImplement(clazz, Comparable.class) && ReflectionUtil.doesDeclareMethod(Comparable.class, method)) continue;
            Class<?> clazz2 = null;
            if (ReflectionUtil.isBeanAccessor(method)) {
                clazz2 = method.getReturnType();
            } else if (ReflectionUtil.isBeanMutator(method)) {
                clazz2 = method.getParameterTypes()[0];
            }
            if (clazz2 == null || clazz2.equals(clazz)) continue;
            arrayList.add(clazz2);
        }
        return arrayList.toArray(ClassArrayTemplate);
    }

    public static boolean isBeanAccessor(Method method) {
        return ReflectionUtil.isAccessor(method);
    }

    public static boolean isBeanMutator(Method method) {
        return ReflectionUtil.isMutator(method);
    }

    protected static boolean doesDeclareMethod(Class clazz, Method method) {
        boolean bl = false;
        try {
            clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static Field[] getMatchingFields(Class clazz, AbstractMatcher abstractMatcher) {
        return ReflectionUtil.getMatchingFields(clazz, 8, 0, true, null, abstractMatcher);
    }

    public static Field[] getMatchingFields(Class clazz, int n, int n2, boolean bl, AbstractMatcher abstractMatcher) {
        return ReflectionUtil.getMatchingFields(clazz, n, n2, bl, abstractMatcher, null);
    }

    public static Field[] getMatchingFields(Class clazz, int n, int n2, boolean bl, AbstractMatcher abstractMatcher, AbstractMatcher abstractMatcher2) {
        return ReflectionUtil.getMatchingFields(clazz, null, n, n2, bl, abstractMatcher, abstractMatcher2);
    }

    public static Field[] getMatchingFields(Class clazz, IFieldAccess iFieldAccess, int n, int n2, boolean bl, AbstractMatcher abstractMatcher, AbstractMatcher abstractMatcher2) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Class[] classArray = new Class[]{clazz};
        if (bl) {
            classArray = ReflectionUtil.superclasses(clazz, abstractMatcher);
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            Field[] fieldArray = iFieldAccess == null ? clazz2.getDeclaredFields() : iFieldAccess.getDeclaredFields(clazz2);
            for (int j = 0; j < fieldArray.length; ++j) {
                Field field = fieldArray[j];
                int n3 = field.getModifiers();
                if ((n3 & n) != (n2 & n) || abstractMatcher2 != null && !abstractMatcher2.doesMatch(field)) continue;
                arrayList.add(field);
            }
        }
        return arrayList.toArray(FieldArrayTemplate);
    }

    public static Field[] getMatchingFields(Class clazz, int n, int n2) {
        return ReflectionUtil.getMatchingFields(clazz, n, n2, false, null);
    }

    public static Class getPrimitiveRepresentedClass(Class clazz) {
        Field[] fieldArray = clazz.getFields();
        Class clazz2 = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if ((n & 8) == 0 || (n & 1) == 0 || (n & 0x10) == 0 || !field.getClass().equals(Class.class) || !field.getName().equals("TYPE")) continue;
            try {
                clazz2 = (Class)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {}
            break;
        }
        return clazz2;
    }

    public static String[] getClassNames(URLClassLoader uRLClassLoader) {
        return ReflectionUtil.getClassNames(uRLClassLoader.getURLs());
    }

    public static String[] getClassNames(URL[] uRLArray) {
        int n = uRLArray.length;
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            URL uRL = uRLArray[i];
            try {
                if (ReflectionUtil.isJarLike(uRL)) {
                    ReflectionUtil.addZipClasses(hashSet, uRL);
                    continue;
                }
                ReflectionUtil.addDirectoryClasses(hashSet, uRL);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hashSet.toArray(new String[0]);
    }

    protected static boolean isJarLike(URL uRL) {
        String string = uRL.toString();
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addZipClasses(Collection collection, URL uRL) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(uRL.openStream());
            while (zipInputStream.available() != 0) {
                String string;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null || !(string = zipEntry.getName()).endsWith(".class")) continue;
                ReflectionUtil.addRawEntry(collection, string);
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    protected static void addDirectoryClasses(Collection collection, URL uRL) {
        ReflectionUtil.addDirectoryClasses(collection, new File(uRL.getFile()));
    }

    protected static void addDirectoryClasses(Collection collection, File file) {
        ReflectionUtil.addDirectoryClasses(collection, file, file.toString());
    }

    protected static void addDirectoryClasses(Collection collection, File file, String string) {
        File[] fileArray = file.listFiles();
        String string2 = file.toString();
        int n = string.length() + 1;
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                ReflectionUtil.addDirectoryClasses(collection, file2, string);
                continue;
            }
            String string3 = file2.toString();
            if (!string3.endsWith(".class")) continue;
            string3 = string3.substring(n);
            ReflectionUtil.addRawEntry(collection, string3);
        }
    }

    protected static void addRawEntry(Collection collection, String string) {
        string = string.replace('/', '.');
        string = string.replace('\\', '.');
        int n = string.lastIndexOf(".class");
        string = string.substring(0, n);
        collection.add(string);
    }

    public static boolean isNeTypeUnspecified(String string) {
        boolean bl = string == null || string.length() == 0 || string.equals(UnspecifiedNeType);
        return bl;
    }

    public static String getNeType(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        String string = "";
        String string2 = "";
        if (classLoader instanceof CmsClassLoader) {
            return UnspecifiedNeType;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        java.lang.Object object = uRLClassLoader.getURLs();
        for (int i = 0; i < ((URL[])object).length; ++i) {
            URL uRL = object[i];
            String string3 = uRL.toString();
            int n = string3.lastIndexOf("/");
            String string4 = string3 = n < 0 ? string3 : string3.substring(n + 1);
            if (string3.indexOf(ProductPrefix) < 0) continue;
            string = string3;
            break;
        }
        if (string.length() == 0) {
            string2 = "ctc.netype";
            string = System.getProperty("ctc.netype");
            if (string == null) {
                string = "";
            }
        }
        string = ReflectionUtil.stripNeType(string);
        if ((string = ReflectionUtil.processNeType(string)).length() == 0) {
            object = "getNeType() warning: NE type could not be determined by classloader/property " + string2 + ". CTC ELE 'tools' must set the ctc.netype property";
            throw new IllegalStateException((String)object);
        }
        return string;
    }

    protected static String stripNeType(String string) {
        if (string != null && string.length() > 0) {
            char c;
            int n = string.indexOf(ProductPrefix);
            n = n < 0 ? 0 : (n += ProductPrefix.length());
            if (n < 0) {
                return string;
            }
            int n2 = n;
            int n3 = n += 2;
            int n4 = string.length();
            for (int i = n; i < n4 && Character.isLetterOrDigit(c = string.charAt(i)); ++i) {
                ++n3;
            }
            string = string.substring(n2, n3);
        }
        return string;
    }

    public static String processNeType(String string) {
        int n = -1;
        n = string.lastIndexOf("454SDH");
        if (n >= 0) {
            string = string.replaceAll("454SDH", "455");
        }
        string = string.toLowerCase();
        return string;
    }

    protected static String toJvmClassname(String string) {
        String string2;
        int n = 0;
        int n2 = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n;
        }
        while (string.startsWith("[")) {
            string = string.substring(1);
            ++n2;
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        boolean bl = (string2 = (String)primitiveClasses.get(string)) != null;
        int n3 = n + n2;
        if (bl) {
            string = string2;
        } else {
            boolean bl2 = bl = unprimitiveClasses.get(string) != null;
        }
        if (n3 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append("[");
            }
            if (!bl && n3 > 0) {
                stringBuffer.append("L");
                stringBuffer.append(string);
                stringBuffer.append(";");
            } else {
                stringBuffer.append(string);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String fromJvmClassname(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = 0;
        while (string.startsWith("[")) {
            string = string.substring(1);
            ++n;
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            string = string.substring(1, string.length() - 1);
        }
        boolean bl = (string2 = (String)unprimitiveClasses.get(string)) != null;
        int n2 = n;
        if (bl) {
            string = string2;
        } else {
            boolean bl2 = bl = primitiveClasses.get(string) != null;
        }
        if (n2 > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("[]");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static Class forName(java.lang.Object object, String string) throws ClassNotFoundException {
        Class clazz = (Class)nonloadableClasses.get(string = ReflectionUtil.toJvmClassname(string));
        if (clazz == null) {
            java.lang.Object object2 = ReflectionUtil.determineLoader(object);
            clazz = ReflectionUtil.loadClass((java.lang.Object)object2, (String)string);
        }
        return clazz;
    }

    public static Class[] forName(java.lang.Object object, String[] stringArray) throws ClassNotFoundException {
        Class[] classArray = new Class[stringArray == null ? 0 : stringArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = ReflectionUtil.forName(object, stringArray[i]);
        }
        return classArray;
    }

    public static int categorizePrimitive(Class clazz) {
        int n = -1;
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            char c = string.charAt(0);
            if (c == 'b') {
                c = string.charAt(1);
            }
            n = c - 97;
        }
        return n;
    }

    protected static String getLastSegment(String string, String string2) {
        int n = string.lastIndexOf(string2);
        return n < 0 ? string : string.substring(n + 1);
    }

    protected static String getLastSegment(String string) {
        return ReflectionUtil.getLastSegment(string, ".");
    }

    public static String getSignatureString(Method method, boolean bl, boolean bl2) {
        return ReflectionUtil.getSignatureString(method.getReturnType(), method.getDeclaringClass(), method.getName(), method.getParameterTypes(), bl, bl2);
    }

    public static String getSignatureString(Class clazz, Class clazz2, String string, Class[] classArray, boolean bl, boolean bl2) {
        java.lang.Object object;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string2 = ReflectionUtil.fromJvmClassname(clazz.getName());
            string2 = bl2 ? string2 : ReflectionUtil.getLastSegment(string2);
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        if (bl2 && clazz2 != null) {
            object = clazz2.getName() + "." + string;
            stringBuffer.append((String)object);
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append("(");
        object = classArray;
        for (int i = 0; i < ((Class[])object).length; ++i) {
            Class clazz3 = object[i];
            if (i > 0) {
                stringBuffer.append(", ");
            }
            string2 = ReflectionUtil.fromJvmClassname(clazz3.getName());
            string2 = bl2 ? string2 : ReflectionUtil.getLastSegment(string2);
            stringBuffer.append(string2);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getClassName(java.lang.Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Proxy) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            Class<?>[] classArray = object.getClass().getInterfaces();
            int n = classArray == null ? 0 : classArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = classArray[i];
                String string = clazz.getName();
                int n2 = string.lastIndexOf(".");
                if (n2 >= 0) {
                    string = string.substring(n2 + 1);
                }
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
            }
            return invocationHandler.getClass().getName() + " Proxy to IFs {" + stringBuffer.toString() + "}";
        }
        return object.getClass().getName();
    }

    public static boolean isCerentType(String string) {
        return string != null && string.startsWith(CERENT_PREFIX);
    }

    public static boolean isCerentType(Class clazz) {
        return clazz != null && ReflectionUtil.isCerentType(clazz.getName());
    }

    public static boolean isSerializable(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        boolean bl = false;
        if (clazz.isPrimitive() || String.class.equals(clazz)) {
            bl = true;
        } else if (ReflectionUtil.isMapClass(clazz) || ReflectionUtil.isCollectionClass(clazz)) {
            bl = true;
        } else if (IModel.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (noUiMatcher.doesMatch(clazz.getName())) {
            bl = Serializable.class.isAssignableFrom(clazz) || Externalizable.class.isAssignableFrom(clazz);
        }
        return bl;
    }

    public static void getTypes(Method[] methodArray, Set set, boolean bl, AbstractMatcher abstractMatcher) {
        int n = methodArray == null ? 0 : methodArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray[i];
            ReflectionUtil.getTypes(method, set, bl, abstractMatcher);
        }
    }

    public static void getTypes(Method method, Set set, boolean bl, AbstractMatcher abstractMatcher) {
        Class<?> clazz = method.getReturnType();
        if (abstractMatcher == null || abstractMatcher.doesMatch(clazz)) {
            ReflectionUtil._getTypes(clazz, set, bl, abstractMatcher);
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            clazz = classArray[i];
            if (abstractMatcher != null && !abstractMatcher.doesMatch(clazz)) continue;
            ReflectionUtil._getTypes(clazz, set, bl, abstractMatcher);
        }
    }

    protected static void _getTypes(Class clazz, Set set, boolean bl, AbstractMatcher abstractMatcher) {
        if (clazz == null || clazz.equals(Void.TYPE)) {
            return;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (abstractMatcher == null || abstractMatcher.doesMatch(clazz)) {
            set.add(clazz);
        }
        if (bl) {
            Class[] classArray = null;
            if (clazz.isInterface()) {
                classArray = ReflectionUtil.superinterfaces(clazz, abstractMatcher);
            } else if (!clazz.isPrimitive()) {
                classArray = ReflectionUtil.superclasses(clazz, abstractMatcher);
            }
            int n = classArray == null ? 0 : classArray.length;
            for (int i = 0; i < n; ++i) {
                set.add(classArray[i]);
            }
        }
    }

    public static Collection sort(Method[] methodArray) {
        int n = methodArray == null ? 0 : methodArray.length;
        MethodComparator methodComparator = MethodComparator.instance();
        TreeSet<Method> treeSet = new TreeSet<Method>(methodComparator);
        for (int i = 0; i < n; ++i) {
            treeSet.add(methodArray[i]);
        }
        return treeSet;
    }

    static {
        subclasses = null;
        SupportedIfs = new String[]{"cerent.util.ILoNum", "cerent.util.IHoNum", "cerent.util.IHoLoNum"};
        primitiveClasses = new HashMap();
        primitiveClasses.put("byte", "B");
        primitiveClasses.put("char", "C");
        primitiveClasses.put("double", "D");
        primitiveClasses.put("float", "F");
        primitiveClasses.put("int", "I");
        primitiveClasses.put("long", "J");
        primitiveClasses.put("short", "S");
        primitiveClasses.put("boolean", "Z");
        unprimitiveClasses = new HashMap();
        Set set = primitiveClasses.keySet();
        for (String string : set) {
            String string2 = (String)primitiveClasses.get(string);
            unprimitiveClasses.put(string2, string);
        }
        nonloadableClasses = new HashMap();
        nonloadableClasses.put("B", Byte.TYPE);
        nonloadableClasses.put("C", Character.TYPE);
        nonloadableClasses.put("D", Double.TYPE);
        nonloadableClasses.put("F", Float.TYPE);
        nonloadableClasses.put("I", Integer.TYPE);
        nonloadableClasses.put("J", Long.TYPE);
        nonloadableClasses.put("S", Short.TYPE);
        nonloadableClasses.put("Z", Boolean.TYPE);
        nonloadableClasses.put("void", Void.TYPE);
    }

    public static class IfExtensionMatcher
    extends AbstractMatcher {
        private Class ifClass;
        private boolean mustBeIf;

        public IfExtensionMatcher(Class clazz, boolean bl) {
            this.ifClass = clazz;
            this.mustBeIf = bl;
        }

        @Override
        public java.lang.Object getCriteria() {
            return null;
        }

        @Override
        public java.lang.Object[] getMetadata() {
            return null;
        }

        @Override
        public boolean doesMatch(java.lang.Object object) {
            boolean bl = false;
            if (object instanceof Class) {
                Class clazz = (Class)object;
                bl = (!this.mustBeIf || clazz.isInterface()) && this.ifClass.isAssignableFrom(clazz);
            }
            return bl;
        }
    }

    public static class InheritanceComparator
    implements Comparator {
        public int compare(java.lang.Object object, java.lang.Object object2) {
            int n;
            int n2 = n = object == object2 ? 0 : -1;
            if (n != 0) {
                if (object != null && object2 != null) {
                    if (object != null) {
                        Class clazz = (Class)object;
                        Class clazz2 = (Class)object2;
                        if (clazz.equals(clazz2)) {
                            n = 0;
                        }
                        n = clazz.isAssignableFrom(clazz2) ? 1 : (clazz2.isAssignableFrom(clazz) ? -1 : ComparisonUtil.compare((int)this.chainLength(clazz2), (int)this.chainLength(clazz)));
                    }
                } else {
                    n = 0;
                }
            }
            return n;
        }

        protected int chainLength(Class clazz) {
            if (clazz.equals(java.lang.Object.class)) {
                return 0;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray.length > 0) {
                return 1 + this.chainLength(classArray[0]);
            }
            return 1;
        }

        protected int chainLength(Class[] classArray) {
            return this.chainLength(classArray, classArray.length);
        }

        protected int chainLength(Class[] classArray, int n) {
            if (classArray == null || classArray.length == 0 || n <= 0) {
                return 0;
            }
            if (classArray.length == 1) {
                return this.chainLength(classArray[0]);
            }
            int n2 = this.chainLength(classArray, n - 1);
            int n3 = this.chainLength(classArray[n - 1]);
            return Math.max(n2, n3);
        }
    }

    public static class MethodComparator
    implements Comparator {
        private static MethodComparator instance = new MethodComparator();

        private MethodComparator() {
        }

        public static MethodComparator instance() {
            return instance;
        }

        public int compare(java.lang.Object object, java.lang.Object object2) {
            int n;
            boolean bl;
            boolean bl2 = bl = object == object2;
            if (!bl) {
                int n2;
                int n3;
                String string;
                Method method = (Method)object;
                Method method2 = (Method)object2;
                String string2 = method.getName();
                n = string2.compareTo(string = method2.getName());
                if (n == 0 && (n = ComparisonUtil.compare((int)(n3 = method.getModifiers()), (int)(n2 = method2.getModifiers()))) == 0) {
                    n = this.compareArgTypes(method, method2);
                }
            } else {
                n = 0;
            }
            return n;
        }

        private int compareArgTypes(Method method, Method method2) {
            int n = 0;
            Class<?>[] classArray = method.getParameterTypes();
            Class<?>[] classArray2 = method2.getParameterTypes();
            int n2 = classArray.length;
            int n3 = classArray2.length;
            int n4 = Math.min(n2, n3);
            for (int i = 0; i < n4 && n == 0; ++i) {
                Class<?> clazz = classArray[i];
                Class<?> clazz2 = classArray2[i];
                n = clazz.getName().compareTo(clazz2.getName());
            }
            if (n == 0) {
                if (n2 < n3) {
                    n = 1;
                }
                if (n3 < n2) {
                    n = -1;
                }
            }
            return n;
        }
    }

    public static class NoUiMatcher
    extends AbstractMatcher {
        @Override
        public java.lang.Object getCriteria() {
            return null;
        }

        @Override
        public java.lang.Object[] getMetadata() {
            return null;
        }

        @Override
        public boolean doesMatch(java.lang.Object object) {
            String string;
            boolean bl = false;
            if (object instanceof String && (!(string = (String)object).startsWith(ReflectionUtil.CERENT_PREFIX) || string.indexOf("util.gui", ReflectionUtil.CERENT_PREFIX.length()) < 0 && string.indexOf("cms.ui", ReflectionUtil.CERENT_PREFIX.length()) < 0) && !string.startsWith("com.klg")) {
                bl = true;
            }
            return bl;
        }
    }
}

