/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.IModuleModel;
import cerent.util.TDMTerminology;

public class SdhLoStructure {
    public static final short VC12_NUM_IN_TUG2 = 3;
    public static final short TUG2_NUM_IN_VC3 = 7;
    public static final short VC3_NUM_IN_VC4 = 3;
    private static final short BASE1 = 4;
    private static final short BASE2 = 8;
    private static final short BASE3 = 4;
    public static final short MIN_VALID_VT = SdhLoStructure.struct2Vt((short)1, (short)0, (short)0);
    public static final short MAX_VALID_VT = SdhLoStructure.struct2Vt((short)3, (short)7, (short)3);
    public static final short MIN_VT_4_VC3_STRUCTURE = MIN_VALID_VT;
    public static final short MAX_VT_4_VC3_STRUCTURE = SdhLoStructure.struct2Vt((short)3, (short)0, (short)0);
    public static final short MIN_VT_4_VC12_STRUCTURE = SdhLoStructure.struct2Vt((short)1, (short)1, (short)1);
    public static final short MAX_VT_4_VC12_STRUCTURE = MAX_VALID_VT;
    private short vc3 = 0;
    private short tug2 = 0;
    private short vc12 = 0;

    public SdhLoStructure(Integer n, Integer n2, Integer n3) {
        this(n.shortValue(), n2 == null ? (short)0 : n2.shortValue(), n3 == null ? (short)0 : n3.shortValue());
    }

    public SdhLoStructure(short s) {
        this(SdhLoStructure.getVc3FromVt(s), SdhLoStructure.getTug2FromVt(s), SdhLoStructure.getVc12FromVt(s));
    }

    public SdhLoStructure(short s, short s2, short s3) {
        this.vc3 = s;
        this.tug2 = s2;
        this.vc12 = s3;
        if (!this.isValid()) {
            throw new IllegalArgumentException("The following definition is not a legal SDH LO structure: VC3=" + s + ", TUG2=" + s2 + ", VC12=" + s3 + ".");
        }
    }

    public static short getVc3FromVt(short s) {
        return (short)(s / 32);
    }

    public static short getTug2FromVt(short s) {
        return (short)(s % 32 / 4);
    }

    public static short getVc12FromVt(short s) {
        return (short)(s % 4);
    }

    public static short struct2Vt(short s, short s2, short s3) {
        if (!SdhLoStructure.isValid(s, s2, s3)) {
            throw new IllegalArgumentException("This is not a valid SDH LO structure!");
        }
        return (short)(s3 + s2 * 4 + s * 32);
    }

    public short toVt() {
        return SdhLoStructure.struct2Vt(this.vc3, this.tug2, this.vc12);
    }

    public static boolean isValid(short s, short s2, short s3) {
        if (s < 1 || s > 3) {
            return false;
        }
        if (s2 == 0) {
            return s3 == 0;
        }
        return s2 >= 1 && s2 <= 7 && s3 >= 1 && s3 <= 3;
    }

    public boolean isValid() {
        return SdhLoStructure.isValid(this.vc3, this.tug2, this.vc12);
    }

    public static boolean isValidVt(short s) {
        return SdhLoStructure.isValid(SdhLoStructure.getVc3FromVt(s), SdhLoStructure.getTug2FromVt(s), SdhLoStructure.getVc12FromVt(s));
    }

    public static boolean isValidVc3(short s) {
        return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) == 0;
    }

    public static boolean isValidVc12(short s) {
        return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) != 0;
    }

    public String toString() {
        return this.prettyString('=', ',');
    }

    public String prettyString(char c, char c2) {
        if (this.isVc3Structure()) {
            return "vc3" + c + this.vc3;
        }
        return "tug3" + c + this.vc3 + c2 + "tug2" + c + this.tug2 + c2 + "vc12" + c + this.vc12;
    }

    public short getVc3() {
        return this.vc3;
    }

    public short getTug2() {
        return this.tug2;
    }

    public short getVc12() {
        return this.vc12;
    }

    public static boolean isVc3Structure(short s) {
        if (!SdhLoStructure.isValidVt(s)) {
            throw new IllegalArgumentException("This is not a valid VT.");
        }
        return SdhLoStructure.getTug2FromVt(s) == 0;
    }

    public boolean isVc3Structure() {
        return this.tug2 == 0;
    }

    public static boolean isVc12Structure(short s) {
        if (!SdhLoStructure.isValidVt(s)) {
            throw new IllegalArgumentException("This is not a valid VT.");
        }
        return SdhLoStructure.getTug2FromVt(s) != 0;
    }

    public boolean isVc12Structure() {
        return this.tug2 != 0;
    }

    public static short getClosestValidVc12(short s, char c) {
        if (SdhLoStructure.isValidVt(s) && SdhLoStructure.isVc12Structure(s)) {
            return s;
        }
        if (c == '+') {
            return SdhLoStructure.getNextValidVc12(s);
        }
        return SdhLoStructure.getPreviousValidVc12(s);
    }

    public static short getNextValidVc12(short s) {
        for (short s2 = (short)(s + 1); s2 <= MAX_VT_4_VC12_STRUCTURE; s2 = (short)(s2 + 1)) {
            if (!SdhLoStructure.isValidVt(s2) || !SdhLoStructure.isVc12Structure(s2)) continue;
            return s2;
        }
        throw new IllegalArgumentException("A valid VC12 cannot be found.");
    }

    public static short getPreviousValidVc12(short s) {
        for (short s2 = (short)(s - 1); s2 >= MIN_VT_4_VC12_STRUCTURE; s2 = (short)(s2 - 1)) {
            if (!SdhLoStructure.isValidVt(s2) || !SdhLoStructure.isVc12Structure(s2)) continue;
            return s2;
        }
        throw new IllegalArgumentException("A valid VC12 cannot be found.");
    }

    public static boolean isFirstVc12InVc3(short s) {
        return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) == 1 && SdhLoStructure.getVc12FromVt(s) == 1;
    }

    public static boolean isLastVc12InVc3(short s) {
        return SdhLoStructure.isValidVt(s) && SdhLoStructure.getTug2FromVt(s) == 7 && SdhLoStructure.getVc12FromVt(s) == 3;
    }

    public static int getPortPositionInCard(IModuleModel iModuleModel, int n, int n2) {
        if (TDMTerminology.isSonetEnvironment()) {
            throw new IllegalStateException("This method should only be used in SDH");
        }
        short s = SdhLoStructure.getVc3FromVt((short)n2);
        short s2 = SdhLoStructure.getTug2FromVt((short)n2);
        short s3 = SdhLoStructure.getVc12FromVt((short)n2);
        switch (iModuleModel.getEqType()) {
            case 65: 
            case 66: 
            case 67: {
                return SdhLoStructure.getPortPositionOnVc3Level(n, s);
            }
            case 64: 
            case 83: {
                return SdhLoStructure.getPortPositionOnVc12Level(s2, s3);
            }
        }
        throw new IllegalArgumentException("This card does not appear to be supported by SDH nodes.");
    }

    public static int getPortPositionOnVc3Level(int n, int n2) {
        return (n - 1) * 3 + n2;
    }

    public static int getPortPositionOnVc12Level(int n, int n2) {
        return (n2 - 1) * 7 + n;
    }
}

