/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractHoNum;
import cerent.util.IHoNum;

public class SonetHoNum
extends AbstractHoNum {
    private int sts;

    public SonetHoNum(int n) {
        this.sts = n;
        this.validate();
    }

    private void validate() {
        if (this.sts <= 0) {
            throw new IllegalArgumentException("The STS must be a positive number.");
        }
    }

    public int getStsNum() {
        return this.sts;
    }

    @Override
    public int getHoVal() {
        return this.getStsNum();
    }

    @Override
    public int toSonetSts() {
        return SonetHoNum.GetSonetSts(this.sts);
    }

    public static int GetSonetSts(int n) {
        return n;
    }

    @Override
    public int getFramingType() {
        return 0;
    }

    @Override
    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0 && object instanceof IHoNum) {
            n = this.sts - ((SonetHoNum)object).sts;
        }
        return n;
    }

    @Override
    public String prettyString() {
        return "STS=" + this.sts;
    }

    public int toSdhVc4Num() {
        return SonetHoNum.StsNum2Vc4(this.sts);
    }

    @Override
    public short getHoNum() {
        return (short)this.getStsNum();
    }
}

