/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private ZipUtils() {
    }

    public static byte[] deflateStringToBytes(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9));
        deflaterOutputStream.write(string.getBytes());
        deflaterOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String inflateStringFromBytes(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new InflaterInputStream(byteArrayInputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        while ((n = bufferedInputStream.read(byArray2)) > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        String string = byteArrayOutputStream.toString();
        byteArrayInputStream.close();
        bufferedInputStream.close();
        byteArrayOutputStream.close();
        return string;
    }

    public static byte[] zipStringToBytes(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new ZipOutputStream(byteArrayOutputStream));
        bufferedOutputStream.write(string.getBytes());
        bufferedOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String unzipStringFromBytes(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        if (zipInputStream.getNextEntry() != null) {
            int n;
            while ((n = zipInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
        }
        String string = byteArrayOutputStream.toString();
        byteArrayInputStream.close();
        zipInputStream.close();
        byteArrayOutputStream.close();
        if (string.length() == 0) {
            throw new IOException("Not a zip file");
        }
        return string;
    }

    public static byte[] gzipStringToBytes(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new GZIPOutputStream(byteArrayOutputStream));
        bufferedOutputStream.write(string.getBytes());
        bufferedOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String gunzipStringFromBytes(byte[] byArray) throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new GZIPInputStream(byteArrayInputStream));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        while ((n = bufferedInputStream.read(byArray2)) > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        String string = byteArrayOutputStream.toString();
        byteArrayInputStream.close();
        bufferedInputStream.close();
        byteArrayOutputStream.close();
        return string;
    }
}

