/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BoundTextField
extends JTextField {
    private int maxStringLength;

    public BoundTextField(int n) {
        this(0, n);
    }

    public BoundTextField(int n, int n2) {
        super(n);
        this.maxStringLength = n2;
    }

    public void setMaxLength(int n) {
        this.maxStringLength = n;
        if (this.getDocument().getLength() > this.maxStringLength) {
            this.setText(this.getText().substring(0, this.maxStringLength));
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new BoundDocument();
    }

    private class BoundDocument
    extends PlainDocument {
        private BoundDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            int n2 = this.getLength();
            char[] cArray = string.toCharArray();
            String string2 = new String();
            for (int i = 0; i < cArray.length; ++i) {
                if (n2 < BoundTextField.this.maxStringLength) {
                    string2 = string2 + cArray[i];
                    ++n2;
                    ++i;
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            if (string2.length() > 0) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

