/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.HighlightListener;
import com.klg.jclass.chart.ChartDataModel;
import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvLegend;
import ilog.views.chart.event.ChartInteractionListener;
import ilog.views.chart.interactor.IlvChartHighlightInteractor;
import ilog.views.chart.renderer.IlvBarChartRenderer;
import java.awt.Color;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

abstract class Chart {
    protected IlvChart chart;
    private IlvAxis xAxis;
    private IlvAxis yAxis;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int NORTHEAST = 4;
    public static final int NORTHWEST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTHWEST = 7;
    public static final int HORIZONTAL = 8;
    public static final int VERTICAL = 9;
    protected double origin = -25.0;

    protected Chart(int n) {
        this.chart = new IlvChart(n);
        this.chart.setAntiAliasing(true);
        this.xAxis = this.chart.getXAxis();
        this.yAxis = this.chart.getYAxis(0);
    }

    public JComponent getComponentObj() {
        return this.chart;
    }

    public abstract IlvBarChartRenderer getRenderer();

    public abstract void setDataSource(ChartDataModel var1);

    public void setXaxisTitle(String string) {
        this.chart.getXScale().setTitle(string);
    }

    public void setYaxisTitle(String string) {
        this.chart.getYScale(0).setTitle(string);
        this.chart.getYScale(0).setTitleRotation(270.0);
    }

    public void setGridVisible(boolean bl) {
        this.chart.getYGrid(0).setVisible(bl);
    }

    public void setOrigin(double d) {
        this.origin = d;
        this.chart.getCoordinateSystem(0).setXCrossingValue(d);
    }

    public void setMin(double d) {
        this.chart.getYAxis(0).setDataMin(d);
    }

    public void setBackground(Color color) {
        this.chart.getChartArea().setBackground(color);
        this.chart.getChartArea().setOpaque(true);
    }

    public void setAutoLabel(boolean bl) {
    }

    public void setHeader(String string) {
        this.chart.setHeaderText(string);
    }

    public void setFooter(String string) {
        this.chart.setFooterText(string);
    }

    public void setLegendAnchor(int n) {
        this.addLegendIfNecessary();
        String string = null;
        switch (n) {
            case 0: {
                string = "North_Top";
                break;
            }
            case 1: {
                string = "South_Top";
                break;
            }
            case 2: {
                string = "East";
                break;
            }
            case 3: {
                string = "West";
                break;
            }
            case 4: {
                string = "North_East";
                break;
            }
            case 5: {
                string = "North_West";
                break;
            }
            case 7: {
                string = "South_West";
                break;
            }
            case 6: {
                string = "South_East";
                break;
            }
            default: {
                string = "North_Top";
            }
        }
        this.chart.setLegendPosition(string);
    }

    private void addLegendIfNecessary() {
        if (this.chart.getLegend() == null) {
            IlvLegend ilvLegend = new IlvLegend();
            this.chart.addLegend(ilvLegend, "North_Top");
            ilvLegend.setBorder(null);
        }
    }

    public void setLegendOrientation(int n) {
        this.addLegendIfNecessary();
    }

    public void setLegendVisible(boolean bl) {
        this.addLegendIfNecessary();
        this.chart.setLegendVisible(bl);
    }

    public void setAutoLabelTexts(String string, Object[] objectArray) {
        HighlightListener highlightListener = new HighlightListener(objectArray);
        IlvChartHighlightInteractor ilvChartHighlightInteractor = new IlvChartHighlightInteractor();
        ilvChartHighlightInteractor.setPickingMode(1);
        ilvChartHighlightInteractor.addChartInteractionListener((ChartInteractionListener)highlightListener);
        this.chart.addInteractor((IlvChartInteractor)ilvChartHighlightInteractor);
    }

    public void set3D(boolean bl) {
        if (this.chart.is3D() != bl) {
            if (bl) {
                ((IlvBarChartRenderer)this.chart.getRenderer(0)).setMode(1);
            } else {
                ((IlvBarChartRenderer)this.chart.getRenderer(0)).setMode(1);
            }
            this.chart.set3D(bl);
        }
    }

    public boolean is3D() {
        return this.chart.is3D();
    }

    public void addInteractor(IlvChartInteractor ilvChartInteractor) {
        this.chart.addInteractor(ilvChartInteractor);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.chart.getChartArea().addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.chart.getChartArea().removeMouseListener(mouseListener);
    }
}

