/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DetailedLog;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DetailedProgressDialog
extends DetailedLogDialog
implements IDetailedProgressDialog {
    private DetailedLog currentLog;
    private IDetailedProgressController controller;
    private boolean isClose;

    public DetailedProgressDialog(Frame frame, String string, DetailedLog detailedLog, IDetailedProgressController iDetailedProgressController, boolean bl, ImageIcon imageIcon) {
        super(frame, string, (Icon)imageIcon, "", detailedLog, true, 1);
        this.isClose = bl;
        this.controller = iDetailedProgressController;
        this.init();
    }

    public DetailedProgressDialog(Frame frame, String string, DetailedLog detailedLog, IDetailedProgressController iDetailedProgressController, boolean bl) {
        this(frame, string, detailedLog, iDetailedProgressController, bl, CerentDialog.INFO_ICON);
    }

    public DetailedProgressDialog(Frame frame, String string, DetailedLog detailedLog, IDetailedProgressController iDetailedProgressController) {
        this(frame, string, detailedLog, iDetailedProgressController, false);
    }

    @Override
    public void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DetailedProgressDialog.this.controller.start(DetailedProgressDialog.this);
            }
        });
        thread.start();
        this.show();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public boolean isCompleted() {
        return !this.isCancelled();
    }

    @Override
    public void addLog(String string, DetailedLog detailedLog) {
        this.setMainLabel(string);
        if (detailedLog != null) {
            this.addDetailedLog(detailedLog, true);
        }
        this.currentLog = detailedLog;
    }

    @Override
    public void addLog(DetailedLog detailedLog) {
        this.addDetailedLog(detailedLog, true);
        this.currentLog = detailedLog;
    }

    @Override
    public void appendChild(DetailedLog detailedLog) {
        if (this.currentLog != null) {
            this.currentLog.setType(Math.max(this.currentLog.getType(), detailedLog.getType()));
            this.currentLog.addChild(detailedLog);
            this.updateDetailedLog(this.currentLog, true);
        }
    }

    @Override
    public void setCancelled() {
        this.cancelled = true;
        this.setMainLabel("User Cancelled");
        if (!this.controller.isCancelSupported()) {
            super.setCancelled();
        } else {
            this.controller.cancel();
        }
    }

    @Override
    public void setCompleted(boolean bl) {
        this.setCompleted(bl, null);
    }

    public void setCompleted(boolean bl, String string) {
        if (string == null) {
            if (bl) {
                this.setMainLabel("Completed");
            } else {
                this.setMainLabel("Failed");
            }
        } else {
            this.setMainLabel(string);
        }
        if (!this.controller.isCancelSupported()) {
            this.setCancelEnabled(true);
            this.setCloseEnabled(bl);
        } else {
            this.setCancelEnabled(false);
            this.setCloseEnabled(true);
        }
    }

    public void setProgressMessage(String string) {
        this.setMainLabel(string);
    }

    private void init() {
        this.setCloseEnabled(false);
        this.setCancelEnabled(this.controller.isCancelSupported());
        if (this.isClose) {
            this.setCloseText("Close");
        } else {
            this.setCloseText("Continue");
        }
        this.setDefaultCloseOperation(0);
    }

    @Override
    protected void setCancelEnabled(boolean bl) {
        super.setCancelEnabled(bl);
    }
}

