/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

public class HtmlLabelEditor
extends JPanel
implements ChangeListener {
    private JTextArea textArea;
    private JLabel label;
    private JTabbedPane tp = new JTabbedPane(1);
    private UScrollPane editPanel;
    private UScrollPane previewPanel;

    public HtmlLabelEditor() {
        super(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.editPanel = new UScrollPane(this.textArea);
        this.editPanel.setHorizontalScrollBarPolicy(31);
        this.tp.add("HTML", this.editPanel);
        this.label = new JLabel();
        this.label.setVerticalAlignment(0);
        this.label.setHorizontalAlignment(0);
        this.previewPanel = new UScrollPane(this.label);
        this.previewPanel.setBorder(BorderFactory.createEtchedBorder());
        this.tp.add("Preview", this.previewPanel);
        this.tp.addChangeListener(this);
        this.add(this.tp);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String string) {
        this.textArea.setText(string);
        this.updateLabel();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().addDocumentListener(documentListener);
    }

    private void updateLabel() {
        this.label.setText("<html>" + this.textArea.getText());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.tp.getSelectedComponent();
        if (component == this.previewPanel) {
            this.updateLabel();
        }
    }
}

