/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.AnnotatedException;
import cerent.util.DebugManager;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class IgnorableDialog {
    public static final String DONT_SHOW_AGAIN = "Do not show this message again";
    public static final String PREF_PATH = "ctc.ignore.dialogs";
    public static final String PREF_PATH_DESCRIPTION_EXTENSION = "description";
    public static final String PREF_PATH_VALUE_EXTENSION = "value";
    private static final Preferences prefs = Preferences.instance();
    private static int intRval;
    private static Object objRval;

    private IgnorableDialog() {
    }

    public static boolean yesNoDialog(String string, String string2, String string3, String string4) {
        return IgnorableDialog.yesNoDialog(null, string, string2, string3, string4);
    }

    public static boolean yesNoDialog(Component component, String string, String string2, String string3, String string4) {
        return IgnorableDialog.questionDialog(component, string, string2, string3, string4) == 0;
    }

    public static int questionDialog(Component component, String string, String string2, String string3, String string4) {
        return IgnorableDialog.showConfirmDialog(component, string, string2, 0, 3, CerentDialog.QUESTION_ICON, string3, string4);
    }

    public static int cancelableQuestionDialog(Component component, String string, String string2, String string3, String string4) {
        return IgnorableDialog.showConfirmDialog(component, string, string2, 1, 3, CerentDialog.QUESTION_ICON, string3, string4);
    }

    public static int optionDialog(Component component, String string, String string2, Object[] objectArray, Object object, String string3, String string4) {
        return IgnorableDialog.showOptionDialog(component, string, string2, -1, 3, CerentDialog.QUESTION_ICON, objectArray, object, string3, string4);
    }

    public static Object inputDialog(Component component, String string, String string2, Object[] objectArray, Object object, String string3, String string4) {
        return IgnorableDialog.showInputDialog(component, string, string2, 3, CerentDialog.QUESTION_ICON, objectArray, object, string3, string4);
    }

    public static void errorDialog(String string, String string2, String string3) {
        IgnorableDialog.errorDialog(null, string, string2, string3);
    }

    public static void errorDialog(Component component, String string, String string2, String string3) {
        IgnorableDialog.errorDialog(component, string, "Error", string2, string3);
    }

    public static void errorDialog(Component component, String string, String string2, String string3, String string4) {
        IgnorableDialog.showMessageDialog(component, string, string2, 0, CerentDialog.FATAL_ICON, true, string3, string4);
    }

    public static void errorDialog(Component component, Exception exception, String string, String string2, String string3) {
        DebugManager.instance().getRoot().rootPrintStackTrace((Throwable)exception);
        String string4 = AnnotatedException.getString(exception);
        IgnorableDialog.errorDialog(component, string4, string, string2, string3);
    }

    public static void warningDialog(String string, String string2, String string3) {
        IgnorableDialog.warningDialog(null, string, string2, string3);
    }

    public static void warningDialog(Component component, String string, String string2, String string3) {
        IgnorableDialog.warningDialog(component, string, "Warning", string2, string3);
    }

    public static void warningDialog(Component component, String string, String string2, String string3, String string4) {
        IgnorableDialog.warningDialog(component, string, string2, true, string3, string4);
    }

    public static void warningDialog(Component component, Component component2, String string, String string2, String string3) {
        IgnorableDialog.showMessageDialog(component, component2, string, 2, CerentDialog.WARNING_ICON, true, string2, string3);
    }

    public static void warningDialog(Component component, String string, String string2, boolean bl, String string3, String string4) {
        IgnorableDialog.showMessageDialog(component, string, string2, 2, CerentDialog.WARNING_ICON, bl, string3, string4);
    }

    public static void infoDialog(Component component, String string, String string2, String string3, String string4) {
        IgnorableDialog.showMessageDialog(component, string, string2, 1, CerentDialog.INFO_ICON, true, string3, string4);
    }

    public static void infoDialog(Component component, String string, String string2, String string3) {
        IgnorableDialog.infoDialog(component, string, string2, string3, null);
    }

    public static void detailedDialog(Component component, String string, String string2, String string3, String string4, String string5) {
        IgnorableDialog.showDetailedDialog(component, string, string2, string3, string4, string5);
    }

    private static String extendPrefPath(String string) {
        return "ctc.ignore.dialogs." + string;
    }

    private static String valuePrefPath() {
        return IgnorableDialog.extendPrefPath(PREF_PATH_VALUE_EXTENSION);
    }

    private static String descriptionPrefPath() {
        return IgnorableDialog.extendPrefPath(PREF_PATH_DESCRIPTION_EXTENSION);
    }

    private static void setProperty(String string, String string2, String string3) {
        prefs.setProperty(IgnorableDialog.valuePrefPath(), string, string3);
        if (string2 != null) {
            prefs.setProperty(IgnorableDialog.descriptionPrefPath(), string, string2);
        }
    }

    private static void setProperty(String string, String string2, boolean bl) {
        prefs.setBoolean(IgnorableDialog.valuePrefPath(), string, bl);
        if (string2 != null) {
            prefs.setProperty(IgnorableDialog.descriptionPrefPath(), string, string2);
        }
    }

    private static void ensureDescriptionExists(String string, String string2) {
        if (!prefs.propertyExist(IgnorableDialog.descriptionPrefPath(), string) && string2 != null) {
            prefs.setProperty(IgnorableDialog.descriptionPrefPath(), string, string2);
        }
    }

    private static int showOptionDialog(Component component, String string, String string2, int n, int n2, Icon icon, Object[] objectArray, Object object, String string3, String string4) {
        int n3 = -1;
        if (prefs.propertyExist(IgnorableDialog.valuePrefPath(), string3)) {
            n3 = Integer.parseInt(prefs.getProperty(IgnorableDialog.valuePrefPath(), string3, Integer.toString(0)));
            IgnorableDialog.ensureDescriptionExists(string3, string4);
        } else if (prefs.propertyExist(PREF_PATH, string3)) {
            prefs.removeAllProperties(PREF_PATH, string3);
            n3 = Integer.parseInt(prefs.getProperty(PREF_PATH, string3, Integer.toString(0)));
            IgnorableDialog.setProperty(string3, string4, Integer.toString(n3));
        } else {
            JCheckBox jCheckBox = new JCheckBox(DONT_SHOW_AGAIN);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray.length] = jCheckBox;
            n3 = IgnorableDialog.internalShowDialog(component, string, string2, n, n2, icon, true, objectArray2, object);
            if (jCheckBox.isSelected()) {
                IgnorableDialog.setProperty(string3, string4, Integer.toString(n3));
            }
        }
        return n3;
    }

    private static Object showInputDialog(Component component, String string, String string2, int n, Icon icon, Object[] objectArray, Object object, String string3, String string4) {
        Object object2 = null;
        if (prefs.propertyExist(IgnorableDialog.valuePrefPath(), string3)) {
            object2 = prefs.getProperty(IgnorableDialog.valuePrefPath(), string3, null);
            IgnorableDialog.ensureDescriptionExists(string3, string4);
        } else if (prefs.propertyExist(PREF_PATH, string3)) {
            prefs.removeAllProperties(PREF_PATH, string3);
            object2 = prefs.getProperty(IgnorableDialog.valuePrefPath(), string3, null);
            IgnorableDialog.setProperty(string3, string4, object2.toString());
        } else {
            JCheckBox jCheckBox = new JCheckBox(DONT_SHOW_AGAIN);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray.length] = jCheckBox;
            object2 = IgnorableDialog.internalShowInputDialog(component, string, string2, n, icon, objectArray2, object);
            if (jCheckBox.isSelected()) {
                IgnorableDialog.setProperty(string3, string4, object2.toString());
            }
        }
        return object2;
    }

    private static int showConfirmDialog(Component component, String string, String string2, int n, int n2, Icon icon, String string3, String string4) {
        int n3 = -1;
        if (prefs.propertyExist(IgnorableDialog.valuePrefPath(), string3)) {
            n3 = Integer.parseInt(prefs.getProperty(IgnorableDialog.valuePrefPath(), string3, Integer.toString(0)));
            IgnorableDialog.ensureDescriptionExists(string3, string4);
        } else if (prefs.propertyExist(PREF_PATH, string3)) {
            prefs.removeAllProperties(PREF_PATH, string3);
            n3 = Integer.parseInt(prefs.getProperty(IgnorableDialog.valuePrefPath(), string3, Integer.toString(0)));
            IgnorableDialog.setProperty(string3, string4, Integer.toString(n3));
        } else {
            Object object;
            Object[] objectArray;
            JCheckBox jCheckBox = new JCheckBox(DONT_SHOW_AGAIN);
            switch (n) {
                case 1: {
                    objectArray = new Object[]{"Yes", "No", "Cancel", jCheckBox};
                    object = objectArray[2];
                    break;
                }
                case 2: {
                    objectArray = new Object[]{"OK", "Cancel", jCheckBox};
                    object = objectArray[1];
                    break;
                }
                default: {
                    objectArray = new Object[]{"Yes", "No", jCheckBox};
                    object = objectArray[1];
                }
            }
            n3 = IgnorableDialog.internalShowDialog(component, string, string2, n, n2, icon, true, objectArray, object);
            if (jCheckBox.isSelected()) {
                IgnorableDialog.setProperty(string3, string4, Integer.toString(n3));
            }
        }
        return n3;
    }

    private static void showMessageDialog(Component component, Object object, String string, int n, Icon icon, boolean bl, String string2, String string3) {
        if (prefs.propertyExist(IgnorableDialog.valuePrefPath(), string2)) {
            IgnorableDialog.ensureDescriptionExists(string2, string3);
        } else if (prefs.propertyExist(PREF_PATH, string2)) {
            prefs.removeAllProperties(PREF_PATH, string2);
            IgnorableDialog.setProperty(string2, string3, true);
        } else {
            JCheckBox jCheckBox = new JCheckBox(DONT_SHOW_AGAIN);
            Object[] objectArray = new Object[]{"OK", jCheckBox};
            IgnorableDialog.internalShowDialog(component, object, string, -1, n, icon, bl, objectArray, objectArray[0]);
            if (jCheckBox.isSelected()) {
                IgnorableDialog.setProperty(string2, string3, true);
            }
        }
    }

    private static void showDetailedDialog(Component component, String string, String string2, String string3, String string4, String string5) {
        if (prefs.propertyExist(IgnorableDialog.valuePrefPath(), string4)) {
            IgnorableDialog.ensureDescriptionExists(string4, string5);
        } else if (prefs.propertyExist(PREF_PATH, string4)) {
            prefs.removeAllProperties(PREF_PATH, string4);
            IgnorableDialog.setProperty(string4, string5, true);
        } else {
            int n = IgnorableDialog.internalShowDetailedDialog(component, string, string2, string3, string4, string5);
        }
    }

    private static int internalShowDialog(final Component component, final Object object, final String string, final int n, final int n2, final Icon icon, boolean bl, final Object[] objectArray, final Object object2) {
        intRval = -1;
        if (!bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane jOptionPane = new JOptionPane(object, n2, n, icon, objectArray, object2);
                    JDialog jDialog = jOptionPane.createDialog(component, string);
                    jDialog.pack();
                    jDialog.setModal(false);
                    jDialog.setVisible(true);
                    Object object3 = jOptionPane.getValue();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (object3 != objectArray[i]) continue;
                        intRval = i;
                        break;
                    }
                }
            });
        } else if (SwingUtilities.isEventDispatchThread()) {
            intRval = JOptionPane.showOptionDialog(component, object, string, n, n2, icon, objectArray, object2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        intRval = JOptionPane.showOptionDialog(component, object, string, n, n2, icon, objectArray, object2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                DebugManager.instance().getRoot().rootPrintStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                DebugManager.instance().getRoot().rootPrintStackTrace((Throwable)invocationTargetException);
            }
        }
        return intRval;
    }

    private static int internalShowDetailedDialog(final Component component, final String string, final String string2, final String string3, final String string4, final String string5) {
        intRval = -1;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextArea jTextArea = new JTextArea(string);
                JCheckBox jCheckBox = new JCheckBox(IgnorableDialog.DONT_SHOW_AGAIN);
                Object[] objectArray = new Object[]{jTextArea, jCheckBox};
                DetailedDialog detailedDialog = DetailedDialog.instance(JOptionPane.getFrameForComponent(component), string3);
                JPanel jPanel = new JPanel(new FlowLayout(0));
                jTextArea.setBackground(jPanel.getBackground());
                jTextArea.setEditable(false);
                jPanel.add(new JLabel(CerentDialog.WARNING_ICON));
                jPanel.add(jTextArea);
                Box box = Box.createHorizontalBox();
                box.add(jCheckBox);
                box.add(Box.createHorizontalGlue());
                Box box2 = Box.createVerticalBox();
                box2.add(jPanel);
                box2.add(box);
                JPanel jPanel2 = new JPanel();
                jPanel2.add(box2);
                detailedDialog.setContents(jPanel2);
                detailedDialog.append(string2);
                detailedDialog.setSize(detailedDialog.getWidth(), detailedDialog.getHeight());
                detailedDialog.show();
                if (jCheckBox.isSelected()) {
                    IgnorableDialog.setProperty(string4, string5, true);
                }
                intRval = 0;
            }
        });
        return intRval;
    }

    private static Object internalShowInputDialog(final Component component, final String string, final String string2, final int n, final Icon icon, final Object[] objectArray, final Object object) {
        objRval = null;
        if (SwingUtilities.isEventDispatchThread()) {
            objRval = JOptionPane.showInputDialog(component, string, string2, n, icon, objectArray, object);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        objRval = JOptionPane.showInputDialog(component, string, string2, n, icon, objectArray, object);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                DebugManager.instance().getRoot().rootPrintStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                DebugManager.instance().getRoot().rootPrintStackTrace((Throwable)invocationTargetException);
            }
        }
        return objRval;
    }
}

