/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.BoolHolder;
import cerent.util.EID;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooser;
import cerent.util.gui.PersistentFileChooserPanel;
import cerent.util.gui.UOptionDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class PersistentFileChooserDialog
extends UOptionDialog {
    public static final byte MASK_ALLOW_FILES = 1;
    public static final byte MASK_ALLOW_SAVE = 2;
    public static final byte MASK_DONT_CREATE_FILE = 4;
    protected PersistentFileChooserPanel pfc;
    protected byte mask;
    protected File theFile = null;
    public static String nodename = null;

    public static PersistentFileChooserDialog instance(Component component, boolean bl, String string, List list) {
        if (component instanceof Dialog) {
            return new PersistentFileChooserDialog((Dialog)component, string, bl, list);
        }
        Frame frame = JOptionPane.getFrameForComponent(component);
        return new PersistentFileChooserDialog(frame, string, bl, list);
    }

    PersistentFileChooserDialog(Frame frame, String string, boolean bl, List list) {
        super(frame, string, bl, list);
    }

    PersistentFileChooserDialog(Dialog dialog, String string, boolean bl, List list) {
        super(dialog, string, bl, list);
    }

    @Override
    protected void confirmCancel() {
        this.confirmExit();
    }

    @Override
    protected void setValuesFromList(List list) {
        super.setValuesFromList(list);
        this.pfc = (PersistentFileChooserPanel)list.get(1);
        this.mask = (Byte)list.get(2);
    }

    public File getFileHandle() {
        return this.theFile;
    }

    public boolean restoreCompleteDB() {
        return this.pfc.isCompleteSelected();
    }

    @Override
    protected void checkOtherOptionValues(String string) {
        if (string.equals("OK")) {
            String string2 = this.pfc.getSelectedFileName();
            if (string2.length() == 0) {
                this.pfc.removeFileName(string2);
                this.jopane.setValue(null);
                return;
            }
            File file = new File(string2);
            if ((this.mask & 2) == 2) {
                if (file.exists()) {
                    if (!file.isFile() || !file.canWrite()) {
                        this.handleNotWritableFile(string2);
                        this.pfc.removeFileName(string2);
                        this.jopane.setValue(null);
                        return;
                    }
                    if (!CerentDialog.yesNoDialog(this, "The file " + string2 + " already exists.\nDo you want" + " to replace it?", "Select Output file")) {
                        this.jopane.setValue(null);
                        return;
                    }
                } else {
                    if ((this.mask & 4) == 4) {
                        this.theFile = file;
                        this.confirmExit();
                        return;
                    }
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        this.handleNotWritableFile(string2);
                        this.pfc.removeFileName(string2);
                        this.jopane.setValue(null);
                        return;
                    }
                }
            } else {
                if (!file.exists()) {
                    this.handleNoSuchFile(string2);
                    this.pfc.removeFileName(string2);
                    this.jopane.setValue(null);
                    return;
                }
                if (!file.isFile() || !file.canRead()) {
                    this.handleNotReadableFile(string2);
                    this.pfc.removeFileName(string2);
                    this.jopane.setValue(null);
                    return;
                }
            }
            this.theFile = file;
            this.confirmExit();
        }
    }

    public static void setNodeName(String string) {
        nodename = string;
    }

    protected void handleNotWritableFile(String string) {
        KErrorMsg.displayError((Component)this, (EID)KEMC.EID_FILE_SAVE_EXCEPTION_PARAM_1, (Object)string);
    }

    protected void handleNotReadableFile(String string) {
        KErrorMsg.displayError((Component)this, (EID)KEMC.EID_FILE_LOAD_EXCEPTION_PARAM_1, (Object)string);
    }

    protected void handleNoSuchFile(String string) {
        KErrorMsg.displayError((Component)this, (EID)KEMC.EID_FILE_DOES_NOT_EXIST_PARAM_1, (Object)string);
    }

    public static File getFile(Component component, String string, Object object, byte by, String string2, String string3, int n) {
        return PersistentFileChooserDialog.getFile(component, string, object, by, string2, string3, n, null, false, null);
    }

    public static File getFile(Component component, String string, Object object, byte by, String string2, String string3, int n, FileFilter fileFilter) {
        return PersistentFileChooserDialog.getFile(component, string, object, by, string2, string3, n, fileFilter, false, null);
    }

    public static File getFile(Component component, String string, Object object, byte by, String string2, String string3, int n, boolean bl, BoolHolder boolHolder) {
        return PersistentFileChooserDialog.getFile(component, string, object, by, string2, string3, n, null, bl, boolHolder);
    }

    public static File getFile(Component component, String string, Object object, byte by, String string2, String string3, int n, FileFilter fileFilter, boolean bl, BoolHolder boolHolder) {
        boolean bl2 = (by & 2) == 2;
        PersistentFileChooserPanel persistentFileChooserPanel = new PersistentFileChooserPanel(object, bl2, string2, string3, n, bl);
        if (fileFilter != null) {
            persistentFileChooserPanel.setFileFilter(fileFilter);
        }
        Object[] objectArray = new Object[]{"", persistentFileChooserPanel};
        Object[] objectArray2 = new Object[]{"OK", "Cancel"};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 2, null, objectArray2, objectArray2[0]);
        LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
        linkedList.add(jOptionPane);
        linkedList.add(persistentFileChooserPanel);
        linkedList.add(new Byte(by));
        PersistentFileChooserDialog persistentFileChooserDialog = PersistentFileChooserDialog.instance(component, true, string, linkedList);
        try {
            persistentFileChooserDialog.show();
            if (boolHolder != null) {
                boolHolder.setValue(persistentFileChooserPanel.isCompleteSelected());
            }
            if (jOptionPane.getValue().equals("OK")) {
                return persistentFileChooserDialog.getFileHandle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        persistentFileChooserDialog.dispose();
        return null;
    }

    public static File getFileUseChooser(Component component, byte by, String string, String string2) {
        return PersistentFileChooserDialog.getFileUseChooser(component, by, string, string2, null);
    }

    public static File getFileUseChooser(Component component, byte by, String string, String string2, FileFilter fileFilter) {
        PersistentFileChooser persistentFileChooser = new PersistentFileChooser(string, string2);
        File file = persistentFileChooser.showFileChooser(component, by, fileFilter);
        if (file != null) {
            persistentFileChooser.addFileName(file.getAbsolutePath(), true);
        }
        return file;
    }
}

