/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.KDebug;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;

public class TelnetTextAreaAppender {
    public static boolean debug = false;
    private static PrintStream o = System.out;
    private int taStringLength;
    private int taStringMaxLength = 1000000;
    private JTextArea textArea;
    private int count;
    private static final KDebug db = new KDebug("TelnetTextAreaAppender");

    public TelnetTextAreaAppender(JTextArea jTextArea) {
        this.textArea = jTextArea;
        this.taStringLength = jTextArea.getText().length();
    }

    public synchronized void backspace() {
        if (TelnetTextAreaAppender.db.on) {
            db.println("backspace()");
        }
        this.backspace(1);
    }

    public synchronized void backspace(int n) {
        block4: {
            if (TelnetTextAreaAppender.db.on) {
                db.println("backspace(" + n + ")");
            }
            if (n < 0) {
                n = 0;
            }
            Document document = this.textArea.getDocument();
            try {
                document.remove(document.getLength() - n, n);
            }
            catch (BadLocationException badLocationException) {
                if (!db.on()) break block4;
                KDebug.printStackTrace((Throwable)badLocationException);
            }
        }
        this.showCaret();
    }

    public synchronized void clear() {
        if (TelnetTextAreaAppender.db.on) {
            db.println("clear");
        }
        this.textArea.setText("");
    }

    public synchronized void append(String string) {
        if (TelnetTextAreaAppender.db.on) {
            db.finest("append " + this.count++);
            db.finest("taStringMaxLength " + this.taStringMaxLength);
        }
        if (this.taStringMaxLength > 1 && this.taStringLength > this.taStringMaxLength) {
            String string2 = this.textArea.getText();
            if (TelnetTextAreaAppender.db.on) {
                db.finest("\nlength " + string2.length());
            }
            int n = string2.length() - this.taStringMaxLength / 2;
            if (TelnetTextAreaAppender.db.on) {
                db.finest("index " + n);
            }
            while (n < string2.length()) {
                if (TelnetTextAreaAppender.db.on) {
                    db.finest("current index" + n);
                }
                if (string2.charAt(n) == '\n') {
                    ++n;
                    break;
                }
                ++n;
            }
            string2 = string2.substring(n);
            this.taStringLength = string2.length();
            this.textArea.setText(string2);
        }
        if (string != null) {
            this.textArea.append(string);
            if (TelnetTextAreaAppender.db.on) {
                db.finest("\nlength " + this.textArea.getText().length());
            }
            this.taStringLength = this.textArea.getText().length();
            this.showCaret();
        }
    }

    private synchronized void showCaret() {
        String string;
        if (null != this.textArea && null != (string = this.textArea.getText())) {
            Caret caret = this.textArea.getCaret();
            caret.setDot(this.textArea.getText().length());
        }
    }
}

