/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.gui.AwtProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WindowHelper {
    public static final String PREF_PREFIX = "ctc";
    private static final String SUF_X = "x";
    private static final String SUF_Y = "y";
    private static final String SUF_W = "w";
    private static final String SUF_H = "h";

    private WindowHelper() {
    }

    public static Icon getIcon(Class clazz, String string) {
        return WindowHelper.getIcon(clazz, string, null);
    }

    public static Icon getIcon(Class clazz, String string, String string2) {
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            KDebug.printStackTrace((Throwable)new Exception("Cannot load resource:" + string));
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (string2 != null) {
            imageIcon.setDescription(string2);
        }
        return imageIcon;
    }

    public static void persistBounds(Component component, String string) {
        Preferences preferences = Preferences.instance();
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        preferences.setProperty(string, SUF_X, Integer.toString(point.x));
        preferences.setProperty(string, SUF_Y, Integer.toString(point.y));
        preferences.setProperty(string, SUF_H, Integer.toString(dimension.height));
        preferences.setProperty(string, SUF_W, Integer.toString(dimension.width));
    }

    public static void restoreBounds(Component component, String string, Rectangle rectangle) {
        Rectangle rectangle2 = WindowHelper.getPersistedBounds(string, rectangle);
        if (rectangle2 != null) {
            if (rectangle2.x < 0 || rectangle2.y < 0) {
                rectangle2 = WindowHelper.getCenteredBounds(new Dimension(rectangle2.width, rectangle2.height));
            }
            component.setBounds(rectangle2);
        }
    }

    public static Rectangle getPersistedBounds(String string, Rectangle rectangle) {
        Preferences preferences = Preferences.instance();
        try {
            int n = Integer.parseInt(preferences.getProperty(string, SUF_X, ""));
            int n2 = Integer.parseInt(preferences.getProperty(string, SUF_Y, ""));
            int n3 = Integer.parseInt(preferences.getProperty(string, SUF_W, ""));
            int n4 = Integer.parseInt(preferences.getProperty(string, SUF_H, ""));
            return new Rectangle(n, n2, n3, n4);
        }
        catch (Exception exception) {
            return rectangle;
        }
    }

    public static Rectangle getCenteredBounds(Dimension dimension) {
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension2.width - dimension.width) / 2;
        int n2 = (dimension2.height - dimension.height) / 2;
        return new Rectangle(n, n2, dimension.width, dimension.height);
    }

    public static String toHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(10, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append("<p>");
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n));
        stringBuffer.append("</html>");
        string = stringBuffer.toString();
        return string;
    }

    public static int compare(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        return bl ? 1 : -1;
    }

    public static int compare(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    public static void setLabelIcon(JLabel jLabel, Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            jLabel.setIcon(icon);
        } else {
            SwingUtilities.invokeLater(new AwtProxy(1, jLabel, (Object)icon));
        }
    }

    public static void setLabelText(JLabel jLabel, String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            jLabel.setText(string);
        } else {
            SwingUtilities.invokeLater(new AwtProxy(0, jLabel, (Object)string));
        }
    }

    public static void setEnabled(JComponent jComponent, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            jComponent.setEnabled(bl);
        } else {
            SwingUtilities.invokeLater(new AwtProxy(2, jComponent, (Object)new Boolean(bl)));
        }
    }

    public static void setEnabled(JComponent[] jComponentArray, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i = 0; i < jComponentArray.length; ++i) {
                jComponentArray[i].setEnabled(bl);
            }
        } else {
            SwingUtilities.invokeLater(new AwtProxy(2, jComponentArray, (Object)new Boolean(bl)));
        }
    }

    public static void postAlert(DetailedLog detailedLog) {
        EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
    }
}

