/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowDataSourceListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;

public abstract class AbstractRowDataSource
implements RowDataSource {
    protected ArrayList listenerList = new ArrayList();
    private boolean bulkDirty = false;
    EventListenerList el;

    protected void concurrentDeletion(IndexOutOfBoundsException indexOutOfBoundsException) {
    }

    @Override
    public int setObjectAtRow(int n, Object object) {
        return -1;
    }

    @Override
    public Object clone(Object object) {
        return object;
    }

    @Override
    public int remove(int[] nArray) {
        return 0;
    }

    @Override
    public int findSame(Object object) {
        int n = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (object != this.getObjectAtRow(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected void fireRowsAdded(int n, int n2) {
        int n3 = this.listenerList.size();
        try {
            for (int i = 0; i < n3; ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener == null) continue;
                rowDataSourceListener.rowsAdded(n, n2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireRowsDeleted(int n, int n2) {
        int n3 = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener == null) continue;
                rowDataSourceListener.rowsDeleted(n, n2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireRowsUpdated(int n, int n2) {
        int n3 = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener == null) continue;
                rowDataSourceListener.rowsUpdated(n, n2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireDataSourceChanged() {
        int n = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener == null) continue;
                rowDataSourceListener.dataSourceChanged();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireDataStructureChanged() {
        int n = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener == null) continue;
                rowDataSourceListener.dataStructureChanged();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireBulkRowAdded(int n, Object object) {
        int n2 = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener != null) {
                    rowDataSourceListener.bulkRowAdded(n, object);
                }
                this.bulkDirty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireBulkRowDeleted(int n, Object object) {
        int n2 = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener != null) {
                    rowDataSourceListener.bulkRowDeleted(n, object);
                }
                this.bulkDirty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireBulkRowUpdated(int n, Object object, Object object2) {
        int n2 = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener != null) {
                    rowDataSourceListener.bulkRowUpdated(n, object, object2);
                }
                this.bulkDirty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireBulkDataSourceChanged() {
        int n = this.listenerList.size();
        try {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                if (rowDataSourceListener != null) {
                    rowDataSourceListener.bulkDataSourceChanged();
                }
                this.bulkDirty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.concurrentDeletion(indexOutOfBoundsException);
        }
    }

    protected void fireBulkUpdateView() {
        if (this.bulkDirty) {
            int n = this.listenerList.size();
            try {
                for (int i = 0; i < this.listenerList.size(); ++i) {
                    RowDataSourceListener rowDataSourceListener = (RowDataSourceListener)this.listenerList.get(i);
                    if (rowDataSourceListener == null) continue;
                    rowDataSourceListener.bulkUpdateView();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.concurrentDeletion(indexOutOfBoundsException);
            }
            this.bulkDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRowDataSourceListener(RowDataSourceListener rowDataSourceListener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            if (rowDataSourceListener != null && !this.listenerList.contains(rowDataSourceListener)) {
                this.listenerList.add(rowDataSourceListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowDataSourceListener(RowDataSourceListener rowDataSourceListener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.remove(rowDataSourceListener);
        }
    }

    @Override
    public Collection getAllObjects() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            linkedList.add(this.getObjectAtRow(i));
        }
        return linkedList;
    }

    @Override
    public Class getRowObjectClass() {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetRowDataSourceListenerList() {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.clear();
        }
    }
}

