/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.IDisposable;
import cerent.util.KDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListRowDataSource<E>
extends AbstractRowDataSource
implements IDisposable {
    private Class<E> cls;
    private List<E> data;
    private Comparator<? super E> comp;
    private Object lock;
    private static KDebug db = new KDebug("RowDataSourceList");

    public ListRowDataSource(List<E> list, Comparator<? super E> comparator, Class<E> clazz) {
        this.data = list;
        this.comp = comparator;
        this.cls = clazz;
        this.lock = this;
    }

    public ListRowDataSource(Comparator<? super E> comparator, Class<E> clazz) {
        this(new ArrayList(), comparator, clazz);
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public E getObjectAtRow(int n) {
        return this.data.get(n);
    }

    public Collection<E> getObjects() {
        ArrayList<E> arrayList = new ArrayList<E>(this.data);
        return arrayList;
    }

    @Override
    public Class<E> getRowObjectClass() {
        return this.cls;
    }

    private static <T> T cast(Class<T> clazz, Object object) {
        T t = null;
        try {
            t = clazz.cast(object);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return t;
    }

    private E cast(Object object) {
        return ListRowDataSource.cast(this.cls, object);
    }

    @Override
    public void dispose() {
        this.clear();
    }

    private void dispose(Object object) {
        if (object instanceof IDisposable) {
            ((IDisposable)object).dispose();
        }
    }

    public void clear() {
        this.data.clear();
        this.fireDataSourceChanged();
        this.fireBulkUpdateView();
    }

    public void copy(Collection<? super E> collection) {
        if (collection != null) {
            collection.addAll(this.data);
        }
    }

    public int findMatchingRow(E e) {
        return Collections.binarySearch(this.data, e, this.comp);
    }

    public int firstMatchingRow(E e, int n) {
        int n2 = -1;
        int n3 = n;
        if (n3 <= 0) {
            return n3;
        }
        n2 = n3--;
        if (n3 > 0) {
            E e2;
            int n4 = n3;
            while (n4 >= 0 && this.comp.compare(e, e2 = this.data.get(n4)) == 0) {
                n2 = n4--;
            }
        } else {
            n2 = n3;
        }
        return n2;
    }

    public int nextEqualRow(int n, E e, int n2) {
        int n3;
        int n4 = -1;
        if (n < 0) {
            return n4;
        }
        int n5 = this.data.size();
        if (n >= n5) {
            return n4;
        }
        for (n3 = n; n3 < n5; ++n3) {
            n4 = n3;
            E e2 = this.data.get(n3);
            if (n3 > n2 && this.comp.compare(e, e2) != 0) {
                --n4;
                n4 = -n4 - 1;
                break;
            }
            if (e.equals(e2)) break;
        }
        if (n3 == n5) {
            n4 = -n4 - 1;
        }
        return n4;
    }

    public int findEqualObject(E e) {
        int n = -1;
        int n2 = Collections.binarySearch(this.data, e, this.comp);
        if (n2 >= 0) {
            n = this.firstMatchingRow(e, n2);
            n = this.nextEqualRow(n, e, n2);
        }
        return n;
    }

    public int nextSameRow(int n, E e, int n2) {
        int n3;
        int n4 = -1;
        if (n < 0) {
            return n4;
        }
        int n5 = this.data.size();
        if (n >= n5) {
            return n4;
        }
        for (n3 = n; n3 < n5; ++n3) {
            n4 = n3;
            E e2 = this.data.get(n3);
            if (n3 > n2 && this.comp.compare(e, e2) != 0) {
                --n4;
                n4 = -n4 - 1;
                break;
            }
            if (e == e2) break;
        }
        if (n3 == n5) {
            n4 = -n4 - 1;
        }
        return n4;
    }

    public int add(E e) {
        return this.add(e, false, true);
    }

    public int add(E e, boolean bl) {
        return this.add(e, bl, true);
    }

    public int add(E e, boolean bl, boolean bl2) {
        int n;
        int n2 = Collections.binarySearch(this.data, e, this.comp);
        if (n2 >= 0) {
            n = n2;
            if (!bl) {
                this.add(n, e, bl2);
            } else {
                n2 = this.firstMatchingRow(e, n);
                if ((n2 = this.nextEqualRow(n2, e, n)) >= 0) {
                    n = n2;
                }
                this.add(n, e, bl2);
            }
        } else {
            n = -(n2 + 1);
            this.add(n, e, bl2);
        }
        return n;
    }

    public void add(int n, E e) {
        this.add(n, e, true);
    }

    public void add(int n, E e, boolean bl) {
        if (e == null) {
            throw new IllegalArgumentException("Cannot add null row to: " + n);
        }
        if (db.on()) {
            db.println("adding at " + n + " row obj: " + e + (bl ? " - view will be updated" : ""));
        }
        this.data.add(n, e);
        this.fireBulkRowAdded(n, e);
        if (bl) {
            this.fireBulkUpdateView();
        }
    }

    public void ensureCapacity(int n) {
        ArrayList arrayList = ListRowDataSource.cast(ArrayList.class, this.data);
        if (arrayList != null) {
            arrayList.ensureCapacity(n);
        }
    }

    public int remove(E e) {
        int n = -1;
        if (e == null) {
            return n;
        }
        int n2 = this.findMatchingRow(e);
        int n3 = this.firstMatchingRow(e, n2);
        if ((n3 = this.nextSameRow(n3, e, n2)) >= 0) {
            n = n3;
            int n4 = n3;
            this.remove(n4, e);
        }
        return n;
    }

    public void remove(int n, E e) {
        if (n < 0 || n >= this.data.size()) {
            return;
        }
        if (db.on()) {
            db.println("removing at " + n + " row obj: " + e);
        }
        this.dispose(e);
        E e2 = this.data.remove(n);
        if (db.on()) {
            db.println("...removed item was: " + e2);
        }
        this.fireBulkRowDeleted(n, e);
        this.fireBulkUpdateView();
    }

    @Override
    public int remove(int[] nArray) {
        int n = 0;
        if (nArray == null || nArray.length == 0) {
            return n;
        }
        Arrays.sort(nArray);
        int n2 = this.data.size();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 >= n2) continue;
            ++n;
            E e = this.data.get(n3);
            this.data.remove(n3);
            this.fireBulkRowDeleted(n3, e);
        }
        if (nArray.length > 0) {
            this.fireBulkUpdateView();
        }
        return n;
    }

    @Override
    public int findSame(Object object) {
        int n = -1;
        E e = this.cast(object);
        if (e == null) {
            return n;
        }
        int n2 = this.findMatchingRow(e);
        int n3 = this.firstMatchingRow(e, n2);
        n = this.nextSameRow(n3, e, n2);
        return n;
    }

    public boolean replace(E e, E e2) {
        if (e == null || e2 == null || e == e2) {
            return false;
        }
        int n = this.findMatchingRow(e2);
        int n2 = this.firstMatchingRow(e2, n);
        if ((n2 = this.nextSameRow(n2, e2, n)) >= 0) {
            return false;
        }
        n = this.findMatchingRow(e);
        int n3 = this.firstMatchingRow(e, n);
        n3 = this.nextSameRow(n3, e, n);
        if (e.equals(e2)) {
            this.replace(n3, e2);
            return true;
        }
        this.add(n2, e2);
        if (n2 <= n3) {
            ++n3;
        }
        this.remove(n3, e);
        return true;
    }

    public int replace(int n, E e) {
        int n2 = n;
        if (e == null) {
            return n2;
        }
        E e2 = this.data.get(n);
        if (db.on()) {
            db.println("replace(" + n + ", " + e + ")");
            db.println("...oldObj: " + e2);
        }
        if (e2 == e) {
            if (db.on()) {
                db.println("DUP of: " + e2);
            }
        } else if (e2.equals(e)) {
            if (db.on()) {
                db.println("EQUAL swap of " + e2 + " for: " + e);
            }
            this._replace(n, e, e2, false);
            this.dispose(e2);
        } else {
            int n3;
            n2 = n3 = this.add(e, true, false);
            if (n == n3) {
                int n4 = n + 1;
                if (db.on()) {
                    db.println("removing at " + n4);
                }
                e2 = this.data.get(n4);
                this.dispose(e2);
                this.data.remove(n4);
                this.fireBulkRowDeleted(n4, e2);
            } else {
                int n5 = this.findMatchingRow(e2);
                int n6 = this.firstMatchingRow(e2, n5);
                n6 = this.nextSameRow(n6, e2, n5);
                if (db.on()) {
                    db.println("removing at " + n6);
                }
                e2 = this.data.get(n6);
                this.dispose(e2);
                this.data.remove(n6);
                if (n6 < n2) {
                    --n2;
                }
                this.fireBulkRowDeleted(n6, e2);
            }
        }
        this.fireBulkUpdateView();
        return n2;
    }

    private void _replace(int n, E e, E e2, boolean bl) {
        if (db.on()) {
            db.println("_replace(" + n + ", " + e);
        }
        this.data.set(n, e);
        e2 = e2 != null ? e2 : this.data.get(n);
        this.fireBulkRowUpdated(n, e2, e);
        if (bl) {
            this.fireBulkUpdateView();
        }
    }

    public void notifyChange(E e) {
        int n = this.findEqualObject(e);
        this.notifyChange(n, e);
    }

    public void notifyChange(int n, E e) {
        if (n >= 0) {
            this.fireBulkRowUpdated(n, e, e);
            this.fireBulkUpdateView();
        }
    }
}

