/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui.row;

import cerent.util.IDisposable;
import cerent.util.gui.row.ColumnEditor;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.RowDataSourceListener;
import cerent.util.gui.row.TableUpdateLogic;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RowTableModel
extends AbstractTableModel
implements RowDataSourceListener,
TableCellRenderer {
    protected RowDataSource source;
    protected TableColumnModel colModel;
    protected ColumnRenderer[] colRenderers;
    protected boolean hasEditableColumn;
    protected HashMap minColumsWidthsMap;
    protected Class rowObjectClass;
    private static final JLabel emptyLabel = new JLabel();
    protected TableUpdateLogic updateLogic = new TableUpdateLogic();

    public RowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray, Class clazz) {
        this.setDataSource(rowDataSource);
        this.rowObjectClass = clazz;
        this.setColumnRenderers(columnRendererArray);
    }

    public void setColumnRenderers(ColumnRenderer[] columnRendererArray) {
        int n;
        this.colRenderers = columnRendererArray;
        this.hasEditableColumn = false;
        for (n = 0; n < columnRendererArray.length; ++n) {
            if (!(columnRendererArray[n] instanceof ColumnEditor)) continue;
            this.hasEditableColumn = true;
            break;
        }
        this.minColumsWidthsMap = new HashMap(columnRendererArray.length);
        for (n = 0; n < columnRendererArray.length; ++n) {
            this.minColumsWidthsMap.put(columnRendererArray[n].getName(), new Integer(columnRendererArray[n].getWidth()));
        }
        this.dataStructureChanged();
    }

    public RowTableModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray) {
        this(rowDataSource, columnRendererArray, rowDataSource.getClass());
    }

    public void release() {
        if (this.source != null) {
            this.source.removeRowDataSourceListener(this);
            this.source = null;
        }
        this.minColumsWidthsMap.clear();
    }

    public void setDataSource(RowDataSource rowDataSource) {
        if (rowDataSource != null) {
            if (this.source != null) {
                this.source.removeRowDataSourceListener(this);
            }
            this.source = rowDataSource;
            this.source.addRowDataSourceListener(this);
            this.dataSourceChanged();
        }
    }

    public RowDataSource getDataSource() {
        return this.source;
    }

    public void initTable(JTable jTable) {
        jTable.setDefaultRenderer(this.rowObjectClass, this);
        this.colModel = jTable.getColumnModel();
        int n = 10;
        for (int i = 0; i < Math.min(this.getColumnCount(), this.colModel.getColumnCount()); ++i) {
            TableColumn tableColumn = this.colModel.getColumn(i);
            int n2 = this.colModel.getColumn(i).getModelIndex();
            ColumnRenderer columnRenderer = this.getColumnRenderer(n2);
            if (columnRenderer instanceof ColumnEditor) {
                tableColumn.setCellEditor((ColumnEditor)columnRenderer);
            }
            ColumnRenderer columnRenderer2 = this.getColumnRenderer(i);
            n = columnRenderer2.getWidth();
            tableColumn.setResizable(columnRenderer2.isResizable());
            if (!columnRenderer2.isResizable()) {
                tableColumn.setMaxWidth(n);
            }
            tableColumn.setMinWidth((Integer)this.minColumsWidthsMap.get(columnRenderer2.getName()));
            tableColumn.setPreferredWidth(n);
        }
    }

    protected ColumnRenderer getColumnRenderer(int n) {
        return this.colRenderers[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.source != null) {
            return this.source.getObjectAtRow(n);
        }
        return null;
    }

    public void setColumnValue(Object object, int n, Object object2) {
        ColumnEditor columnEditor = this.getColumnEditor(n);
        if (columnEditor != null) {
            columnEditor.setColumnValue(object, object2);
        }
    }

    public Object clone(Object object) {
        Object object2 = object;
        if (this.source != null) {
            object2 = this.source.clone(object);
        }
        return object2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2;
        Object object3;
        int n3 = -1;
        if (this.source != null && (object3 = this.source.clone(object2 = this.source.getObjectAtRow(n))) != null) {
            this.setColumnValue(object3, n2, object);
            if (object2 instanceof IDisposable && object3 != object2) {
                ((IDisposable)object2).dispose();
            }
            this.makeSelectedRow(object3, n3, (n3 = this.source.setObjectAtRow(n, object3)) < 0 ? n3 : n3 + 1);
        }
    }

    public void remove(int[] nArray) {
        if (this.source != null) {
            this.source.remove(nArray);
        }
    }

    public void dispose() {
        if (this.source instanceof IDisposable) {
            ((IDisposable)((Object)this.source)).dispose();
        }
    }

    @Override
    public int getRowCount() {
        if (this.source != null) {
            return this.source.getRowCount();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.colRenderers.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.colRenderers[n].getName();
    }

    public Class getColumnClass(int n) {
        return this.rowObjectClass;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return emptyLabel;
        }
        int n3 = this.colModel.getColumn(n2).getModelIndex();
        return this.getColumnRenderer(n3).getTableCellRendererComponent(jTable, object, bl, bl2, n, n3);
    }

    protected ColumnEditor getColumnEditor(int n) {
        ColumnRenderer columnRenderer = this.getColumnRenderer(n);
        return columnRenderer instanceof ColumnEditor ? (ColumnEditor)columnRenderer : null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        ColumnRenderer columnRenderer = this.getColumnRenderer(n2);
        boolean bl = false;
        if (columnRenderer instanceof ColumnEditor) {
            ColumnEditor columnEditor = (ColumnEditor)columnRenderer;
            bl = columnEditor.isCellEditable();
        }
        return bl;
    }

    @Override
    public void rowsAdded(int n, int n2) {
        this.fireTableRowsInserted(n, n2);
    }

    @Override
    public void dataStructureChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public void dataSourceChanged() {
        this.fireTableDataChanged();
    }

    @Override
    public void rowsUpdated(int n, int n2) {
        this.fireTableRowsUpdated(n, n2);
    }

    @Override
    public void rowsDeleted(int n, int n2) {
        this.fireTableRowsDeleted(n, n2);
        this.fireTableDataChanged();
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    @Override
    public void fireTableChanged(final TableModelEvent tableModelEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.fireTableChanged(tableModelEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RowTableModel.this.fireTableChanged(tableModelEvent);
                }
            });
        }
    }

    @Override
    public void bulkRowAdded(int n, Object object) {
        this.updateLogic.rowAdded(n);
    }

    @Override
    public void bulkRowUpdated(int n, Object object, Object object2) {
        this.updateLogic.rowUpdated(n);
    }

    @Override
    public void bulkRowDeleted(int n, Object object) {
        this.updateLogic.rowRemoved(n);
    }

    @Override
    public void bulkDataSourceChanged() {
        this.updateLogic.tableDataChanged();
    }

    @Override
    public void bulkUpdateView() {
        this.updateLogic.updateView(this);
    }

    protected void makeSelectedRow(Object object) {
    }

    protected void makeSelectedRow(Object object, int n, int n2) {
    }
}

