/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.job;

public class FIFOQueue {
    private Object[] queue;
    private int capacity;
    private int size;
    private int head;
    private int tail;

    public FIFOQueue(int n) {
        this.capacity = n > 0 ? n : 1;
        this.queue = new Object[n];
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    public synchronized void add(Object object) throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
        this.queue[this.head] = object;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        this.notifyAll();
    }

    public synchronized Object remove() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        Object object = this.queue[this.tail];
        this.queue[this.tail] = null;
        this.tail = (this.tail + 1) % this.capacity;
        --this.size;
        this.notifyAll();
        return object;
    }

    public synchronized Object[] removeAll() throws InterruptedException {
        Object[] objectArray = new Object[this.size];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.remove();
        }
        return objectArray;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean isFull() {
        return this.size == this.capacity;
    }

    public int getStart() {
        return this.head > this.tail ? this.tail : this.head;
    }

    public int getEnd() {
        return this.tail > this.head ? this.tail : this.head;
    }

    public Object get(int n) {
        try {
            return this.queue[n];
        }
        catch (Exception exception) {
            return null;
        }
    }
}

