/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.job;

import cerent.util.gui.MultiLineLabelUI;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JobProgressPanel
extends JPanel
implements ActionListener,
IJobProgressControl {
    private static final String CANCEL = "Cancel";
    private JButton cancelButton;
    private JProgressBar progressBar;
    private IJobControl job = null;
    private JobGroup group = null;
    private JobController jc = null;
    private JLabel label;
    private String lblText;
    private Timer incTimer;
    private int p;

    public JobProgressPanel(String string) {
        this(string, false);
    }

    public JobProgressPanel(String string, boolean bl) {
        this(string, bl, 0);
    }

    public JobProgressPanel(String string, boolean bl, int n) {
        this.init(string, bl, n);
    }

    protected void init(String string, boolean bl, int n) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.label = new JLabel(string);
        this.label.setUI(new MultiLineLabelUI());
        this.add(this.label);
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        if (bl) {
            this.addCancelAction();
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.cancelButton = new JButton(CANCEL);
            this.cancelButton.addActionListener(this);
            jPanel.add(this.cancelButton);
            jPanel.add(this.progressBar);
            this.add(jPanel);
        } else {
            this.add(this.progressBar);
        }
        if (n > 0) {
            this.setAnimatedTime(n);
        }
    }

    protected void addCancelAction() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.incTimer) {
            int n = this.progressBar.getValue() + 10;
            this.setPercentCompleted(n > 100 ? 0 : n);
        } else {
            this.onCancel();
        }
    }

    public void setJob(IJobControl iJobControl) {
        this.job = iJobControl;
    }

    public IJobControl getJob() {
        return this.job;
    }

    public void setGroupAndController(JobGroup jobGroup, JobController jobController) {
        this.group = jobGroup;
        this.jc = jobController;
    }

    public JobGroup getGroup() {
        return this.group;
    }

    public JobController getController() {
        return this.jc;
    }

    public void onCancel() {
        if (this.job != null) {
            this.cancelButton.setEnabled(false);
            this.setProgressText("Canceling, please wait...");
            this.job.abortJob();
        } else if (this.group != null && this.jc != null) {
            this.cancelButton.setEnabled(false);
            this.setProgressText("Canceling group, please wait...");
            this.jc.abortJob(this.group);
        }
    }

    private void setAnimatedTime(int n) {
        if (n == 0) {
            return;
        }
        if (this.incTimer != null) {
            this.incTimer.stop();
        }
        this.incTimer = new Timer(n, this);
        this.progressBar.setStringPainted(false);
        this.incTimer.start();
    }

    @Override
    public void setPercentCompleted(int n) {
        if (this.p == n) {
            return;
        }
        this.p = n;
        if (this.p > 100) {
            this.p = 100;
        } else if (this.p < 0) {
            this.p = 0;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (JobProgressPanel.this.cancelButton != null && JobProgressPanel.this.p == 100) {
                        JobProgressPanel.this.cancelButton.setEnabled(false);
                    }
                    JobProgressPanel.this.progressBar.setValue(JobProgressPanel.this.p);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void setProgressText(String string) {
        this.lblText = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JobProgressPanel.this.label.setText(JobProgressPanel.this.lblText);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void dispose() {
        if (this.incTimer != null) {
            this.incTimer.stop();
        }
    }
}

