/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.job;

import cerent.util.KDebug;
import cerent.util.job.FIFOQueue;
import cerent.util.job.JobController;
import cerent.util.job.JobInfo;
import cerent.util.job.JobStatus;

public class JobWorker {
    private FIFOQueue taskQueue;
    private Thread taskThread;
    private JobController jc;
    private volatile boolean noStopRequested;
    private boolean busy = false;
    private String threadName = "";
    private static final KDebug db = new KDebug("JobWorker");

    public JobWorker(JobController jobController, int n) {
        this.jc = jobController;
        this.taskQueue = new FIFOQueue(1);
        this.threadName = "Job Worker " + String.valueOf(n);
        this.noStopRequested = true;
        this.taskThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JobWorker.this.runJob();
                }
                catch (Exception exception) {
                    JobWorker.this.println(exception);
                }
            }
        }, this.threadName);
        this.taskThread.start();
    }

    public void executeJob(JobInfo jobInfo) throws InterruptedException {
        this.busy = true;
        this.taskThread.setName(this.taskThread.getName() + ": " + jobInfo.getJob().getName());
        this.taskQueue.add(jobInfo);
    }

    private void runJob() {
        try {
            this.jc.addThreadToPool(this);
        }
        catch (Exception exception) {
            this.println(exception);
        }
        while (this.noStopRequested) {
            try {
                this.runIt((JobInfo)this.taskQueue.remove());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                this.println(exception);
            }
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIt(JobInfo jobInfo) {
        this.println(this.taskThread.getName() + " - running job");
        JobStatus jobStatus = null;
        try {
            jobInfo.jobStatusChange(new JobStatus(1));
            jobStatus = jobInfo.getJob().executeJob();
        }
        catch (Exception exception) {
            this.println(exception);
            jobStatus = new JobStatus(2);
            jobStatus.setResult(exception);
        }
        finally {
            try {
                Thread.interrupted();
                this.println(this.taskThread.getName() + " - done running");
                this.taskThread.setName(this.threadName);
                this.jc.addThreadToPool(this);
                this.busy = false;
                this.jc.decJob();
            }
            catch (Exception exception) {
                this.println(exception);
            }
            try {
                if (jobStatus == null) {
                    jobStatus = new JobStatus(2);
                }
                jobInfo.jobStatusChange(jobStatus);
            }
            catch (Exception exception) {
                this.println(exception);
            }
        }
    }

    public void stopRequest() {
        this.noStopRequested = false;
        this.taskThread.interrupt();
    }

    public boolean isAlive() {
        return this.taskThread.isAlive();
    }

    private void println(Exception exception) {
        if (JobWorker.db.on) {
            KDebug.printStackTrace((Throwable)exception);
        }
    }

    private void println(String string) {
        if (JobWorker.db.on) {
            db.println(string);
        }
    }

    String getName() {
        return this.threadName;
    }
}

