/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.matcher;

import cerent.util.matcher.AbstractFieldMatcher;
import cerent.util.matcher.FieldMethod;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class StringFieldMatcher
extends AbstractFieldMatcher {
    public static final int EQUALITY_MATCHING = 1;
    public static final int SUBSTRING_MATCHING = 2;
    public static final int SIMPLE_REGEX_MATCHING = 3;
    public static final int PERL5_REGEX_MATCHING = 4;
    public static final int BASIC_REGEX_MATCHING = 5;
    public static final int PREFIX_MATCHING = 6;
    public static final int SUFFIX_MATCHING = 7;
    protected String origCriteria_;
    protected String criteria_;
    protected int criteriaLen_;
    protected int matchingType_;
    protected boolean isCaseSensitive_;
    protected IAccessor accessor_;
    protected PatternCompiler compiler_;
    protected PatternMatcher matcher_;
    protected Pattern regexPattern_;

    public StringFieldMatcher(String string, String string2, int n, boolean bl, IAccessor iAccessor, FieldMethod fieldMethod) {
        super(string, 2, fieldMethod);
        this.setCriteria(string2);
        this.setMatchingType(n);
        this.setCaseSensitivity(bl);
        this.accessor_ = iAccessor;
    }

    public void setCriteria(String string) {
        this.criteria_ = this.origCriteria_ = string;
        int n = this.criteriaLen_ = this.criteria_ == null ? 0 : this.criteria_.length();
        if (this.matchingType_ == 2 && !this.isCaseSensitive_) {
            this.criteria_ = this.criteria_.toLowerCase();
        }
    }

    public void setMatchingType(int n) {
        if (this.criteria_ == null) {
            return;
        }
        if (n != 2) {
            this.criteria_ = this.origCriteria_;
        }
        this.matchingType_ = n;
        if (this.matchingType_ == 2 && !this.isCaseSensitive_) {
            this.criteria_ = this.criteria_.toLowerCase();
        }
        int n2 = 0;
        switch (n) {
            case 4: {
                this.matcher_ = new Perl5Matcher();
                this.compiler_ = new Perl5Compiler();
                n2 = !this.isCaseSensitive_ ? 1 : 0;
                break;
            }
            case 5: {
                this.matcher_ = new Perl5Matcher();
                this.compiler_ = new GlobCompiler();
                n2 = !this.isCaseSensitive_ ? 1 : 0;
                break;
            }
            default: {
                this.matcher_ = null;
                this.compiler_ = null;
                this.regexPattern_ = null;
            }
        }
        if (this.compiler_ != null) {
            try {
                this.regexPattern_ = this.compiler_.compile(this.origCriteria_, n2);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new IllegalStateException("bad regex(" + malformedPatternException.getMessage() + "): '" + this.origCriteria_ + "'");
            }
        }
    }

    public void setCaseSensitivity(boolean bl) {
        if (this.criteria_ == null) {
            return;
        }
        if (this.matchingType_ == 2 && bl) {
            this.criteria_ = this.origCriteria_;
        }
        this.isCaseSensitive_ = bl;
        if (this.matchingType_ == 2 && !this.isCaseSensitive_) {
            this.criteria_ = this.criteria_.toLowerCase();
        }
    }

    public static boolean doesContainSimpleWildcard(String string) {
        boolean bl = false;
        if (string != null) {
            char c;
            int n = string.length();
            for (int i = 0; i < n && !bl; bl |= (c = string.charAt(i)) == '*' || c == '?', ++i) {
            }
        }
        return bl;
    }

    @Override
    public boolean doesMatch(Object object) {
        boolean bl = !this.isEnabled();
        Object var4_3 = null;
        if (this.isEnabled()) {
            String string = this.accessor_ == null ? (String)object : this.accessor_.getAttribute(object);
            switch (this.matchingType_) {
                case 1: {
                    if (this.isCaseSensitive_) {
                        bl = this.criteria_.compareTo(string) == 0;
                        break;
                    }
                    bl = this.criteria_.compareToIgnoreCase(string) == 0;
                    break;
                }
                case 2: {
                    if (!this.isCaseSensitive_) {
                        string = string.toLowerCase();
                    }
                    bl = string.indexOf(this.criteria_) >= 0;
                    break;
                }
                case 6: {
                    if (!this.isCaseSensitive_) {
                        bl = string.toLowerCase().startsWith(this.criteria_.toLowerCase());
                        break;
                    }
                    bl = string.startsWith(this.criteria_);
                    break;
                }
                case 7: {
                    if (!this.isCaseSensitive_) {
                        bl = string.toLowerCase().endsWith(this.criteria_.toLowerCase());
                        break;
                    }
                    bl = string.endsWith(this.criteria_);
                    break;
                }
                case 3: {
                    bl = StringFieldMatcher.simpleRegexStringMatch(this.criteria_, this.criteriaLen_, string, this.isCaseSensitive_);
                    break;
                }
                case 4: 
                case 5: {
                    bl = this.matcher_.contains(string, this.regexPattern_);
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected static boolean simpleRegexStringMatch(String string, int n, String string2, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = string == null;
        if (bl3 || string.equals("*")) {
            bl2 = !bl3 || string2 == null;
        } else {
            int n2 = string.indexOf("*");
            if (0 >= n2 || n2 >= n - 1) {
                bl2 = n2 > 0 ? StringFieldMatcher.stringMatch(string.substring(0, n - 1), string2, true, bl) : StringFieldMatcher.stringMatch(string, string2, false, bl);
            }
        }
        return bl2;
    }

    protected static boolean stringMatch(String string, String string2, boolean bl, boolean bl2) {
        int n;
        boolean bl3 = false;
        if (string == null) {
            return string2 == null;
        }
        int n2 = string2 == null ? 0 : string2.length();
        int n3 = string.length();
        bl3 = n3 == 0 ? string2 != null && (bl || n2 == 0) : true;
        for (n = 0; n < n3 && bl3; ++n) {
            if (n >= n2) {
                bl3 = false;
                continue;
            }
            char c = string.charAt(n);
            if (bl2) {
                bl3 = c == string2.charAt(n) || c == '?';
            }
            bl3 = Character.toLowerCase(c) == Character.toLowerCase(string2.charAt(n)) || c == '?';
        }
        if (n < n2) {
            bl3 &= bl;
        }
        return bl3;
    }

    public IAccessor getIAccessor() {
        return this.accessor_;
    }

    @Override
    public Object getCriteria() {
        return this.criteria_;
    }

    public Object getOrigCriteria() {
        return this.origCriteria_;
    }

    public static interface IAccessor {
        public String getAttribute(Object var1);
    }
}

