/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.tty.CLIError;
import cerent.util.tty.CLIHelp;
import cerent.util.tty.CLIHelpEntry;
import cerent.util.tty.ICLIError;
import cerent.util.tty.ICLIHelp;
import cerent.util.tty.ICLIHelpEntry;
import cerent.util.tty.ICLIXMLTags;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CLIParsingUtils
implements ICLIXMLTags {
    public static final String COMMON_ERROR_PREFIX = "%";
    private static KDebug kdbg = new KDebug("CLIParsingUtils");
    private static final int NO_SYNTAX_ERROR = 0;
    private static final String XML_ERRORMSG = "ErrorMsg=\n";
    public static final String[] ERROR_PREFIXES = new String[]{"%", "Syntax/Authorization errors in one or more commands", "Can not enter exclusive mode.", "'CfgMgr' detected the 'fatal' condition 'The Configuration Namespace is locked by another agent.'"};

    public static ICLIError[] getErrors(String string) {
        ICLIError[] iCLIErrorArray = new ICLIError[]{};
        ArrayList<CLIError> arrayList = new ArrayList<CLIError>();
        if (kdbg.on()) {
            kdbg.println("Entire CLI response : " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (CLIParsingUtils.lineIsErrorLine(string4)) {
                String string5;
                if (kdbg.on()) {
                    kdbg.println("Found error : " + string4);
                }
                String string6 = null;
                if (kdbg.on()) {
                    kdbg.println("Prev line : " + string2);
                }
                if (string2 != null && string2.trim().equals("^")) {
                    if (kdbg.on()) {
                        kdbg.println("Prev line was caret");
                        kdbg.println("Line before prev line : " + string3);
                    }
                    string6 = string2;
                    string5 = string3;
                } else {
                    string5 = string2;
                }
                if (string5 != null) {
                    string5 = string5.trim();
                }
                arrayList.add(new CLIError(string5, string4, string6));
            }
            string3 = string2;
            string2 = string4;
        }
        if (arrayList.size() > 0) {
            iCLIErrorArray = arrayList.toArray(new ICLIError[arrayList.size()]);
        }
        return iCLIErrorArray;
    }

    public static String convertXmlString(String string) {
        return string.replaceAll("&apos;", "'");
    }

    public static ICLIError[] getXmlErrors(String string) {
        ICLIError[] iCLIErrorArray = null;
        ArrayList<CLIError> arrayList = new ArrayList<CLIError>();
        if (kdbg.on()) {
            kdbg.println("Entire CLI response : " + string);
        }
        int n = 0;
        while (n < string.length() && (n = string.indexOf(XML_ERRORMSG, n)) >= 0) {
            int n2 = string.indexOf("\"", n);
            String string2 = string.substring(n, n2);
            arrayList.add(new CLIError(string2, string2, null));
            n = n2;
        }
        if (arrayList.size() > 0) {
            iCLIErrorArray = arrayList.toArray(new ICLIError[arrayList.size()]);
        }
        return iCLIErrorArray;
    }

    private static boolean lineIsErrorLine(String string) {
        boolean bl = false;
        for (int i = 0; i < ERROR_PREFIXES.length; ++i) {
            if (!string.startsWith(ERROR_PREFIXES[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static ICLIHelp getCLIHelp(String string) {
        CLIHelp cLIHelp = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (stringTokenizer.countTokens() > 0) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("  ")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string);
                ICLIHelpEntry[] iCLIHelpEntryArray = new CLIHelpEntry[stringTokenizer2.countTokens()];
                int n = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    iCLIHelpEntryArray[n] = new CLIHelpEntry(stringTokenizer2.nextToken(), null);
                    ++n;
                }
                cLIHelp = new CLIHelp(0, iCLIHelpEntryArray);
            } else {
                int n = 0;
                StringTokenizer stringTokenizer3 = new StringTokenizer(string, "\n");
                ICLIHelpEntry[] iCLIHelpEntryArray = new CLIHelpEntry[stringTokenizer3.countTokens()];
                while (stringTokenizer3.hasMoreTokens()) {
                    String string3 = stringTokenizer3.nextToken();
                    if (string3.length() <= 0) continue;
                    int n2 = (string3 = string3.trim()).indexOf("  ");
                    iCLIHelpEntryArray[n] = n2 != -1 ? new CLIHelpEntry(string3.substring(0, n2).trim(), string3.substring(n2, string3.length()).trim()) : new CLIHelpEntry(string3, null);
                    ++n;
                }
                cLIHelp = new CLIHelp(0, iCLIHelpEntryArray);
            }
        }
        return cLIHelp;
    }

    public static String encloseCLICommandInXML(String string) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Exec>" + string + "</Exec>" + "</CLI>" + "</Request>";
    }

    public static String extractCLIResponseFromXMLBody(String string) {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(string.getBytes()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            KDebug.printStackTrace((Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            KDebug.printStackTrace((Throwable)sAXException);
        }
        catch (IOException iOException) {
            KDebug.printStackTrace((Throwable)iOException);
        }
        if (document == null) {
            kdbg.println("Error while extracting CLI body from XML command: dom==null");
            return null;
        }
        object = document.getDocumentElement();
        NodeList nodeList = object.getElementsByTagName("Exec");
        if (nodeList == null || nodeList.getLength() == 0) {
            kdbg.println("Error while extracting CLI body from XML command: <Exec> not found");
            return null;
        }
        String string2 = ((Element)nodeList.item(0)).getTextContent();
        return string2;
    }
}

