/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import com.cisco.crs.model.PlimPortId;
import java.io.IOException;

public class CLISetTTIAction
extends CLIAction {
    private static final String OTU = "otu";
    private static final String OVERHEAD = "overhead";
    private static final String TTI = "tti";
    private static final String SENT = "sent";
    private static final String EXPECTED = "expected";
    private static final String ASCII = "ascii";
    private static final String G709 = "g709";
    private static final String RESET = "reset";
    private static String cmdExpTTISet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\ng709 otu overhead tti expected ascii _Parameter2_\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdExpTTIReset = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nno g709 otu overhead tti expected ascii reset\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdSentTTISet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\ng709 otu overhead tti sent ascii _Parameter2_\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdSentTTIReset = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nno g709 otu overhead tti sent ascii reset\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";

    public CLISetTTIAction(String string) {
        super(string);
        this.cliCmd = new CLICmdRsp[1];
    }

    public CLISetTTIAction(ITTYSession iTTYSession) {
        this(iTTYSession.getHostname());
    }

    public boolean setExpectedTTI(String string, String string2) {
        boolean bl = false;
        String string3 = cmdExpTTISet.replaceAll("_Parameter_", string).replaceAll("_Parameter2_", string2);
        this.cliCmd[0] = new CLICmdRsp(string3, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean resetExpectedTTI(String string) {
        boolean bl = false;
        String string2 = cmdExpTTIReset.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean setTransmittedTTI(String string, String string2) {
        boolean bl = false;
        String string3 = cmdSentTTISet.replaceAll("_Parameter_", string).replaceAll("_Parameter2_", string2);
        this.cliCmd[0] = new CLICmdRsp(string3, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean resetTransmittedTTI(String string) {
        boolean bl = false;
        String string2 = cmdSentTTIReset.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean setExpectedTTI(int n, String string) {
        return this.setExpectedTTI(new PlimPortId(n).toString(), string);
    }

    public boolean resetExpectedTTI(int n) {
        return this.resetExpectedTTI(new PlimPortId(n).toString());
    }

    public boolean setTransmittedTTI(int n, String string) {
        return this.setTransmittedTTI(new PlimPortId(n).toString(), string);
    }

    public boolean resetTransmittedTTI(int n) {
        return this.resetTransmittedTTI(new PlimPortId(n).toString());
    }
}

