/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import cerent.util.tty.TTYSession;
import cerent.util.tty.TTYSessionFactory;
import cerent.util.tty.TTYSessionsPool;
import de.mud.jta.ICliSession;
import java.io.IOException;

public class CLITTYSession
extends TTYSession {
    public CLITTYSession(ICliSession iCliSession, TTYSessionsPool tTYSessionsPool) {
        super(iCliSession, tTYSessionsPool);
    }

    @Override
    public String sendCommand(String string) throws IOException, TTYException {
        String[] stringArray = new String[1];
        if (this.cliSession == null) {
            this.startLogToMyPool("Disposed CLI session found, " + string + " aborted.");
            this.dispose();
            throw new TTYException("Command executed on invalid CLITTYSession, null cli session: " + string);
        }
        try {
            this.startLogToMyPool("Send " + string);
            if (this.cliSession.sendCommand(string, expected_prompts, null, null, 0, stringArray, null)) {
                this.stopLogToMyPool("Sent " + string, stringArray[0]);
                return stringArray[0];
            }
            this.stopLogToMyPool("Sent " + string + "\n FAILED", stringArray[0]);
            throw new TTYException(string + "\n" + stringArray[0]);
        }
        catch (IOException iOException) {
            this.stopLogToMyPool("Sent " + string + "\n FAILED for IOException " + iOException.getMessage(), null);
            this.dispose();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendCommand(String string, boolean bl) throws TTYException, IOException {
        String string2;
        if ("xml".equals(string)) {
            return "";
        }
        if ("exit".equals(string)) {
            return "";
        }
        if (!bl) {
            return this.sendCommand(string);
        }
        ITTYSession iTTYSession = TTYSessionFactory.instance().getSession(this.hostname, TTYSessionFactory.SessionType.XML);
        try {
            string2 = iTTYSession.sendCommand(string);
        }
        finally {
            iTTYSession.releaseMe();
        }
        return string2;
    }
}

