/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CLIUserTasksAction
extends CLIAction {
    private KDebug db;
    private static final String COMMAND = "show user tasks";

    public CLIUserTasksAction(ITTYSession iTTYSession, KDebug kDebug) {
        this(iTTYSession.getHostname(), kDebug);
    }

    public CLIUserTasksAction(String string, KDebug kDebug) {
        super(string);
        this.db = kDebug;
        this.cliCmd = new CLICmdRsp[1];
    }

    public List<TaskInfo> getUserTasks() {
        this.cliCmd[0] = new CLICmdRsp(COMMAND, false);
        try {
            if (super.performAction(this.cliCmd[0])) {
                if (this.db.on()) {
                    this.db.println("failed to send command");
                }
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (TTYException tTYException) {
            return null;
        }
        String[] stringArray = this.cliCmd[0].getResponse().split("\\n");
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>();
        for (String string : stringArray) {
            String[] stringArray2 = string.split(":");
            if (stringArray2.length != 3 || !stringArray2[0].trim().equals("Task")) continue;
            arrayList.add(new TaskInfo(stringArray2[1].trim(), stringArray2[2]));
        }
        return arrayList;
    }

    public class TaskInfo {
        private boolean read;
        private boolean write;
        private boolean exec;
        private boolean debug;
        private String name;

        TaskInfo(String string, String string2) {
            this.name = string;
            this.read = string2.indexOf("READ") != -1;
            this.write = string2.indexOf("WRITE") != -1;
            this.exec = string2.indexOf("EXECUTE") != -1;
            this.debug = string2.indexOf("DEBUG") != -1;
        }

        public String getName() {
            return this.name;
        }

        public boolean canRead() {
            return this.read;
        }

        public boolean canWrite() {
            return this.write;
        }

        public boolean canExecute() {
            return this.exec;
        }

        public boolean canDebug() {
            return this.debug;
        }
    }
}

